/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttributesCopier;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbClusterSnapshotDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbClusterSnapshotDetails> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::availabilityZones)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotCreateTime").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::snapshotCreateTime)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::snapshotCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::engine)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::allocatedStorage)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::status)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::port)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::vpcId)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> CLUSTER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterCreateTime").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::clusterCreateTime)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::clusterCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::masterUsername)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::engineVersion)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::licenseModel)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotType").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::snapshotType)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()}).build();
    private static final SdkField<Integer> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentProgress").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::percentProgress)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::storageEncrypted)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::kmsKeyId)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterIdentifier").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::dbClusterIdentifier)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterSnapshotIdentifier").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::dbClusterSnapshotIdentifier)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::dbClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterSnapshotIdentifier").build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IamDatabaseAuthenticationEnabled").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::iamDatabaseAuthenticationEnabled)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>> DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DbClusterSnapshotAttributes").getter(AwsRdsDbClusterSnapshotDetails.getter(AwsRdsDbClusterSnapshotDetails::dbClusterSnapshotAttributes)).setter(AwsRdsDbClusterSnapshotDetails.setter(Builder::dbClusterSnapshotAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterSnapshotAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, SNAPSHOT_CREATE_TIME_FIELD, ENGINE_FIELD, ALLOCATED_STORAGE_FIELD, STATUS_FIELD, PORT_FIELD, VPC_ID_FIELD, CLUSTER_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD, ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, SNAPSHOT_TYPE_FIELD, PERCENT_PROGRESS_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsRdsDbClusterSnapshotDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> availabilityZones;
    private final String snapshotCreateTime;
    private final String engine;
    private final Integer allocatedStorage;
    private final String status;
    private final Integer port;
    private final String vpcId;
    private final String clusterCreateTime;
    private final String masterUsername;
    private final String engineVersion;
    private final String licenseModel;
    private final String snapshotType;
    private final Integer percentProgress;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbClusterIdentifier;
    private final String dbClusterSnapshotIdentifier;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes;

    private AwsRdsDbClusterSnapshotDetails(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.engine = builder.engine;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.snapshotType = builder.snapshotType;
        this.percentProgress = builder.percentProgress;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.dbClusterSnapshotAttributes = builder.dbClusterSnapshotAttributes;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final String snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public final String engine() {
        return this.engine;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String status() {
        return this.status;
    }

    public final Integer port() {
        return this.port;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String licenseModel() {
        return this.licenseModel;
    }

    public final String snapshotType() {
        return this.snapshotType;
    }

    public final Integer percentProgress() {
        return this.percentProgress;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public final Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public final boolean hasDbClusterSnapshotAttributes() {
        return this.dbClusterSnapshotAttributes != null && !(this.dbClusterSnapshotAttributes instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes() {
        return this.dbClusterSnapshotAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterSnapshotAttributes() ? this.dbClusterSnapshotAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbClusterSnapshotDetails)) {
            return false;
        }
        AwsRdsDbClusterSnapshotDetails other = (AwsRdsDbClusterSnapshotDetails)obj;
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && this.hasDbClusterSnapshotAttributes() == other.hasDbClusterSnapshotAttributes() && Objects.equals(this.dbClusterSnapshotAttributes(), other.dbClusterSnapshotAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"AwsRdsDbClusterSnapshotDetails").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("SnapshotCreateTime", (Object)this.snapshotCreateTime()).add("Engine", (Object)this.engine()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("Status", (Object)this.status()).add("Port", (Object)this.port()).add("VpcId", (Object)this.vpcId()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("MasterUsername", (Object)this.masterUsername()).add("EngineVersion", (Object)this.engineVersion()).add("LicenseModel", (Object)this.licenseModel()).add("SnapshotType", (Object)this.snapshotType()).add("PercentProgress", (Object)this.percentProgress()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DbClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DbClusterSnapshotIdentifier", (Object)this.dbClusterSnapshotIdentifier()).add("IamDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("DbClusterSnapshotAttributes", this.hasDbClusterSnapshotAttributes() ? this.dbClusterSnapshotAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "SnapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreateTime()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "PercentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DbClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DbClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "IamDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "DbClusterSnapshotAttributes": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("SnapshotCreateTime", SNAPSHOT_CREATE_TIME_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("ClusterCreateTime", CLUSTER_CREATE_TIME_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("LicenseModel", LICENSE_MODEL_FIELD);
        map.put("SnapshotType", SNAPSHOT_TYPE_FIELD);
        map.put("PercentProgress", PERCENT_PROGRESS_FIELD);
        map.put("StorageEncrypted", STORAGE_ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("DbClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("DbClusterSnapshotIdentifier", DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("IamDatabaseAuthenticationEnabled", IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD);
        map.put("DbClusterSnapshotAttributes", DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbClusterSnapshotDetails, T> g) {
        return obj -> g.apply((AwsRdsDbClusterSnapshotDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String snapshotCreateTime;
        private String engine;
        private Integer allocatedStorage;
        private String status;
        private Integer port;
        private String vpcId;
        private String clusterCreateTime;
        private String masterUsername;
        private String engineVersion;
        private String licenseModel;
        private String snapshotType;
        private Integer percentProgress;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbClusterIdentifier;
        private String dbClusterSnapshotIdentifier;
        private Boolean iamDatabaseAuthenticationEnabled;
        private List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbClusterSnapshotDetails model) {
            this.availabilityZones(model.availabilityZones);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.engine(model.engine);
            this.allocatedStorage(model.allocatedStorage);
            this.status(model.status);
            this.port(model.port);
            this.vpcId(model.vpcId);
            this.clusterCreateTime(model.clusterCreateTime);
            this.masterUsername(model.masterUsername);
            this.engineVersion(model.engineVersion);
            this.licenseModel(model.licenseModel);
            this.snapshotType(model.snapshotType);
            this.percentProgress(model.percentProgress);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.dbClusterSnapshotAttributes(model.dbClusterSnapshotAttributes);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final String getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(String snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(String snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        public final void setClusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final Integer getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        public final void setDbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder> getDbClusterSnapshotAttributes() {
            List<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder> result = AwsRdsDbClusterSnapshotDbClusterSnapshotAttributesCopier.copyToBuilder(this.dbClusterSnapshotAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterSnapshotAttributes(Collection<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.BuilderImpl> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = AwsRdsDbClusterSnapshotDbClusterSnapshotAttributesCopier.copyFromBuilder(dbClusterSnapshotAttributes);
        }

        @Override
        public final Builder dbClusterSnapshotAttributes(Collection<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = AwsRdsDbClusterSnapshotDbClusterSnapshotAttributesCopier.copy(dbClusterSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute ... dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes(Arrays.asList(dbClusterSnapshotAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(Consumer<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder> ... dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes(Stream.of(dbClusterSnapshotAttributes).map(c -> (AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute)((AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder)AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsRdsDbClusterSnapshotDetails build() {
            return new AwsRdsDbClusterSnapshotDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbClusterSnapshotDetails> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder snapshotCreateTime(String var1);

        public Builder engine(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder vpcId(String var1);

        public Builder clusterCreateTime(String var1);

        public Builder masterUsername(String var1);

        public Builder engineVersion(String var1);

        public Builder licenseModel(String var1);

        public Builder snapshotType(String var1);

        public Builder percentProgress(Integer var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder dbClusterSnapshotAttributes(Collection<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> var1);

        public Builder dbClusterSnapshotAttributes(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute ... var1);

        public Builder dbClusterSnapshotAttributes(Consumer<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.Builder> ... var1);
    }
}

