/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsAmazonMqBrokerLdapServerMetadataDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsAmazonMqBrokerLdapServerMetadataDetails> {
    private static final SdkField<List<String>> HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Hosts").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::hosts)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::hosts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hosts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleBase").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::roleBase)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::roleBase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleBase").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::roleName)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<String> ROLE_SEARCH_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleSearchMatching").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::roleSearchMatching)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::roleSearchMatching)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleSearchMatching").build()}).build();
    private static final SdkField<Boolean> ROLE_SEARCH_SUBTREE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RoleSearchSubtree").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::roleSearchSubtree)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::roleSearchSubtree)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleSearchSubtree").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccountUsername").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::serviceAccountUsername)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::serviceAccountUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccountUsername").build()}).build();
    private static final SdkField<String> USER_BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserBase").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::userBase)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::userBase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBase").build()}).build();
    private static final SdkField<String> USER_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserRoleName").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::userRoleName)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::userRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRoleName").build()}).build();
    private static final SdkField<String> USER_SEARCH_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserSearchMatching").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::userSearchMatching)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::userSearchMatching)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSearchMatching").build()}).build();
    private static final SdkField<Boolean> USER_SEARCH_SUBTREE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserSearchSubtree").getter(AwsAmazonMqBrokerLdapServerMetadataDetails.getter(AwsAmazonMqBrokerLdapServerMetadataDetails::userSearchSubtree)).setter(AwsAmazonMqBrokerLdapServerMetadataDetails.setter(Builder::userSearchSubtree)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSearchSubtree").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTS_FIELD, ROLE_BASE_FIELD, ROLE_NAME_FIELD, ROLE_SEARCH_MATCHING_FIELD, ROLE_SEARCH_SUBTREE_FIELD, SERVICE_ACCOUNT_USERNAME_FIELD, USER_BASE_FIELD, USER_ROLE_NAME_FIELD, USER_SEARCH_MATCHING_FIELD, USER_SEARCH_SUBTREE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsAmazonMqBrokerLdapServerMetadataDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> hosts;
    private final String roleBase;
    private final String roleName;
    private final String roleSearchMatching;
    private final Boolean roleSearchSubtree;
    private final String serviceAccountUsername;
    private final String userBase;
    private final String userRoleName;
    private final String userSearchMatching;
    private final Boolean userSearchSubtree;

    private AwsAmazonMqBrokerLdapServerMetadataDetails(BuilderImpl builder) {
        this.hosts = builder.hosts;
        this.roleBase = builder.roleBase;
        this.roleName = builder.roleName;
        this.roleSearchMatching = builder.roleSearchMatching;
        this.roleSearchSubtree = builder.roleSearchSubtree;
        this.serviceAccountUsername = builder.serviceAccountUsername;
        this.userBase = builder.userBase;
        this.userRoleName = builder.userRoleName;
        this.userSearchMatching = builder.userSearchMatching;
        this.userSearchSubtree = builder.userSearchSubtree;
    }

    public final boolean hasHosts() {
        return this.hosts != null && !(this.hosts instanceof SdkAutoConstructList);
    }

    public final List<String> hosts() {
        return this.hosts;
    }

    public final String roleBase() {
        return this.roleBase;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final String roleSearchMatching() {
        return this.roleSearchMatching;
    }

    public final Boolean roleSearchSubtree() {
        return this.roleSearchSubtree;
    }

    public final String serviceAccountUsername() {
        return this.serviceAccountUsername;
    }

    public final String userBase() {
        return this.userBase;
    }

    public final String userRoleName() {
        return this.userRoleName;
    }

    public final String userSearchMatching() {
        return this.userSearchMatching;
    }

    public final Boolean userSearchSubtree() {
        return this.userSearchSubtree;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHosts() ? this.hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleBase());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleSearchSubtree());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.userBase());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSearchSubtree());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAmazonMqBrokerLdapServerMetadataDetails)) {
            return false;
        }
        AwsAmazonMqBrokerLdapServerMetadataDetails other = (AwsAmazonMqBrokerLdapServerMetadataDetails)obj;
        return this.hasHosts() == other.hasHosts() && Objects.equals(this.hosts(), other.hosts()) && Objects.equals(this.roleBase(), other.roleBase()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.roleSearchMatching(), other.roleSearchMatching()) && Objects.equals(this.roleSearchSubtree(), other.roleSearchSubtree()) && Objects.equals(this.serviceAccountUsername(), other.serviceAccountUsername()) && Objects.equals(this.userBase(), other.userBase()) && Objects.equals(this.userRoleName(), other.userRoleName()) && Objects.equals(this.userSearchMatching(), other.userSearchMatching()) && Objects.equals(this.userSearchSubtree(), other.userSearchSubtree());
    }

    public final String toString() {
        return ToString.builder((String)"AwsAmazonMqBrokerLdapServerMetadataDetails").add("Hosts", this.hasHosts() ? this.hosts() : null).add("RoleBase", (Object)this.roleBase()).add("RoleName", (Object)this.roleName()).add("RoleSearchMatching", (Object)this.roleSearchMatching()).add("RoleSearchSubtree", (Object)this.roleSearchSubtree()).add("ServiceAccountUsername", (Object)this.serviceAccountUsername()).add("UserBase", (Object)this.userBase()).add("UserRoleName", (Object)this.userRoleName()).add("UserSearchMatching", (Object)this.userSearchMatching()).add("UserSearchSubtree", (Object)this.userSearchSubtree()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Hosts": {
                return Optional.ofNullable(clazz.cast(this.hosts()));
            }
            case "RoleBase": {
                return Optional.ofNullable(clazz.cast(this.roleBase()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "RoleSearchMatching": {
                return Optional.ofNullable(clazz.cast(this.roleSearchMatching()));
            }
            case "RoleSearchSubtree": {
                return Optional.ofNullable(clazz.cast(this.roleSearchSubtree()));
            }
            case "ServiceAccountUsername": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountUsername()));
            }
            case "UserBase": {
                return Optional.ofNullable(clazz.cast(this.userBase()));
            }
            case "UserRoleName": {
                return Optional.ofNullable(clazz.cast(this.userRoleName()));
            }
            case "UserSearchMatching": {
                return Optional.ofNullable(clazz.cast(this.userSearchMatching()));
            }
            case "UserSearchSubtree": {
                return Optional.ofNullable(clazz.cast(this.userSearchSubtree()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Hosts", HOSTS_FIELD);
        map.put("RoleBase", ROLE_BASE_FIELD);
        map.put("RoleName", ROLE_NAME_FIELD);
        map.put("RoleSearchMatching", ROLE_SEARCH_MATCHING_FIELD);
        map.put("RoleSearchSubtree", ROLE_SEARCH_SUBTREE_FIELD);
        map.put("ServiceAccountUsername", SERVICE_ACCOUNT_USERNAME_FIELD);
        map.put("UserBase", USER_BASE_FIELD);
        map.put("UserRoleName", USER_ROLE_NAME_FIELD);
        map.put("UserSearchMatching", USER_SEARCH_MATCHING_FIELD);
        map.put("UserSearchSubtree", USER_SEARCH_SUBTREE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAmazonMqBrokerLdapServerMetadataDetails, T> g) {
        return obj -> g.apply((AwsAmazonMqBrokerLdapServerMetadataDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> hosts = DefaultSdkAutoConstructList.getInstance();
        private String roleBase;
        private String roleName;
        private String roleSearchMatching;
        private Boolean roleSearchSubtree;
        private String serviceAccountUsername;
        private String userBase;
        private String userRoleName;
        private String userSearchMatching;
        private Boolean userSearchSubtree;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAmazonMqBrokerLdapServerMetadataDetails model) {
            this.hosts(model.hosts);
            this.roleBase(model.roleBase);
            this.roleName(model.roleName);
            this.roleSearchMatching(model.roleSearchMatching);
            this.roleSearchSubtree(model.roleSearchSubtree);
            this.serviceAccountUsername(model.serviceAccountUsername);
            this.userBase(model.userBase);
            this.userRoleName(model.userRoleName);
            this.userSearchMatching(model.userSearchMatching);
            this.userSearchSubtree(model.userSearchSubtree);
        }

        public final Collection<String> getHosts() {
            if (this.hosts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hosts;
        }

        public final void setHosts(Collection<String> hosts) {
            this.hosts = StringListCopier.copy(hosts);
        }

        @Override
        public final Builder hosts(Collection<String> hosts) {
            this.hosts = StringListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(String ... hosts) {
            this.hosts(Arrays.asList(hosts));
            return this;
        }

        public final String getRoleBase() {
            return this.roleBase;
        }

        public final void setRoleBase(String roleBase) {
            this.roleBase = roleBase;
        }

        @Override
        public final Builder roleBase(String roleBase) {
            this.roleBase = roleBase;
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getRoleSearchMatching() {
            return this.roleSearchMatching;
        }

        public final void setRoleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
        }

        @Override
        public final Builder roleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
            return this;
        }

        public final Boolean getRoleSearchSubtree() {
            return this.roleSearchSubtree;
        }

        public final void setRoleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
        }

        @Override
        public final Builder roleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
            return this;
        }

        public final String getServiceAccountUsername() {
            return this.serviceAccountUsername;
        }

        public final void setServiceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
        }

        @Override
        public final Builder serviceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
            return this;
        }

        public final String getUserBase() {
            return this.userBase;
        }

        public final void setUserBase(String userBase) {
            this.userBase = userBase;
        }

        @Override
        public final Builder userBase(String userBase) {
            this.userBase = userBase;
            return this;
        }

        public final String getUserRoleName() {
            return this.userRoleName;
        }

        public final void setUserRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
        }

        @Override
        public final Builder userRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
            return this;
        }

        public final String getUserSearchMatching() {
            return this.userSearchMatching;
        }

        public final void setUserSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
        }

        @Override
        public final Builder userSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
            return this;
        }

        public final Boolean getUserSearchSubtree() {
            return this.userSearchSubtree;
        }

        public final void setUserSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
        }

        @Override
        public final Builder userSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
            return this;
        }

        public AwsAmazonMqBrokerLdapServerMetadataDetails build() {
            return new AwsAmazonMqBrokerLdapServerMetadataDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsAmazonMqBrokerLdapServerMetadataDetails> {
        public Builder hosts(Collection<String> var1);

        public Builder hosts(String ... var1);

        public Builder roleBase(String var1);

        public Builder roleName(String var1);

        public Builder roleSearchMatching(String var1);

        public Builder roleSearchSubtree(Boolean var1);

        public Builder serviceAccountUsername(String var1);

        public Builder userBase(String var1);

        public Builder userRoleName(String var1);

        public Builder userSearchMatching(String var1);

        public Builder userSearchSubtree(Boolean var1);
    }
}

