/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StandardsControlsUpdatable {
    READY_FOR_UPDATES("READY_FOR_UPDATES"),
    NOT_READY_FOR_UPDATES("NOT_READY_FOR_UPDATES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StandardsControlsUpdatable> VALUE_MAP;
    private final String value;

    private StandardsControlsUpdatable(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StandardsControlsUpdatable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StandardsControlsUpdatable> knownValues() {
        EnumSet<StandardsControlsUpdatable> knownValues = EnumSet.allOf(StandardsControlsUpdatable.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StandardsControlsUpdatable.class, StandardsControlsUpdatable::toString);
    }
}

