/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAttributes;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescriptionsCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstancesCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescriptionsCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElbLoadBalancerDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElbLoadBalancerDetails> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::availabilityZones)).setter(AwsElbLoadBalancerDetails.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsElbLoadBalancerBackendServerDescription>> BACKEND_SERVER_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackendServerDescriptions").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::backendServerDescriptions)).setter(AwsElbLoadBalancerDetails.setter(Builder::backendServerDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackendServerDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElbLoadBalancerBackendServerDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CANONICAL_HOSTED_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CanonicalHostedZoneName").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::canonicalHostedZoneName)).setter(AwsElbLoadBalancerDetails.setter(Builder::canonicalHostedZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneName").build()}).build();
    private static final SdkField<String> CANONICAL_HOSTED_ZONE_NAME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CanonicalHostedZoneNameID").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::canonicalHostedZoneNameID)).setter(AwsElbLoadBalancerDetails.setter(Builder::canonicalHostedZoneNameID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneNameID").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::createdTime)).setter(AwsElbLoadBalancerDetails.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::dnsName)).setter(AwsElbLoadBalancerDetails.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<AwsElbLoadBalancerHealthCheck> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheck").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::healthCheck)).setter(AwsElbLoadBalancerDetails.setter(Builder::healthCheck)).constructor(AwsElbLoadBalancerHealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()}).build();
    private static final SdkField<List<AwsElbLoadBalancerInstance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::instances)).setter(AwsElbLoadBalancerDetails.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElbLoadBalancerInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsElbLoadBalancerListenerDescription>> LISTENER_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ListenerDescriptions").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::listenerDescriptions)).setter(AwsElbLoadBalancerDetails.setter(Builder::listenerDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElbLoadBalancerListenerDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsElbLoadBalancerAttributes> LOAD_BALANCER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadBalancerAttributes").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::loadBalancerAttributes)).setter(AwsElbLoadBalancerDetails.setter(Builder::loadBalancerAttributes)).constructor(AwsElbLoadBalancerAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAttributes").build()}).build();
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::loadBalancerName)).setter(AwsElbLoadBalancerDetails.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<AwsElbLoadBalancerPolicies> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Policies").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::policies)).setter(AwsElbLoadBalancerDetails.setter(Builder::policies)).constructor(AwsElbLoadBalancerPolicies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()}).build();
    private static final SdkField<String> SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scheme").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::scheme)).setter(AwsElbLoadBalancerDetails.setter(Builder::scheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::securityGroups)).setter(AwsElbLoadBalancerDetails.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsElbLoadBalancerSourceSecurityGroup> SOURCE_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceSecurityGroup").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::sourceSecurityGroup)).setter(AwsElbLoadBalancerDetails.setter(Builder::sourceSecurityGroup)).constructor(AwsElbLoadBalancerSourceSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroup").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::subnets)).setter(AwsElbLoadBalancerDetails.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsElbLoadBalancerDetails.getter(AwsElbLoadBalancerDetails::vpcId)).setter(AwsElbLoadBalancerDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, BACKEND_SERVER_DESCRIPTIONS_FIELD, CANONICAL_HOSTED_ZONE_NAME_FIELD, CANONICAL_HOSTED_ZONE_NAME_ID_FIELD, CREATED_TIME_FIELD, DNS_NAME_FIELD, HEALTH_CHECK_FIELD, INSTANCES_FIELD, LISTENER_DESCRIPTIONS_FIELD, LOAD_BALANCER_ATTRIBUTES_FIELD, LOAD_BALANCER_NAME_FIELD, POLICIES_FIELD, SCHEME_FIELD, SECURITY_GROUPS_FIELD, SOURCE_SECURITY_GROUP_FIELD, SUBNETS_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsElbLoadBalancerDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> availabilityZones;
    private final List<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions;
    private final String canonicalHostedZoneName;
    private final String canonicalHostedZoneNameID;
    private final String createdTime;
    private final String dnsName;
    private final AwsElbLoadBalancerHealthCheck healthCheck;
    private final List<AwsElbLoadBalancerInstance> instances;
    private final List<AwsElbLoadBalancerListenerDescription> listenerDescriptions;
    private final AwsElbLoadBalancerAttributes loadBalancerAttributes;
    private final String loadBalancerName;
    private final AwsElbLoadBalancerPolicies policies;
    private final String scheme;
    private final List<String> securityGroups;
    private final AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup;
    private final List<String> subnets;
    private final String vpcId;

    private AwsElbLoadBalancerDetails(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.backendServerDescriptions = builder.backendServerDescriptions;
        this.canonicalHostedZoneName = builder.canonicalHostedZoneName;
        this.canonicalHostedZoneNameID = builder.canonicalHostedZoneNameID;
        this.createdTime = builder.createdTime;
        this.dnsName = builder.dnsName;
        this.healthCheck = builder.healthCheck;
        this.instances = builder.instances;
        this.listenerDescriptions = builder.listenerDescriptions;
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
        this.loadBalancerName = builder.loadBalancerName;
        this.policies = builder.policies;
        this.scheme = builder.scheme;
        this.securityGroups = builder.securityGroups;
        this.sourceSecurityGroup = builder.sourceSecurityGroup;
        this.subnets = builder.subnets;
        this.vpcId = builder.vpcId;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasBackendServerDescriptions() {
        return this.backendServerDescriptions != null && !(this.backendServerDescriptions instanceof SdkAutoConstructList);
    }

    public final List<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions() {
        return this.backendServerDescriptions;
    }

    public final String canonicalHostedZoneName() {
        return this.canonicalHostedZoneName;
    }

    public final String canonicalHostedZoneNameID() {
        return this.canonicalHostedZoneNameID;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final AwsElbLoadBalancerHealthCheck healthCheck() {
        return this.healthCheck;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<AwsElbLoadBalancerInstance> instances() {
        return this.instances;
    }

    public final boolean hasListenerDescriptions() {
        return this.listenerDescriptions != null && !(this.listenerDescriptions instanceof SdkAutoConstructList);
    }

    public final List<AwsElbLoadBalancerListenerDescription> listenerDescriptions() {
        return this.listenerDescriptions;
    }

    public final AwsElbLoadBalancerAttributes loadBalancerAttributes() {
        return this.loadBalancerAttributes;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final AwsElbLoadBalancerPolicies policies() {
        return this.policies;
    }

    public final String scheme() {
        return this.scheme;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup() {
        return this.sourceSecurityGroup;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackendServerDescriptions() ? this.backendServerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.canonicalHostedZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.canonicalHostedZoneNameID());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListenerDescriptions() ? this.listenerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheme());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerDetails)) {
            return false;
        }
        AwsElbLoadBalancerDetails other = (AwsElbLoadBalancerDetails)obj;
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasBackendServerDescriptions() == other.hasBackendServerDescriptions() && Objects.equals(this.backendServerDescriptions(), other.backendServerDescriptions()) && Objects.equals(this.canonicalHostedZoneName(), other.canonicalHostedZoneName()) && Objects.equals(this.canonicalHostedZoneNameID(), other.canonicalHostedZoneNameID()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.healthCheck(), other.healthCheck()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && this.hasListenerDescriptions() == other.hasListenerDescriptions() && Objects.equals(this.listenerDescriptions(), other.listenerDescriptions()) && Objects.equals(this.loadBalancerAttributes(), other.loadBalancerAttributes()) && Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.scheme(), other.scheme()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sourceSecurityGroup(), other.sourceSecurityGroup()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElbLoadBalancerDetails").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("BackendServerDescriptions", this.hasBackendServerDescriptions() ? this.backendServerDescriptions() : null).add("CanonicalHostedZoneName", (Object)this.canonicalHostedZoneName()).add("CanonicalHostedZoneNameID", (Object)this.canonicalHostedZoneNameID()).add("CreatedTime", (Object)this.createdTime()).add("DnsName", (Object)this.dnsName()).add("HealthCheck", (Object)this.healthCheck()).add("Instances", this.hasInstances() ? this.instances() : null).add("ListenerDescriptions", this.hasListenerDescriptions() ? this.listenerDescriptions() : null).add("LoadBalancerAttributes", (Object)this.loadBalancerAttributes()).add("LoadBalancerName", (Object)this.loadBalancerName()).add("Policies", (Object)this.policies()).add("Scheme", (Object)this.scheme()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SourceSecurityGroup", (Object)this.sourceSecurityGroup()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "BackendServerDescriptions": {
                return Optional.ofNullable(clazz.cast(this.backendServerDescriptions()));
            }
            case "CanonicalHostedZoneName": {
                return Optional.ofNullable(clazz.cast(this.canonicalHostedZoneName()));
            }
            case "CanonicalHostedZoneNameID": {
                return Optional.ofNullable(clazz.cast(this.canonicalHostedZoneNameID()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "HealthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "ListenerDescriptions": {
                return Optional.ofNullable(clazz.cast(this.listenerDescriptions()));
            }
            case "LoadBalancerAttributes": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerAttributes()));
            }
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "Scheme": {
                return Optional.ofNullable(clazz.cast(this.scheme()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SourceSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.sourceSecurityGroup()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("BackendServerDescriptions", BACKEND_SERVER_DESCRIPTIONS_FIELD);
        map.put("CanonicalHostedZoneName", CANONICAL_HOSTED_ZONE_NAME_FIELD);
        map.put("CanonicalHostedZoneNameID", CANONICAL_HOSTED_ZONE_NAME_ID_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("HealthCheck", HEALTH_CHECK_FIELD);
        map.put("Instances", INSTANCES_FIELD);
        map.put("ListenerDescriptions", LISTENER_DESCRIPTIONS_FIELD);
        map.put("LoadBalancerAttributes", LOAD_BALANCER_ATTRIBUTES_FIELD);
        map.put("LoadBalancerName", LOAD_BALANCER_NAME_FIELD);
        map.put("Policies", POLICIES_FIELD);
        map.put("Scheme", SCHEME_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("SourceSecurityGroup", SOURCE_SECURITY_GROUP_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerDetails, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String canonicalHostedZoneName;
        private String canonicalHostedZoneNameID;
        private String createdTime;
        private String dnsName;
        private AwsElbLoadBalancerHealthCheck healthCheck;
        private List<AwsElbLoadBalancerInstance> instances = DefaultSdkAutoConstructList.getInstance();
        private List<AwsElbLoadBalancerListenerDescription> listenerDescriptions = DefaultSdkAutoConstructList.getInstance();
        private AwsElbLoadBalancerAttributes loadBalancerAttributes;
        private String loadBalancerName;
        private AwsElbLoadBalancerPolicies policies;
        private String scheme;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerDetails model) {
            this.availabilityZones(model.availabilityZones);
            this.backendServerDescriptions(model.backendServerDescriptions);
            this.canonicalHostedZoneName(model.canonicalHostedZoneName);
            this.canonicalHostedZoneNameID(model.canonicalHostedZoneNameID);
            this.createdTime(model.createdTime);
            this.dnsName(model.dnsName);
            this.healthCheck(model.healthCheck);
            this.instances(model.instances);
            this.listenerDescriptions(model.listenerDescriptions);
            this.loadBalancerAttributes(model.loadBalancerAttributes);
            this.loadBalancerName(model.loadBalancerName);
            this.policies(model.policies);
            this.scheme(model.scheme);
            this.securityGroups(model.securityGroups);
            this.sourceSecurityGroup(model.sourceSecurityGroup);
            this.subnets(model.subnets);
            this.vpcId(model.vpcId);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final List<AwsElbLoadBalancerBackendServerDescription.Builder> getBackendServerDescriptions() {
            List<AwsElbLoadBalancerBackendServerDescription.Builder> result = AwsElbLoadBalancerBackendServerDescriptionsCopier.copyToBuilder(this.backendServerDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackendServerDescriptions(Collection<AwsElbLoadBalancerBackendServerDescription.BuilderImpl> backendServerDescriptions) {
            this.backendServerDescriptions = AwsElbLoadBalancerBackendServerDescriptionsCopier.copyFromBuilder(backendServerDescriptions);
        }

        @Override
        public final Builder backendServerDescriptions(Collection<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions) {
            this.backendServerDescriptions = AwsElbLoadBalancerBackendServerDescriptionsCopier.copy(backendServerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(AwsElbLoadBalancerBackendServerDescription ... backendServerDescriptions) {
            this.backendServerDescriptions(Arrays.asList(backendServerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(Consumer<AwsElbLoadBalancerBackendServerDescription.Builder> ... backendServerDescriptions) {
            this.backendServerDescriptions(Stream.of(backendServerDescriptions).map(c -> (AwsElbLoadBalancerBackendServerDescription)((AwsElbLoadBalancerBackendServerDescription.Builder)AwsElbLoadBalancerBackendServerDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCanonicalHostedZoneName() {
            return this.canonicalHostedZoneName;
        }

        public final void setCanonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
        }

        @Override
        public final Builder canonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
            return this;
        }

        public final String getCanonicalHostedZoneNameID() {
            return this.canonicalHostedZoneNameID;
        }

        public final void setCanonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
        }

        @Override
        public final Builder canonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final AwsElbLoadBalancerHealthCheck.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(AwsElbLoadBalancerHealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(AwsElbLoadBalancerHealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final List<AwsElbLoadBalancerInstance.Builder> getInstances() {
            List<AwsElbLoadBalancerInstance.Builder> result = AwsElbLoadBalancerInstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<AwsElbLoadBalancerInstance.BuilderImpl> instances) {
            this.instances = AwsElbLoadBalancerInstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<AwsElbLoadBalancerInstance> instances) {
            this.instances = AwsElbLoadBalancerInstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(AwsElbLoadBalancerInstance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<AwsElbLoadBalancerInstance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (AwsElbLoadBalancerInstance)((AwsElbLoadBalancerInstance.Builder)AwsElbLoadBalancerInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsElbLoadBalancerListenerDescription.Builder> getListenerDescriptions() {
            List<AwsElbLoadBalancerListenerDescription.Builder> result = AwsElbLoadBalancerListenerDescriptionsCopier.copyToBuilder(this.listenerDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerDescriptions(Collection<AwsElbLoadBalancerListenerDescription.BuilderImpl> listenerDescriptions) {
            this.listenerDescriptions = AwsElbLoadBalancerListenerDescriptionsCopier.copyFromBuilder(listenerDescriptions);
        }

        @Override
        public final Builder listenerDescriptions(Collection<AwsElbLoadBalancerListenerDescription> listenerDescriptions) {
            this.listenerDescriptions = AwsElbLoadBalancerListenerDescriptionsCopier.copy(listenerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(AwsElbLoadBalancerListenerDescription ... listenerDescriptions) {
            this.listenerDescriptions(Arrays.asList(listenerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(Consumer<AwsElbLoadBalancerListenerDescription.Builder> ... listenerDescriptions) {
            this.listenerDescriptions(Stream.of(listenerDescriptions).map(c -> (AwsElbLoadBalancerListenerDescription)((AwsElbLoadBalancerListenerDescription.Builder)AwsElbLoadBalancerListenerDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsElbLoadBalancerAttributes.Builder getLoadBalancerAttributes() {
            return this.loadBalancerAttributes != null ? this.loadBalancerAttributes.toBuilder() : null;
        }

        public final void setLoadBalancerAttributes(AwsElbLoadBalancerAttributes.BuilderImpl loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes != null ? loadBalancerAttributes.build() : null;
        }

        @Override
        public final Builder loadBalancerAttributes(AwsElbLoadBalancerAttributes loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final AwsElbLoadBalancerPolicies.Builder getPolicies() {
            return this.policies != null ? this.policies.toBuilder() : null;
        }

        public final void setPolicies(AwsElbLoadBalancerPolicies.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        @Override
        public final Builder policies(AwsElbLoadBalancerPolicies policies) {
            this.policies = policies;
            return this;
        }

        public final String getScheme() {
            return this.scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final AwsElbLoadBalancerSourceSecurityGroup.Builder getSourceSecurityGroup() {
            return this.sourceSecurityGroup != null ? this.sourceSecurityGroup.toBuilder() : null;
        }

        public final void setSourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup.BuilderImpl sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup != null ? sourceSecurityGroup.build() : null;
        }

        @Override
        public final Builder sourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public AwsElbLoadBalancerDetails build() {
            return new AwsElbLoadBalancerDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElbLoadBalancerDetails> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backendServerDescriptions(Collection<AwsElbLoadBalancerBackendServerDescription> var1);

        public Builder backendServerDescriptions(AwsElbLoadBalancerBackendServerDescription ... var1);

        public Builder backendServerDescriptions(Consumer<AwsElbLoadBalancerBackendServerDescription.Builder> ... var1);

        public Builder canonicalHostedZoneName(String var1);

        public Builder canonicalHostedZoneNameID(String var1);

        public Builder createdTime(String var1);

        public Builder dnsName(String var1);

        public Builder healthCheck(AwsElbLoadBalancerHealthCheck var1);

        default public Builder healthCheck(Consumer<AwsElbLoadBalancerHealthCheck.Builder> healthCheck) {
            return this.healthCheck((AwsElbLoadBalancerHealthCheck)((AwsElbLoadBalancerHealthCheck.Builder)AwsElbLoadBalancerHealthCheck.builder().applyMutation(healthCheck)).build());
        }

        public Builder instances(Collection<AwsElbLoadBalancerInstance> var1);

        public Builder instances(AwsElbLoadBalancerInstance ... var1);

        public Builder instances(Consumer<AwsElbLoadBalancerInstance.Builder> ... var1);

        public Builder listenerDescriptions(Collection<AwsElbLoadBalancerListenerDescription> var1);

        public Builder listenerDescriptions(AwsElbLoadBalancerListenerDescription ... var1);

        public Builder listenerDescriptions(Consumer<AwsElbLoadBalancerListenerDescription.Builder> ... var1);

        public Builder loadBalancerAttributes(AwsElbLoadBalancerAttributes var1);

        default public Builder loadBalancerAttributes(Consumer<AwsElbLoadBalancerAttributes.Builder> loadBalancerAttributes) {
            return this.loadBalancerAttributes((AwsElbLoadBalancerAttributes)((AwsElbLoadBalancerAttributes.Builder)AwsElbLoadBalancerAttributes.builder().applyMutation(loadBalancerAttributes)).build());
        }

        public Builder loadBalancerName(String var1);

        public Builder policies(AwsElbLoadBalancerPolicies var1);

        default public Builder policies(Consumer<AwsElbLoadBalancerPolicies.Builder> policies) {
            return this.policies((AwsElbLoadBalancerPolicies)((AwsElbLoadBalancerPolicies.Builder)AwsElbLoadBalancerPolicies.builder().applyMutation(policies)).build());
        }

        public Builder scheme(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder sourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup var1);

        default public Builder sourceSecurityGroup(Consumer<AwsElbLoadBalancerSourceSecurityGroup.Builder> sourceSecurityGroup) {
            return this.sourceSecurityGroup((AwsElbLoadBalancerSourceSecurityGroup)((AwsElbLoadBalancerSourceSecurityGroup.Builder)AwsElbLoadBalancerSourceSecurityGroup.builder().applyMutation(sourceSecurityGroup)).build());
        }

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder vpcId(String var1);
    }
}

