/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesArnsListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAutomationRulesRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, BatchGetAutomationRulesRequest> {
    private static final SdkField<List<String>> AUTOMATION_RULES_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutomationRulesArns").getter(BatchGetAutomationRulesRequest.getter(BatchGetAutomationRulesRequest::automationRulesArns)).setter(BatchGetAutomationRulesRequest.setter(Builder::automationRulesArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationRulesArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_RULES_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AutomationRulesArns", AUTOMATION_RULES_ARNS_FIELD);
        }
    });
    private final List<String> automationRulesArns;

    private BatchGetAutomationRulesRequest(BuilderImpl builder) {
        super(builder);
        this.automationRulesArns = builder.automationRulesArns;
    }

    public final boolean hasAutomationRulesArns() {
        return this.automationRulesArns != null && !(this.automationRulesArns instanceof SdkAutoConstructList);
    }

    public final List<String> automationRulesArns() {
        return this.automationRulesArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomationRulesArns() ? this.automationRulesArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAutomationRulesRequest)) {
            return false;
        }
        BatchGetAutomationRulesRequest other = (BatchGetAutomationRulesRequest)((Object)obj);
        return this.hasAutomationRulesArns() == other.hasAutomationRulesArns() && Objects.equals(this.automationRulesArns(), other.automationRulesArns());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAutomationRulesRequest").add("AutomationRulesArns", this.hasAutomationRulesArns() ? this.automationRulesArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationRulesArns": {
                return Optional.ofNullable(clazz.cast(this.automationRulesArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAutomationRulesRequest, T> g) {
        return obj -> g.apply((BatchGetAutomationRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<String> automationRulesArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAutomationRulesRequest model) {
            super(model);
            this.automationRulesArns(model.automationRulesArns);
        }

        public final Collection<String> getAutomationRulesArns() {
            if (this.automationRulesArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.automationRulesArns;
        }

        public final void setAutomationRulesArns(Collection<String> automationRulesArns) {
            this.automationRulesArns = AutomationRulesArnsListCopier.copy(automationRulesArns);
        }

        @Override
        public final Builder automationRulesArns(Collection<String> automationRulesArns) {
            this.automationRulesArns = AutomationRulesArnsListCopier.copy(automationRulesArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationRulesArns(String ... automationRulesArns) {
            this.automationRulesArns(Arrays.asList(automationRulesArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAutomationRulesRequest build() {
            return new BatchGetAutomationRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAutomationRulesRequest> {
        public Builder automationRulesArns(Collection<String> var1);

        public Builder automationRulesArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

