/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.FilePathListCopier;
import software.amazon.awssdk.services.securityhub.model.FilePaths;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Threat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Threat> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Threat.getter(Threat::name)).setter(Threat.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(Threat.getter(Threat::severity)).setter(Threat.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ItemCount").getter(Threat.getter(Threat::itemCount)).setter(Threat.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<List<FilePaths>> FILE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilePaths").getter(Threat.getter(Threat::filePaths)).setter(Threat.setter(Builder::filePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilePaths::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SEVERITY_FIELD, ITEM_COUNT_FIELD, FILE_PATHS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Severity", SEVERITY_FIELD);
            this.put("ItemCount", ITEM_COUNT_FIELD);
            this.put("FilePaths", FILE_PATHS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String severity;
    private final Integer itemCount;
    private final List<FilePaths> filePaths;

    private Threat(BuilderImpl builder) {
        this.name = builder.name;
        this.severity = builder.severity;
        this.itemCount = builder.itemCount;
        this.filePaths = builder.filePaths;
    }

    public final String name() {
        return this.name;
    }

    public final String severity() {
        return this.severity;
    }

    public final Integer itemCount() {
        return this.itemCount;
    }

    public final boolean hasFilePaths() {
        return this.filePaths != null && !(this.filePaths instanceof SdkAutoConstructList);
    }

    public final List<FilePaths> filePaths() {
        return this.filePaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilePaths() ? this.filePaths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Threat)) {
            return false;
        }
        Threat other = (Threat)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.itemCount(), other.itemCount()) && this.hasFilePaths() == other.hasFilePaths() && Objects.equals(this.filePaths(), other.filePaths());
    }

    public final String toString() {
        return ToString.builder((String)"Threat").add("Name", (Object)this.name()).add("Severity", (Object)this.severity()).add("ItemCount", (Object)this.itemCount()).add("FilePaths", this.hasFilePaths() ? this.filePaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "FilePaths": {
                return Optional.ofNullable(clazz.cast(this.filePaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Threat, T> g) {
        return obj -> g.apply((Threat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String severity;
        private Integer itemCount;
        private List<FilePaths> filePaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Threat model) {
            this.name(model.name);
            this.severity(model.severity);
            this.itemCount(model.itemCount);
            this.filePaths(model.filePaths);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final List<FilePaths.Builder> getFilePaths() {
            List<FilePaths.Builder> result = FilePathListCopier.copyToBuilder(this.filePaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilePaths(Collection<FilePaths.BuilderImpl> filePaths) {
            this.filePaths = FilePathListCopier.copyFromBuilder(filePaths);
        }

        @Override
        public final Builder filePaths(Collection<FilePaths> filePaths) {
            this.filePaths = FilePathListCopier.copy(filePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filePaths(FilePaths ... filePaths) {
            this.filePaths(Arrays.asList(filePaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filePaths(Consumer<FilePaths.Builder> ... filePaths) {
            this.filePaths(Stream.of(filePaths).map(c -> (FilePaths)((FilePaths.Builder)FilePaths.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Threat build() {
            return new Threat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Threat> {
        public Builder name(String var1);

        public Builder severity(String var1);

        public Builder itemCount(Integer var1);

        public Builder filePaths(Collection<FilePaths> var1);

        public Builder filePaths(FilePaths ... var1);

        public Builder filePaths(Consumer<FilePaths.Builder> ... var1);
    }
}

