/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Indicator;
import software.amazon.awssdk.services.securityhub.model.IndicatorsListCopier;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Signal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Signal> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Signal.getter(Signal::type)).setter(Signal.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Signal.getter(Signal::id)).setter(Signal.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Signal.getter(Signal::title)).setter(Signal.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductArn").getter(Signal.getter(Signal::productArn)).setter(Signal.setter(Builder::productArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIds").getter(Signal.getter(Signal::resourceIds)).setter(Signal.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Indicator>> SIGNAL_INDICATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SignalIndicators").getter(Signal.getter(Signal::signalIndicators)).setter(Signal.setter(Builder::signalIndicators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalIndicators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Indicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Signal.getter(Signal::name)).setter(Signal.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreatedAt").getter(Signal.getter(Signal::createdAt)).setter(Signal.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Long> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("UpdatedAt").getter(Signal.getter(Signal::updatedAt)).setter(Signal.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<Long> FIRST_SEEN_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FirstSeenAt").getter(Signal.getter(Signal::firstSeenAt)).setter(Signal.setter(Builder::firstSeenAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSeenAt").build()}).build();
    private static final SdkField<Long> LAST_SEEN_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastSeenAt").getter(Signal.getter(Signal::lastSeenAt)).setter(Signal.setter(Builder::lastSeenAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSeenAt").build()}).build();
    private static final SdkField<Double> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Severity").getter(Signal.getter(Signal::severity)).setter(Signal.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(Signal.getter(Signal::count)).setter(Signal.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<List<String>> ACTOR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActorIds").getter(Signal.getter(Signal::actorIds)).setter(Signal.setter(Builder::actorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENDPOINT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointIds").getter(Signal.getter(Signal::endpointIds)).setter(Signal.setter(Builder::endpointIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD, TITLE_FIELD, PRODUCT_ARN_FIELD, RESOURCE_IDS_FIELD, SIGNAL_INDICATORS_FIELD, NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, FIRST_SEEN_AT_FIELD, LAST_SEEN_AT_FIELD, SEVERITY_FIELD, COUNT_FIELD, ACTOR_IDS_FIELD, ENDPOINT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("ProductArn", PRODUCT_ARN_FIELD);
            this.put("ResourceIds", RESOURCE_IDS_FIELD);
            this.put("SignalIndicators", SIGNAL_INDICATORS_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("UpdatedAt", UPDATED_AT_FIELD);
            this.put("FirstSeenAt", FIRST_SEEN_AT_FIELD);
            this.put("LastSeenAt", LAST_SEEN_AT_FIELD);
            this.put("Severity", SEVERITY_FIELD);
            this.put("Count", COUNT_FIELD);
            this.put("ActorIds", ACTOR_IDS_FIELD);
            this.put("EndpointIds", ENDPOINT_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String id;
    private final String title;
    private final String productArn;
    private final List<String> resourceIds;
    private final List<Indicator> signalIndicators;
    private final String name;
    private final Long createdAt;
    private final Long updatedAt;
    private final Long firstSeenAt;
    private final Long lastSeenAt;
    private final Double severity;
    private final Integer count;
    private final List<String> actorIds;
    private final List<String> endpointIds;

    private Signal(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.title = builder.title;
        this.productArn = builder.productArn;
        this.resourceIds = builder.resourceIds;
        this.signalIndicators = builder.signalIndicators;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.firstSeenAt = builder.firstSeenAt;
        this.lastSeenAt = builder.lastSeenAt;
        this.severity = builder.severity;
        this.count = builder.count;
        this.actorIds = builder.actorIds;
        this.endpointIds = builder.endpointIds;
    }

    public final String type() {
        return this.type;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final String productArn() {
        return this.productArn;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> resourceIds() {
        return this.resourceIds;
    }

    public final boolean hasSignalIndicators() {
        return this.signalIndicators != null && !(this.signalIndicators instanceof SdkAutoConstructList);
    }

    public final List<Indicator> signalIndicators() {
        return this.signalIndicators;
    }

    public final String name() {
        return this.name;
    }

    public final Long createdAt() {
        return this.createdAt;
    }

    public final Long updatedAt() {
        return this.updatedAt;
    }

    public final Long firstSeenAt() {
        return this.firstSeenAt;
    }

    public final Long lastSeenAt() {
        return this.lastSeenAt;
    }

    public final Double severity() {
        return this.severity;
    }

    public final Integer count() {
        return this.count;
    }

    public final boolean hasActorIds() {
        return this.actorIds != null && !(this.actorIds instanceof SdkAutoConstructList);
    }

    public final List<String> actorIds() {
        return this.actorIds;
    }

    public final boolean hasEndpointIds() {
        return this.endpointIds != null && !(this.endpointIds instanceof SdkAutoConstructList);
    }

    public final List<String> endpointIds() {
        return this.endpointIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.productArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalIndicators() ? this.signalIndicators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSeenAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeenAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActorIds() ? this.actorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointIds() ? this.endpointIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signal)) {
            return false;
        }
        Signal other = (Signal)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.productArn(), other.productArn()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && this.hasSignalIndicators() == other.hasSignalIndicators() && Objects.equals(this.signalIndicators(), other.signalIndicators()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.firstSeenAt(), other.firstSeenAt()) && Objects.equals(this.lastSeenAt(), other.lastSeenAt()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.count(), other.count()) && this.hasActorIds() == other.hasActorIds() && Objects.equals(this.actorIds(), other.actorIds()) && this.hasEndpointIds() == other.hasEndpointIds() && Objects.equals(this.endpointIds(), other.endpointIds());
    }

    public final String toString() {
        return ToString.builder((String)"Signal").add("Type", (Object)this.type()).add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("ProductArn", (Object)this.productArn()).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("SignalIndicators", this.hasSignalIndicators() ? this.signalIndicators() : null).add("Name", (Object)this.name()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("FirstSeenAt", (Object)this.firstSeenAt()).add("LastSeenAt", (Object)this.lastSeenAt()).add("Severity", (Object)this.severity()).add("Count", (Object)this.count()).add("ActorIds", this.hasActorIds() ? this.actorIds() : null).add("EndpointIds", this.hasEndpointIds() ? this.endpointIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "ProductArn": {
                return Optional.ofNullable(clazz.cast(this.productArn()));
            }
            case "ResourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "SignalIndicators": {
                return Optional.ofNullable(clazz.cast(this.signalIndicators()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "FirstSeenAt": {
                return Optional.ofNullable(clazz.cast(this.firstSeenAt()));
            }
            case "LastSeenAt": {
                return Optional.ofNullable(clazz.cast(this.lastSeenAt()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "ActorIds": {
                return Optional.ofNullable(clazz.cast(this.actorIds()));
            }
            case "EndpointIds": {
                return Optional.ofNullable(clazz.cast(this.endpointIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Signal, T> g) {
        return obj -> g.apply((Signal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String id;
        private String title;
        private String productArn;
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private List<Indicator> signalIndicators = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Long createdAt;
        private Long updatedAt;
        private Long firstSeenAt;
        private Long lastSeenAt;
        private Double severity;
        private Integer count;
        private List<String> actorIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> endpointIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Signal model) {
            this.type(model.type);
            this.id(model.id);
            this.title(model.title);
            this.productArn(model.productArn);
            this.resourceIds(model.resourceIds);
            this.signalIndicators(model.signalIndicators);
            this.name(model.name);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.firstSeenAt(model.firstSeenAt);
            this.lastSeenAt(model.lastSeenAt);
            this.severity(model.severity);
            this.count(model.count);
            this.actorIds(model.actorIds);
            this.endpointIds(model.endpointIds);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getProductArn() {
            return this.productArn;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (this.resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = NonEmptyStringListCopier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = NonEmptyStringListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final List<Indicator.Builder> getSignalIndicators() {
            List<Indicator.Builder> result = IndicatorsListCopier.copyToBuilder(this.signalIndicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalIndicators(Collection<Indicator.BuilderImpl> signalIndicators) {
            this.signalIndicators = IndicatorsListCopier.copyFromBuilder(signalIndicators);
        }

        @Override
        public final Builder signalIndicators(Collection<Indicator> signalIndicators) {
            this.signalIndicators = IndicatorsListCopier.copy(signalIndicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalIndicators(Indicator ... signalIndicators) {
            this.signalIndicators(Arrays.asList(signalIndicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalIndicators(Consumer<Indicator.Builder> ... signalIndicators) {
            this.signalIndicators(Stream.of(signalIndicators).map(c -> (Indicator)((Indicator.Builder)Indicator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Long getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Long updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Long getFirstSeenAt() {
            return this.firstSeenAt;
        }

        public final void setFirstSeenAt(Long firstSeenAt) {
            this.firstSeenAt = firstSeenAt;
        }

        @Override
        public final Builder firstSeenAt(Long firstSeenAt) {
            this.firstSeenAt = firstSeenAt;
            return this;
        }

        public final Long getLastSeenAt() {
            return this.lastSeenAt;
        }

        public final void setLastSeenAt(Long lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
        }

        @Override
        public final Builder lastSeenAt(Long lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        public final Double getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Double severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Double severity) {
            this.severity = severity;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getActorIds() {
            if (this.actorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actorIds;
        }

        public final void setActorIds(Collection<String> actorIds) {
            this.actorIds = NonEmptyStringListCopier.copy(actorIds);
        }

        @Override
        public final Builder actorIds(Collection<String> actorIds) {
            this.actorIds = NonEmptyStringListCopier.copy(actorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actorIds(String ... actorIds) {
            this.actorIds(Arrays.asList(actorIds));
            return this;
        }

        public final Collection<String> getEndpointIds() {
            if (this.endpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointIds;
        }

        public final void setEndpointIds(Collection<String> endpointIds) {
            this.endpointIds = NonEmptyStringListCopier.copy(endpointIds);
        }

        @Override
        public final Builder endpointIds(Collection<String> endpointIds) {
            this.endpointIds = NonEmptyStringListCopier.copy(endpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointIds(String ... endpointIds) {
            this.endpointIds(Arrays.asList(endpointIds));
            return this;
        }

        public Signal build() {
            return new Signal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Signal> {
        public Builder type(String var1);

        public Builder id(String var1);

        public Builder title(String var1);

        public Builder productArn(String var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder signalIndicators(Collection<Indicator> var1);

        public Builder signalIndicators(Indicator ... var1);

        public Builder signalIndicators(Consumer<Indicator.Builder> ... var1);

        public Builder name(String var1);

        public Builder createdAt(Long var1);

        public Builder updatedAt(Long var1);

        public Builder firstSeenAt(Long var1);

        public Builder lastSeenAt(Long var1);

        public Builder severity(Double var1);

        public Builder count(Integer var1);

        public Builder actorIds(Collection<String> var1);

        public Builder actorIds(String ... var1);

        public Builder endpointIds(Collection<String> var1);

        public Builder endpointIds(String ... var1);
    }
}

