/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityControl;
import software.amazon.awssdk.services.securityhub.model.SecurityControlsCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl;
import software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetSecurityControlsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchGetSecurityControlsResponse> {
    private static final SdkField<List<SecurityControl>> SECURITY_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityControls").getter(BatchGetSecurityControlsResponse.getter(BatchGetSecurityControlsResponse::securityControls)).setter(BatchGetSecurityControlsResponse.setter(Builder::securityControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedSecurityControl>> UNPROCESSED_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedIds").getter(BatchGetSecurityControlsResponse.getter(BatchGetSecurityControlsResponse::unprocessedIds)).setter(BatchGetSecurityControlsResponse.setter(Builder::unprocessedIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedSecurityControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROLS_FIELD, UNPROCESSED_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SecurityControls", SECURITY_CONTROLS_FIELD);
            this.put("UnprocessedIds", UNPROCESSED_IDS_FIELD);
        }
    });
    private final List<SecurityControl> securityControls;
    private final List<UnprocessedSecurityControl> unprocessedIds;

    private BatchGetSecurityControlsResponse(BuilderImpl builder) {
        super(builder);
        this.securityControls = builder.securityControls;
        this.unprocessedIds = builder.unprocessedIds;
    }

    public final boolean hasSecurityControls() {
        return this.securityControls != null && !(this.securityControls instanceof SdkAutoConstructList);
    }

    public final List<SecurityControl> securityControls() {
        return this.securityControls;
    }

    public final boolean hasUnprocessedIds() {
        return this.unprocessedIds != null && !(this.unprocessedIds instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedSecurityControl> unprocessedIds() {
        return this.unprocessedIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityControls() ? this.securityControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedIds() ? this.unprocessedIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSecurityControlsResponse)) {
            return false;
        }
        BatchGetSecurityControlsResponse other = (BatchGetSecurityControlsResponse)((Object)obj);
        return this.hasSecurityControls() == other.hasSecurityControls() && Objects.equals(this.securityControls(), other.securityControls()) && this.hasUnprocessedIds() == other.hasUnprocessedIds() && Objects.equals(this.unprocessedIds(), other.unprocessedIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetSecurityControlsResponse").add("SecurityControls", this.hasSecurityControls() ? this.securityControls() : null).add("UnprocessedIds", this.hasUnprocessedIds() ? this.unprocessedIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityControls": {
                return Optional.ofNullable(clazz.cast(this.securityControls()));
            }
            case "UnprocessedIds": {
                return Optional.ofNullable(clazz.cast(this.unprocessedIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSecurityControlsResponse, T> g) {
        return obj -> g.apply((BatchGetSecurityControlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<SecurityControl> securityControls = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedSecurityControl> unprocessedIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSecurityControlsResponse model) {
            super(model);
            this.securityControls(model.securityControls);
            this.unprocessedIds(model.unprocessedIds);
        }

        public final List<SecurityControl.Builder> getSecurityControls() {
            List<SecurityControl.Builder> result = SecurityControlsCopier.copyToBuilder(this.securityControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityControls(Collection<SecurityControl.BuilderImpl> securityControls) {
            this.securityControls = SecurityControlsCopier.copyFromBuilder(securityControls);
        }

        @Override
        public final Builder securityControls(Collection<SecurityControl> securityControls) {
            this.securityControls = SecurityControlsCopier.copy(securityControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControls(SecurityControl ... securityControls) {
            this.securityControls(Arrays.asList(securityControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControls(Consumer<SecurityControl.Builder> ... securityControls) {
            this.securityControls(Stream.of(securityControls).map(c -> (SecurityControl)((SecurityControl.Builder)SecurityControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedSecurityControl.Builder> getUnprocessedIds() {
            List<UnprocessedSecurityControl.Builder> result = UnprocessedSecurityControlsCopier.copyToBuilder(this.unprocessedIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedIds(Collection<UnprocessedSecurityControl.BuilderImpl> unprocessedIds) {
            this.unprocessedIds = UnprocessedSecurityControlsCopier.copyFromBuilder(unprocessedIds);
        }

        @Override
        public final Builder unprocessedIds(Collection<UnprocessedSecurityControl> unprocessedIds) {
            this.unprocessedIds = UnprocessedSecurityControlsCopier.copy(unprocessedIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIds(UnprocessedSecurityControl ... unprocessedIds) {
            this.unprocessedIds(Arrays.asList(unprocessedIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIds(Consumer<UnprocessedSecurityControl.Builder> ... unprocessedIds) {
            this.unprocessedIds(Stream.of(unprocessedIds).map(c -> (UnprocessedSecurityControl)((UnprocessedSecurityControl.Builder)UnprocessedSecurityControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetSecurityControlsResponse build() {
            return new BatchGetSecurityControlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetSecurityControlsResponse> {
        public Builder securityControls(Collection<SecurityControl> var1);

        public Builder securityControls(SecurityControl ... var1);

        public Builder securityControls(Consumer<SecurityControl.Builder> ... var1);

        public Builder unprocessedIds(Collection<UnprocessedSecurityControl> var1);

        public Builder unprocessedIds(UnprocessedSecurityControl ... var1);

        public Builder unprocessedIds(Consumer<UnprocessedSecurityControl.Builder> ... var1);
    }
}

