/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.TypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneratorDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeneratorDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GeneratorDetails.getter(GeneratorDetails::name)).setter(GeneratorDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GeneratorDetails.getter(GeneratorDetails::description)).setter(GeneratorDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(GeneratorDetails.getter(GeneratorDetails::labels)).setter(GeneratorDetails.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, LABELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Labels", LABELS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<String> labels;

    private GeneratorDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.labels = builder.labels;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratorDetails)) {
            return false;
        }
        GeneratorDetails other = (GeneratorDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels());
    }

    public final String toString() {
        return ToString.builder((String)"GeneratorDetails").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Labels", this.hasLabels() ? this.labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GeneratorDetails, T> g) {
        return obj -> g.apply((GeneratorDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratorDetails model) {
            this.name(model.name);
            this.description(model.description);
            this.labels(model.labels);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = TypeListCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = TypeListCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public GeneratorDetails build() {
            return new GeneratorDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeneratorDetails> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);
    }
}

