/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceAttachment;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2NetworkInterfaceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2NetworkInterfaceDetails> {
    private static final SdkField<AwsEc2NetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::attachment)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::attachment)).constructor(AwsEc2NetworkInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::networkInterfaceId)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<List<AwsEc2NetworkInterfaceSecurityGroup>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::securityGroups)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2NetworkInterfaceSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SourceDestCheck").getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::sourceDestCheck)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").build()}).build();
    private static final SdkField<List<AwsEc2NetworkInterfaceIpV6AddressDetail>> IP_V6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpV6Addresses").getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::ipV6Addresses)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::ipV6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2NetworkInterfaceIpV6AddressDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEc2NetworkInterfacePrivateIpAddressDetail>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::privateIpAddresses)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2NetworkInterfacePrivateIpAddressDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicDnsName").getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::publicDnsName)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::publicDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicDnsName").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::publicIp)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, NETWORK_INTERFACE_ID_FIELD, SECURITY_GROUPS_FIELD, SOURCE_DEST_CHECK_FIELD, IP_V6_ADDRESSES_FIELD, PRIVATE_IP_ADDRESSES_FIELD, PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Attachment", ATTACHMENT_FIELD);
            this.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
            this.put("SecurityGroups", SECURITY_GROUPS_FIELD);
            this.put("SourceDestCheck", SOURCE_DEST_CHECK_FIELD);
            this.put("IpV6Addresses", IP_V6_ADDRESSES_FIELD);
            this.put("PrivateIpAddresses", PRIVATE_IP_ADDRESSES_FIELD);
            this.put("PublicDnsName", PUBLIC_DNS_NAME_FIELD);
            this.put("PublicIp", PUBLIC_IP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AwsEc2NetworkInterfaceAttachment attachment;
    private final String networkInterfaceId;
    private final List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups;
    private final Boolean sourceDestCheck;
    private final List<AwsEc2NetworkInterfaceIpV6AddressDetail> ipV6Addresses;
    private final List<AwsEc2NetworkInterfacePrivateIpAddressDetail> privateIpAddresses;
    private final String publicDnsName;
    private final String publicIp;

    private AwsEc2NetworkInterfaceDetails(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.ipV6Addresses = builder.ipV6Addresses;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
    }

    public final AwsEc2NetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups() {
        return this.securityGroups;
    }

    public final Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public final boolean hasIpV6Addresses() {
        return this.ipV6Addresses != null && !(this.ipV6Addresses instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2NetworkInterfaceIpV6AddressDetail> ipV6Addresses() {
        return this.ipV6Addresses;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2NetworkInterfacePrivateIpAddressDetail> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final String publicDnsName() {
        return this.publicDnsName;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpV6Addresses() ? this.ipV6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceDetails)) {
            return false;
        }
        AwsEc2NetworkInterfaceDetails other = (AwsEc2NetworkInterfaceDetails)obj;
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && this.hasIpV6Addresses() == other.hasIpV6Addresses() && Objects.equals(this.ipV6Addresses(), other.ipV6Addresses()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.publicDnsName(), other.publicDnsName()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2NetworkInterfaceDetails").add("Attachment", (Object)this.attachment()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("IpV6Addresses", this.hasIpV6Addresses() ? this.ipV6Addresses() : null).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("PublicDnsName", (Object)this.publicDnsName()).add("PublicIp", (Object)this.publicIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "IpV6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipV6Addresses()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "PublicDnsName": {
                return Optional.ofNullable(clazz.cast(this.publicDnsName()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceDetails, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsEc2NetworkInterfaceAttachment attachment;
        private String networkInterfaceId;
        private List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean sourceDestCheck;
        private List<AwsEc2NetworkInterfaceIpV6AddressDetail> ipV6Addresses = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEc2NetworkInterfacePrivateIpAddressDetail> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private String publicDnsName;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceDetails model) {
            this.attachment(model.attachment);
            this.networkInterfaceId(model.networkInterfaceId);
            this.securityGroups(model.securityGroups);
            this.sourceDestCheck(model.sourceDestCheck);
            this.ipV6Addresses(model.ipV6Addresses);
            this.privateIpAddresses(model.privateIpAddresses);
            this.publicDnsName(model.publicDnsName);
            this.publicIp(model.publicIp);
        }

        public final AwsEc2NetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(AwsEc2NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(AwsEc2NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final List<AwsEc2NetworkInterfaceSecurityGroup.Builder> getSecurityGroups() {
            List<AwsEc2NetworkInterfaceSecurityGroup.Builder> result = AwsEc2NetworkInterfaceSecurityGroupListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = AwsEc2NetworkInterfaceSecurityGroupListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup> securityGroups) {
            this.securityGroups = AwsEc2NetworkInterfaceSecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(AwsEc2NetworkInterfaceSecurityGroup ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<AwsEc2NetworkInterfaceSecurityGroup.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (AwsEc2NetworkInterfaceSecurityGroup)((AwsEc2NetworkInterfaceSecurityGroup.Builder)AwsEc2NetworkInterfaceSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final List<AwsEc2NetworkInterfaceIpV6AddressDetail.Builder> getIpV6Addresses() {
            List<AwsEc2NetworkInterfaceIpV6AddressDetail.Builder> result = AwsEc2NetworkInterfaceIpV6AddressListCopier.copyToBuilder(this.ipV6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpV6Addresses(Collection<AwsEc2NetworkInterfaceIpV6AddressDetail.BuilderImpl> ipV6Addresses) {
            this.ipV6Addresses = AwsEc2NetworkInterfaceIpV6AddressListCopier.copyFromBuilder(ipV6Addresses);
        }

        @Override
        public final Builder ipV6Addresses(Collection<AwsEc2NetworkInterfaceIpV6AddressDetail> ipV6Addresses) {
            this.ipV6Addresses = AwsEc2NetworkInterfaceIpV6AddressListCopier.copy(ipV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(AwsEc2NetworkInterfaceIpV6AddressDetail ... ipV6Addresses) {
            this.ipV6Addresses(Arrays.asList(ipV6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(Consumer<AwsEc2NetworkInterfaceIpV6AddressDetail.Builder> ... ipV6Addresses) {
            this.ipV6Addresses(Stream.of(ipV6Addresses).map(c -> (AwsEc2NetworkInterfaceIpV6AddressDetail)((AwsEc2NetworkInterfaceIpV6AddressDetail.Builder)AwsEc2NetworkInterfaceIpV6AddressDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEc2NetworkInterfacePrivateIpAddressDetail.Builder> getPrivateIpAddresses() {
            List<AwsEc2NetworkInterfacePrivateIpAddressDetail.Builder> result = AwsEc2NetworkInterfacePrivateIpAddressListCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<AwsEc2NetworkInterfacePrivateIpAddressDetail.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = AwsEc2NetworkInterfacePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<AwsEc2NetworkInterfacePrivateIpAddressDetail> privateIpAddresses) {
            this.privateIpAddresses = AwsEc2NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(AwsEc2NetworkInterfacePrivateIpAddressDetail ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<AwsEc2NetworkInterfacePrivateIpAddressDetail.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (AwsEc2NetworkInterfacePrivateIpAddressDetail)((AwsEc2NetworkInterfacePrivateIpAddressDetail.Builder)AwsEc2NetworkInterfacePrivateIpAddressDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public AwsEc2NetworkInterfaceDetails build() {
            return new AwsEc2NetworkInterfaceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2NetworkInterfaceDetails> {
        public Builder attachment(AwsEc2NetworkInterfaceAttachment var1);

        default public Builder attachment(Consumer<AwsEc2NetworkInterfaceAttachment.Builder> attachment) {
            return this.attachment((AwsEc2NetworkInterfaceAttachment)((AwsEc2NetworkInterfaceAttachment.Builder)AwsEc2NetworkInterfaceAttachment.builder().applyMutation(attachment)).build());
        }

        public Builder networkInterfaceId(String var1);

        public Builder securityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup> var1);

        public Builder securityGroups(AwsEc2NetworkInterfaceSecurityGroup ... var1);

        public Builder securityGroups(Consumer<AwsEc2NetworkInterfaceSecurityGroup.Builder> ... var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder ipV6Addresses(Collection<AwsEc2NetworkInterfaceIpV6AddressDetail> var1);

        public Builder ipV6Addresses(AwsEc2NetworkInterfaceIpV6AddressDetail ... var1);

        public Builder ipV6Addresses(Consumer<AwsEc2NetworkInterfaceIpV6AddressDetail.Builder> ... var1);

        public Builder privateIpAddresses(Collection<AwsEc2NetworkInterfacePrivateIpAddressDetail> var1);

        public Builder privateIpAddresses(AwsEc2NetworkInterfacePrivateIpAddressDetail ... var1);

        public Builder privateIpAddresses(Consumer<AwsEc2NetworkInterfacePrivateIpAddressDetail.Builder> ... var1);

        public Builder publicDnsName(String var1);

        public Builder publicIp(String var1);
    }
}

