/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummaryListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationPolicyAssociationsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListConfigurationPolicyAssociationsResponse> {
    private static final SdkField<List<ConfigurationPolicyAssociationSummary>> CONFIGURATION_POLICY_ASSOCIATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationPolicyAssociationSummaries").getter(ListConfigurationPolicyAssociationsResponse.getter(ListConfigurationPolicyAssociationsResponse::configurationPolicyAssociationSummaries)).setter(ListConfigurationPolicyAssociationsResponse.setter(Builder::configurationPolicyAssociationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyAssociationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationPolicyAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationPolicyAssociationsResponse.getter(ListConfigurationPolicyAssociationsResponse::nextToken)).setter(ListConfigurationPolicyAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_POLICY_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries;
    private final String nextToken;

    private ListConfigurationPolicyAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationPolicyAssociationSummaries = builder.configurationPolicyAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationPolicyAssociationSummaries() {
        return this.configurationPolicyAssociationSummaries != null && !(this.configurationPolicyAssociationSummaries instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries() {
        return this.configurationPolicyAssociationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationPolicyAssociationSummaries() ? this.configurationPolicyAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationPolicyAssociationsResponse)) {
            return false;
        }
        ListConfigurationPolicyAssociationsResponse other = (ListConfigurationPolicyAssociationsResponse)((Object)obj);
        return this.hasConfigurationPolicyAssociationSummaries() == other.hasConfigurationPolicyAssociationSummaries() && Objects.equals(this.configurationPolicyAssociationSummaries(), other.configurationPolicyAssociationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationPolicyAssociationsResponse").add("ConfigurationPolicyAssociationSummaries", this.hasConfigurationPolicyAssociationSummaries() ? this.configurationPolicyAssociationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationPolicyAssociationSummaries": {
                return Optional.ofNullable(clazz.cast(this.configurationPolicyAssociationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationPolicyAssociationsResponse, T> g) {
        return obj -> g.apply((ListConfigurationPolicyAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationPolicyAssociationsResponse model) {
            super(model);
            this.configurationPolicyAssociationSummaries(model.configurationPolicyAssociationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationPolicyAssociationSummary.Builder> getConfigurationPolicyAssociationSummaries() {
            List<ConfigurationPolicyAssociationSummary.Builder> result = ConfigurationPolicyAssociationSummaryListCopier.copyToBuilder(this.configurationPolicyAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationPolicyAssociationSummaries(Collection<ConfigurationPolicyAssociationSummary.BuilderImpl> configurationPolicyAssociationSummaries) {
            this.configurationPolicyAssociationSummaries = ConfigurationPolicyAssociationSummaryListCopier.copyFromBuilder(configurationPolicyAssociationSummaries);
        }

        @Override
        public final Builder configurationPolicyAssociationSummaries(Collection<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries) {
            this.configurationPolicyAssociationSummaries = ConfigurationPolicyAssociationSummaryListCopier.copy(configurationPolicyAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociationSummaries(ConfigurationPolicyAssociationSummary ... configurationPolicyAssociationSummaries) {
            this.configurationPolicyAssociationSummaries(Arrays.asList(configurationPolicyAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociationSummaries(Consumer<ConfigurationPolicyAssociationSummary.Builder> ... configurationPolicyAssociationSummaries) {
            this.configurationPolicyAssociationSummaries(Stream.of(configurationPolicyAssociationSummaries).map(c -> (ConfigurationPolicyAssociationSummary)((ConfigurationPolicyAssociationSummary.Builder)ConfigurationPolicyAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationPolicyAssociationsResponse build() {
            return new ListConfigurationPolicyAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationPolicyAssociationsResponse> {
        public Builder configurationPolicyAssociationSummaries(Collection<ConfigurationPolicyAssociationSummary> var1);

        public Builder configurationPolicyAssociationSummaries(ConfigurationPolicyAssociationSummary ... var1);

        public Builder configurationPolicyAssociationSummaries(Consumer<ConfigurationPolicyAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

