/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFieldsUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationRulesAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationRulesAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AutomationRulesAction.getter(AutomationRulesAction::typeAsString)).setter(AutomationRulesAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<AutomationRulesFindingFieldsUpdate> FINDING_FIELDS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindingFieldsUpdate").getter(AutomationRulesAction.getter(AutomationRulesAction::findingFieldsUpdate)).setter(AutomationRulesAction.setter(Builder::findingFieldsUpdate)).constructor(AutomationRulesFindingFieldsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingFieldsUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, FINDING_FIELDS_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final AutomationRulesFindingFieldsUpdate findingFieldsUpdate;

    private AutomationRulesAction(BuilderImpl builder) {
        this.type = builder.type;
        this.findingFieldsUpdate = builder.findingFieldsUpdate;
    }

    public final AutomationRulesActionType type() {
        return AutomationRulesActionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AutomationRulesFindingFieldsUpdate findingFieldsUpdate() {
        return this.findingFieldsUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingFieldsUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesAction)) {
            return false;
        }
        AutomationRulesAction other = (AutomationRulesAction)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.findingFieldsUpdate(), other.findingFieldsUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationRulesAction").add("Type", (Object)this.typeAsString()).add("FindingFieldsUpdate", (Object)this.findingFieldsUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "FindingFieldsUpdate": {
                return Optional.ofNullable(clazz.cast(this.findingFieldsUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesAction, T> g) {
        return obj -> g.apply((AutomationRulesAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private AutomationRulesFindingFieldsUpdate findingFieldsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesAction model) {
            this.type(model.type);
            this.findingFieldsUpdate(model.findingFieldsUpdate);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AutomationRulesActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AutomationRulesFindingFieldsUpdate.Builder getFindingFieldsUpdate() {
            return this.findingFieldsUpdate != null ? this.findingFieldsUpdate.toBuilder() : null;
        }

        public final void setFindingFieldsUpdate(AutomationRulesFindingFieldsUpdate.BuilderImpl findingFieldsUpdate) {
            this.findingFieldsUpdate = findingFieldsUpdate != null ? findingFieldsUpdate.build() : null;
        }

        @Override
        public final Builder findingFieldsUpdate(AutomationRulesFindingFieldsUpdate findingFieldsUpdate) {
            this.findingFieldsUpdate = findingFieldsUpdate;
            return this;
        }

        public AutomationRulesAction build() {
            return new AutomationRulesAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationRulesAction> {
        public Builder type(String var1);

        public Builder type(AutomationRulesActionType var1);

        public Builder findingFieldsUpdate(AutomationRulesFindingFieldsUpdate var1);

        default public Builder findingFieldsUpdate(Consumer<AutomationRulesFindingFieldsUpdate.Builder> findingFieldsUpdate) {
            return this.findingFieldsUpdate((AutomationRulesFindingFieldsUpdate)((AutomationRulesFindingFieldsUpdate.Builder)AutomationRulesFindingFieldsUpdate.builder().applyMutation(findingFieldsUpdate)).build());
        }
    }
}

