/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An encryption rule to apply to the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketServerSideEncryptionRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketServerSideEncryptionRule.Builder, AwsS3BucketServerSideEncryptionRule> {
    private static final SdkField<AwsS3BucketServerSideEncryptionByDefault> APPLY_SERVER_SIDE_ENCRYPTION_BY_DEFAULT_FIELD = SdkField
            .<AwsS3BucketServerSideEncryptionByDefault> builder(MarshallingType.SDK_POJO)
            .memberName("ApplyServerSideEncryptionByDefault")
            .getter(getter(AwsS3BucketServerSideEncryptionRule::applyServerSideEncryptionByDefault))
            .setter(setter(Builder::applyServerSideEncryptionByDefault))
            .constructor(AwsS3BucketServerSideEncryptionByDefault::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyServerSideEncryptionByDefault")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLY_SERVER_SIDE_ENCRYPTION_BY_DEFAULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsS3BucketServerSideEncryptionByDefault applyServerSideEncryptionByDefault;

    private AwsS3BucketServerSideEncryptionRule(BuilderImpl builder) {
        this.applyServerSideEncryptionByDefault = builder.applyServerSideEncryptionByDefault;
    }

    /**
     * <p>
     * Specifies the default server-side encryption to apply to new objects in the bucket. If a <code>PUT</code> object
     * request doesn't specify any server-side encryption, this default encryption is applied.
     * </p>
     * 
     * @return Specifies the default server-side encryption to apply to new objects in the bucket. If a <code>PUT</code>
     *         object request doesn't specify any server-side encryption, this default encryption is applied.
     */
    public final AwsS3BucketServerSideEncryptionByDefault applyServerSideEncryptionByDefault() {
        return applyServerSideEncryptionByDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applyServerSideEncryptionByDefault());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketServerSideEncryptionRule)) {
            return false;
        }
        AwsS3BucketServerSideEncryptionRule other = (AwsS3BucketServerSideEncryptionRule) obj;
        return Objects.equals(applyServerSideEncryptionByDefault(), other.applyServerSideEncryptionByDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketServerSideEncryptionRule")
                .add("ApplyServerSideEncryptionByDefault", applyServerSideEncryptionByDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplyServerSideEncryptionByDefault":
            return Optional.ofNullable(clazz.cast(applyServerSideEncryptionByDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketServerSideEncryptionRule, T> g) {
        return obj -> g.apply((AwsS3BucketServerSideEncryptionRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketServerSideEncryptionRule> {
        /**
         * <p>
         * Specifies the default server-side encryption to apply to new objects in the bucket. If a <code>PUT</code>
         * object request doesn't specify any server-side encryption, this default encryption is applied.
         * </p>
         * 
         * @param applyServerSideEncryptionByDefault
         *        Specifies the default server-side encryption to apply to new objects in the bucket. If a
         *        <code>PUT</code> object request doesn't specify any server-side encryption, this default encryption is
         *        applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyServerSideEncryptionByDefault(AwsS3BucketServerSideEncryptionByDefault applyServerSideEncryptionByDefault);

        /**
         * <p>
         * Specifies the default server-side encryption to apply to new objects in the bucket. If a <code>PUT</code>
         * object request doesn't specify any server-side encryption, this default encryption is applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketServerSideEncryptionByDefault.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketServerSideEncryptionByDefault#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketServerSideEncryptionByDefault.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #applyServerSideEncryptionByDefault(AwsS3BucketServerSideEncryptionByDefault)}.
         * 
         * @param applyServerSideEncryptionByDefault
         *        a consumer that will call methods on {@link AwsS3BucketServerSideEncryptionByDefault.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applyServerSideEncryptionByDefault(AwsS3BucketServerSideEncryptionByDefault)
         */
        default Builder applyServerSideEncryptionByDefault(
                Consumer<AwsS3BucketServerSideEncryptionByDefault.Builder> applyServerSideEncryptionByDefault) {
            return applyServerSideEncryptionByDefault(AwsS3BucketServerSideEncryptionByDefault.builder()
                    .applyMutation(applyServerSideEncryptionByDefault).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsS3BucketServerSideEncryptionByDefault applyServerSideEncryptionByDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketServerSideEncryptionRule model) {
            applyServerSideEncryptionByDefault(model.applyServerSideEncryptionByDefault);
        }

        public final AwsS3BucketServerSideEncryptionByDefault.Builder getApplyServerSideEncryptionByDefault() {
            return applyServerSideEncryptionByDefault != null ? applyServerSideEncryptionByDefault.toBuilder() : null;
        }

        public final void setApplyServerSideEncryptionByDefault(
                AwsS3BucketServerSideEncryptionByDefault.BuilderImpl applyServerSideEncryptionByDefault) {
            this.applyServerSideEncryptionByDefault = applyServerSideEncryptionByDefault != null ? applyServerSideEncryptionByDefault
                    .build() : null;
        }

        @Override
        public final Builder applyServerSideEncryptionByDefault(
                AwsS3BucketServerSideEncryptionByDefault applyServerSideEncryptionByDefault) {
            this.applyServerSideEncryptionByDefault = applyServerSideEncryptionByDefault;
            return this;
        }

        @Override
        public AwsS3BucketServerSideEncryptionRule build() {
            return new AwsS3BucketServerSideEncryptionRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
