/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a Classic Load Balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElbLoadBalancerDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElbLoadBalancerDetails.Builder, AwsElbLoadBalancerDetails> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(AwsElbLoadBalancerDetails::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsElbLoadBalancerBackendServerDescription>> BACKEND_SERVER_DESCRIPTIONS_FIELD = SdkField
            .<List<AwsElbLoadBalancerBackendServerDescription>> builder(MarshallingType.LIST)
            .memberName("BackendServerDescriptions")
            .getter(getter(AwsElbLoadBalancerDetails::backendServerDescriptions))
            .setter(setter(Builder::backendServerDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackendServerDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsElbLoadBalancerBackendServerDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsElbLoadBalancerBackendServerDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CANONICAL_HOSTED_ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CanonicalHostedZoneName").getter(getter(AwsElbLoadBalancerDetails::canonicalHostedZoneName))
            .setter(setter(Builder::canonicalHostedZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneName").build())
            .build();

    private static final SdkField<String> CANONICAL_HOSTED_ZONE_NAME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CanonicalHostedZoneNameID").getter(getter(AwsElbLoadBalancerDetails::canonicalHostedZoneNameID))
            .setter(setter(Builder::canonicalHostedZoneNameID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneNameID").build())
            .build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(AwsElbLoadBalancerDetails::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsName").getter(getter(AwsElbLoadBalancerDetails::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()).build();

    private static final SdkField<AwsElbLoadBalancerHealthCheck> HEALTH_CHECK_FIELD = SdkField
            .<AwsElbLoadBalancerHealthCheck> builder(MarshallingType.SDK_POJO).memberName("HealthCheck")
            .getter(getter(AwsElbLoadBalancerDetails::healthCheck)).setter(setter(Builder::healthCheck))
            .constructor(AwsElbLoadBalancerHealthCheck::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()).build();

    private static final SdkField<List<AwsElbLoadBalancerInstance>> INSTANCES_FIELD = SdkField
            .<List<AwsElbLoadBalancerInstance>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(AwsElbLoadBalancerDetails::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsElbLoadBalancerInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsElbLoadBalancerInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsElbLoadBalancerListenerDescription>> LISTENER_DESCRIPTIONS_FIELD = SdkField
            .<List<AwsElbLoadBalancerListenerDescription>> builder(MarshallingType.LIST)
            .memberName("ListenerDescriptions")
            .getter(getter(AwsElbLoadBalancerDetails::listenerDescriptions))
            .setter(setter(Builder::listenerDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsElbLoadBalancerListenerDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsElbLoadBalancerListenerDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsElbLoadBalancerAttributes> LOAD_BALANCER_ATTRIBUTES_FIELD = SdkField
            .<AwsElbLoadBalancerAttributes> builder(MarshallingType.SDK_POJO).memberName("LoadBalancerAttributes")
            .getter(getter(AwsElbLoadBalancerDetails::loadBalancerAttributes)).setter(setter(Builder::loadBalancerAttributes))
            .constructor(AwsElbLoadBalancerAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAttributes").build())
            .build();

    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(AwsElbLoadBalancerDetails::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<AwsElbLoadBalancerPolicies> POLICIES_FIELD = SdkField
            .<AwsElbLoadBalancerPolicies> builder(MarshallingType.SDK_POJO).memberName("Policies")
            .getter(getter(AwsElbLoadBalancerDetails::policies)).setter(setter(Builder::policies))
            .constructor(AwsElbLoadBalancerPolicies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()).build();

    private static final SdkField<String> SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scheme")
            .getter(getter(AwsElbLoadBalancerDetails::scheme)).setter(setter(Builder::scheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(AwsElbLoadBalancerDetails::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsElbLoadBalancerSourceSecurityGroup> SOURCE_SECURITY_GROUP_FIELD = SdkField
            .<AwsElbLoadBalancerSourceSecurityGroup> builder(MarshallingType.SDK_POJO).memberName("SourceSecurityGroup")
            .getter(getter(AwsElbLoadBalancerDetails::sourceSecurityGroup)).setter(setter(Builder::sourceSecurityGroup))
            .constructor(AwsElbLoadBalancerSourceSecurityGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroup").build())
            .build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(AwsElbLoadBalancerDetails::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsElbLoadBalancerDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            BACKEND_SERVER_DESCRIPTIONS_FIELD, CANONICAL_HOSTED_ZONE_NAME_FIELD, CANONICAL_HOSTED_ZONE_NAME_ID_FIELD,
            CREATED_TIME_FIELD, DNS_NAME_FIELD, HEALTH_CHECK_FIELD, INSTANCES_FIELD, LISTENER_DESCRIPTIONS_FIELD,
            LOAD_BALANCER_ATTRIBUTES_FIELD, LOAD_BALANCER_NAME_FIELD, POLICIES_FIELD, SCHEME_FIELD, SECURITY_GROUPS_FIELD,
            SOURCE_SECURITY_GROUP_FIELD, SUBNETS_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> availabilityZones;

    private final List<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions;

    private final String canonicalHostedZoneName;

    private final String canonicalHostedZoneNameID;

    private final String createdTime;

    private final String dnsName;

    private final AwsElbLoadBalancerHealthCheck healthCheck;

    private final List<AwsElbLoadBalancerInstance> instances;

    private final List<AwsElbLoadBalancerListenerDescription> listenerDescriptions;

    private final AwsElbLoadBalancerAttributes loadBalancerAttributes;

    private final String loadBalancerName;

    private final AwsElbLoadBalancerPolicies policies;

    private final String scheme;

    private final List<String> securityGroups;

    private final AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup;

    private final List<String> subnets;

    private final String vpcId;

    private AwsElbLoadBalancerDetails(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.backendServerDescriptions = builder.backendServerDescriptions;
        this.canonicalHostedZoneName = builder.canonicalHostedZoneName;
        this.canonicalHostedZoneNameID = builder.canonicalHostedZoneNameID;
        this.createdTime = builder.createdTime;
        this.dnsName = builder.dnsName;
        this.healthCheck = builder.healthCheck;
        this.instances = builder.instances;
        this.listenerDescriptions = builder.listenerDescriptions;
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
        this.loadBalancerName = builder.loadBalancerName;
        this.policies = builder.policies;
        this.scheme = builder.scheme;
        this.securityGroups = builder.securityGroups;
        this.sourceSecurityGroup = builder.sourceSecurityGroup;
        this.subnets = builder.subnets;
        this.vpcId = builder.vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Availability Zones for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The list of Availability Zones for the load balancer.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackendServerDescriptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBackendServerDescriptions() {
        return backendServerDescriptions != null && !(backendServerDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the configuration of the EC2 instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackendServerDescriptions} method.
     * </p>
     * 
     * @return Information about the configuration of the EC2 instances.
     */
    public final List<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions() {
        return backendServerDescriptions;
    }

    /**
     * <p>
     * The name of the Amazon Route 53 hosted zone for the load balancer.
     * </p>
     * 
     * @return The name of the Amazon Route 53 hosted zone for the load balancer.
     */
    public final String canonicalHostedZoneName() {
        return canonicalHostedZoneName;
    }

    /**
     * <p>
     * The ID of the Amazon Route 53 hosted zone for the load balancer.
     * </p>
     * 
     * @return The ID of the Amazon Route 53 hosted zone for the load balancer.
     */
    public final String canonicalHostedZoneNameID() {
        return canonicalHostedZoneNameID;
    }

    /**
     * <p>
     * Indicates when the load balancer was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the load balancer was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The DNS name of the load balancer.
     * </p>
     * 
     * @return The DNS name of the load balancer.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * Information about the health checks that are conducted on the load balancer.
     * </p>
     * 
     * @return Information about the health checks that are conducted on the load balancer.
     */
    public final AwsElbLoadBalancerHealthCheck healthCheck() {
        return healthCheck;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of EC2 instances for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return List of EC2 instances for the load balancer.
     */
    public final List<AwsElbLoadBalancerInstance> instances() {
        return instances;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListenerDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListenerDescriptions() {
        return listenerDescriptions != null && !(listenerDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policies that are enabled for the load balancer listeners.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListenerDescriptions} method.
     * </p>
     * 
     * @return The policies that are enabled for the load balancer listeners.
     */
    public final List<AwsElbLoadBalancerListenerDescription> listenerDescriptions() {
        return listenerDescriptions;
    }

    /**
     * <p>
     * The attributes for a load balancer.
     * </p>
     * 
     * @return The attributes for a load balancer.
     */
    public final AwsElbLoadBalancerAttributes loadBalancerAttributes() {
        return loadBalancerAttributes;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The policies for a load balancer.
     * </p>
     * 
     * @return The policies for a load balancer.
     */
    public final AwsElbLoadBalancerPolicies policies() {
        return policies;
    }

    /**
     * <p>
     * The type of load balancer. Only provided if the load balancer is in a VPC.
     * </p>
     * <p>
     * If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that resolves to
     * a public IP address.
     * </p>
     * <p>
     * If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to a
     * private IP address.
     * </p>
     * 
     * @return The type of load balancer. Only provided if the load balancer is in a VPC.</p>
     *         <p>
     *         If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that
     *         resolves to a public IP address.
     *         </p>
     *         <p>
     *         If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to
     *         a private IP address.
     */
    public final String scheme() {
        return scheme;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the load balancer. Only provided if the load balancer is in a VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The security groups for the load balancer. Only provided if the load balancer is in a VPC.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Information about the security group for the load balancer. This is the security group that is used for inbound
     * rules.
     * </p>
     * 
     * @return Information about the security group for the load balancer. This is the security group that is used for
     *         inbound rules.
     */
    public final AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup() {
        return sourceSecurityGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of subnet identifiers for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The list of subnet identifiers for the load balancer.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * <p>
     * The identifier of the VPC for the load balancer.
     * </p>
     * 
     * @return The identifier of the VPC for the load balancer.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBackendServerDescriptions() ? backendServerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(canonicalHostedZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(canonicalHostedZoneNameID());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerDescriptions() ? listenerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        hashCode = 31 * hashCode + Objects.hashCode(scheme());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerDetails)) {
            return false;
        }
        AwsElbLoadBalancerDetails other = (AwsElbLoadBalancerDetails) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && hasBackendServerDescriptions() == other.hasBackendServerDescriptions()
                && Objects.equals(backendServerDescriptions(), other.backendServerDescriptions())
                && Objects.equals(canonicalHostedZoneName(), other.canonicalHostedZoneName())
                && Objects.equals(canonicalHostedZoneNameID(), other.canonicalHostedZoneNameID())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(healthCheck(), other.healthCheck()) && hasInstances() == other.hasInstances()
                && Objects.equals(instances(), other.instances()) && hasListenerDescriptions() == other.hasListenerDescriptions()
                && Objects.equals(listenerDescriptions(), other.listenerDescriptions())
                && Objects.equals(loadBalancerAttributes(), other.loadBalancerAttributes())
                && Objects.equals(loadBalancerName(), other.loadBalancerName()) && Objects.equals(policies(), other.policies())
                && Objects.equals(scheme(), other.scheme()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(sourceSecurityGroup(), other.sourceSecurityGroup()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElbLoadBalancerDetails")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("BackendServerDescriptions", hasBackendServerDescriptions() ? backendServerDescriptions() : null)
                .add("CanonicalHostedZoneName", canonicalHostedZoneName())
                .add("CanonicalHostedZoneNameID", canonicalHostedZoneNameID()).add("CreatedTime", createdTime())
                .add("DnsName", dnsName()).add("HealthCheck", healthCheck())
                .add("Instances", hasInstances() ? instances() : null)
                .add("ListenerDescriptions", hasListenerDescriptions() ? listenerDescriptions() : null)
                .add("LoadBalancerAttributes", loadBalancerAttributes()).add("LoadBalancerName", loadBalancerName())
                .add("Policies", policies()).add("Scheme", scheme())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("SourceSecurityGroup", sourceSecurityGroup()).add("Subnets", hasSubnets() ? subnets() : null)
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "BackendServerDescriptions":
            return Optional.ofNullable(clazz.cast(backendServerDescriptions()));
        case "CanonicalHostedZoneName":
            return Optional.ofNullable(clazz.cast(canonicalHostedZoneName()));
        case "CanonicalHostedZoneNameID":
            return Optional.ofNullable(clazz.cast(canonicalHostedZoneNameID()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "HealthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "ListenerDescriptions":
            return Optional.ofNullable(clazz.cast(listenerDescriptions()));
        case "LoadBalancerAttributes":
            return Optional.ofNullable(clazz.cast(loadBalancerAttributes()));
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "Scheme":
            return Optional.ofNullable(clazz.cast(scheme()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SourceSecurityGroup":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroup()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerDetails, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElbLoadBalancerDetails> {
        /**
         * <p>
         * The list of Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The list of Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The list of Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The list of Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * Information about the configuration of the EC2 instances.
         * </p>
         * 
         * @param backendServerDescriptions
         *        Information about the configuration of the EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendServerDescriptions(Collection<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions);

        /**
         * <p>
         * Information about the configuration of the EC2 instances.
         * </p>
         * 
         * @param backendServerDescriptions
         *        Information about the configuration of the EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendServerDescriptions(AwsElbLoadBalancerBackendServerDescription... backendServerDescriptions);

        /**
         * <p>
         * Information about the configuration of the EC2 instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #backendServerDescriptions(List<AwsElbLoadBalancerBackendServerDescription>)}.
         * 
         * @param backendServerDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backendServerDescriptions(java.util.Collection<AwsElbLoadBalancerBackendServerDescription>)
         */
        Builder backendServerDescriptions(
                Consumer<AwsElbLoadBalancerBackendServerDescription.Builder>... backendServerDescriptions);

        /**
         * <p>
         * The name of the Amazon Route 53 hosted zone for the load balancer.
         * </p>
         * 
         * @param canonicalHostedZoneName
         *        The name of the Amazon Route 53 hosted zone for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canonicalHostedZoneName(String canonicalHostedZoneName);

        /**
         * <p>
         * The ID of the Amazon Route 53 hosted zone for the load balancer.
         * </p>
         * 
         * @param canonicalHostedZoneNameID
         *        The ID of the Amazon Route 53 hosted zone for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canonicalHostedZoneNameID(String canonicalHostedZoneNameID);

        /**
         * <p>
         * Indicates when the load balancer was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdTime
         *        Indicates when the load balancer was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The DNS name of the load balancer.
         * </p>
         * 
         * @param dnsName
         *        The DNS name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * Information about the health checks that are conducted on the load balancer.
         * </p>
         * 
         * @param healthCheck
         *        Information about the health checks that are conducted on the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(AwsElbLoadBalancerHealthCheck healthCheck);

        /**
         * <p>
         * Information about the health checks that are conducted on the load balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsElbLoadBalancerHealthCheck.Builder}
         * avoiding the need to create one manually via {@link AwsElbLoadBalancerHealthCheck#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerHealthCheck.Builder#build()} is called
         * immediately and its result is passed to {@link #healthCheck(AwsElbLoadBalancerHealthCheck)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on {@link AwsElbLoadBalancerHealthCheck.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(AwsElbLoadBalancerHealthCheck)
         */
        default Builder healthCheck(Consumer<AwsElbLoadBalancerHealthCheck.Builder> healthCheck) {
            return healthCheck(AwsElbLoadBalancerHealthCheck.builder().applyMutation(healthCheck).build());
        }

        /**
         * <p>
         * List of EC2 instances for the load balancer.
         * </p>
         * 
         * @param instances
         *        List of EC2 instances for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<AwsElbLoadBalancerInstance> instances);

        /**
         * <p>
         * List of EC2 instances for the load balancer.
         * </p>
         * 
         * @param instances
         *        List of EC2 instances for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(AwsElbLoadBalancerInstance... instances);

        /**
         * <p>
         * List of EC2 instances for the load balancer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance.Builder#build()} is
         * called immediately and its result is passed to {@link #instances(List<AwsElbLoadBalancerInstance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(java.util.Collection<AwsElbLoadBalancerInstance>)
         */
        Builder instances(Consumer<AwsElbLoadBalancerInstance.Builder>... instances);

        /**
         * <p>
         * The policies that are enabled for the load balancer listeners.
         * </p>
         * 
         * @param listenerDescriptions
         *        The policies that are enabled for the load balancer listeners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerDescriptions(Collection<AwsElbLoadBalancerListenerDescription> listenerDescriptions);

        /**
         * <p>
         * The policies that are enabled for the load balancer listeners.
         * </p>
         * 
         * @param listenerDescriptions
         *        The policies that are enabled for the load balancer listeners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerDescriptions(AwsElbLoadBalancerListenerDescription... listenerDescriptions);

        /**
         * <p>
         * The policies that are enabled for the load balancer listeners.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #listenerDescriptions(List<AwsElbLoadBalancerListenerDescription>)}.
         * 
         * @param listenerDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listenerDescriptions(java.util.Collection<AwsElbLoadBalancerListenerDescription>)
         */
        Builder listenerDescriptions(Consumer<AwsElbLoadBalancerListenerDescription.Builder>... listenerDescriptions);

        /**
         * <p>
         * The attributes for a load balancer.
         * </p>
         * 
         * @param loadBalancerAttributes
         *        The attributes for a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAttributes(AwsElbLoadBalancerAttributes loadBalancerAttributes);

        /**
         * <p>
         * The attributes for a load balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsElbLoadBalancerAttributes.Builder}
         * avoiding the need to create one manually via {@link AwsElbLoadBalancerAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #loadBalancerAttributes(AwsElbLoadBalancerAttributes)}.
         * 
         * @param loadBalancerAttributes
         *        a consumer that will call methods on {@link AwsElbLoadBalancerAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerAttributes(AwsElbLoadBalancerAttributes)
         */
        default Builder loadBalancerAttributes(Consumer<AwsElbLoadBalancerAttributes.Builder> loadBalancerAttributes) {
            return loadBalancerAttributes(AwsElbLoadBalancerAttributes.builder().applyMutation(loadBalancerAttributes).build());
        }

        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The policies for a load balancer.
         * </p>
         * 
         * @param policies
         *        The policies for a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(AwsElbLoadBalancerPolicies policies);

        /**
         * <p>
         * The policies for a load balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsElbLoadBalancerPolicies.Builder}
         * avoiding the need to create one manually via {@link AwsElbLoadBalancerPolicies#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerPolicies.Builder#build()} is called immediately
         * and its result is passed to {@link #policies(AwsElbLoadBalancerPolicies)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link AwsElbLoadBalancerPolicies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(AwsElbLoadBalancerPolicies)
         */
        default Builder policies(Consumer<AwsElbLoadBalancerPolicies.Builder> policies) {
            return policies(AwsElbLoadBalancerPolicies.builder().applyMutation(policies).build());
        }

        /**
         * <p>
         * The type of load balancer. Only provided if the load balancer is in a VPC.
         * </p>
         * <p>
         * If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that resolves
         * to a public IP address.
         * </p>
         * <p>
         * If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to a
         * private IP address.
         * </p>
         * 
         * @param scheme
         *        The type of load balancer. Only provided if the load balancer is in a VPC.</p>
         *        <p>
         *        If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that
         *        resolves to a public IP address.
         *        </p>
         *        <p>
         *        If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves
         *        to a private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheme(String scheme);

        /**
         * <p>
         * The security groups for the load balancer. Only provided if the load balancer is in a VPC.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the load balancer. Only provided if the load balancer is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The security groups for the load balancer. Only provided if the load balancer is in a VPC.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the load balancer. Only provided if the load balancer is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * Information about the security group for the load balancer. This is the security group that is used for
         * inbound rules.
         * </p>
         * 
         * @param sourceSecurityGroup
         *        Information about the security group for the load balancer. This is the security group that is used
         *        for inbound rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup);

        /**
         * <p>
         * Information about the security group for the load balancer. This is the security group that is used for
         * inbound rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElbLoadBalancerSourceSecurityGroup.Builder} avoiding the need to create one manually via
         * {@link AwsElbLoadBalancerSourceSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerSourceSecurityGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup)}.
         * 
         * @param sourceSecurityGroup
         *        a consumer that will call methods on {@link AwsElbLoadBalancerSourceSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup)
         */
        default Builder sourceSecurityGroup(Consumer<AwsElbLoadBalancerSourceSecurityGroup.Builder> sourceSecurityGroup) {
            return sourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup.builder().applyMutation(sourceSecurityGroup).build());
        }

        /**
         * <p>
         * The list of subnet identifiers for the load balancer.
         * </p>
         * 
         * @param subnets
         *        The list of subnet identifiers for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The list of subnet identifiers for the load balancer.
         * </p>
         * 
         * @param subnets
         *        The list of subnet identifiers for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The identifier of the VPC for the load balancer.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions = DefaultSdkAutoConstructList
                .getInstance();

        private String canonicalHostedZoneName;

        private String canonicalHostedZoneNameID;

        private String createdTime;

        private String dnsName;

        private AwsElbLoadBalancerHealthCheck healthCheck;

        private List<AwsElbLoadBalancerInstance> instances = DefaultSdkAutoConstructList.getInstance();

        private List<AwsElbLoadBalancerListenerDescription> listenerDescriptions = DefaultSdkAutoConstructList.getInstance();

        private AwsElbLoadBalancerAttributes loadBalancerAttributes;

        private String loadBalancerName;

        private AwsElbLoadBalancerPolicies policies;

        private String scheme;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerDetails model) {
            availabilityZones(model.availabilityZones);
            backendServerDescriptions(model.backendServerDescriptions);
            canonicalHostedZoneName(model.canonicalHostedZoneName);
            canonicalHostedZoneNameID(model.canonicalHostedZoneNameID);
            createdTime(model.createdTime);
            dnsName(model.dnsName);
            healthCheck(model.healthCheck);
            instances(model.instances);
            listenerDescriptions(model.listenerDescriptions);
            loadBalancerAttributes(model.loadBalancerAttributes);
            loadBalancerName(model.loadBalancerName);
            policies(model.policies);
            scheme(model.scheme);
            securityGroups(model.securityGroups);
            sourceSecurityGroup(model.sourceSecurityGroup);
            subnets(model.subnets);
            vpcId(model.vpcId);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final List<AwsElbLoadBalancerBackendServerDescription.Builder> getBackendServerDescriptions() {
            List<AwsElbLoadBalancerBackendServerDescription.Builder> result = AwsElbLoadBalancerBackendServerDescriptionsCopier
                    .copyToBuilder(this.backendServerDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackendServerDescriptions(
                Collection<AwsElbLoadBalancerBackendServerDescription.BuilderImpl> backendServerDescriptions) {
            this.backendServerDescriptions = AwsElbLoadBalancerBackendServerDescriptionsCopier
                    .copyFromBuilder(backendServerDescriptions);
        }

        @Override
        public final Builder backendServerDescriptions(
                Collection<AwsElbLoadBalancerBackendServerDescription> backendServerDescriptions) {
            this.backendServerDescriptions = AwsElbLoadBalancerBackendServerDescriptionsCopier.copy(backendServerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(AwsElbLoadBalancerBackendServerDescription... backendServerDescriptions) {
            backendServerDescriptions(Arrays.asList(backendServerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(
                Consumer<AwsElbLoadBalancerBackendServerDescription.Builder>... backendServerDescriptions) {
            backendServerDescriptions(Stream.of(backendServerDescriptions)
                    .map(c -> AwsElbLoadBalancerBackendServerDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCanonicalHostedZoneName() {
            return canonicalHostedZoneName;
        }

        public final void setCanonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
        }

        @Override
        public final Builder canonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
            return this;
        }

        public final String getCanonicalHostedZoneNameID() {
            return canonicalHostedZoneNameID;
        }

        public final void setCanonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
        }

        @Override
        public final Builder canonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final AwsElbLoadBalancerHealthCheck.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(AwsElbLoadBalancerHealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(AwsElbLoadBalancerHealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final List<AwsElbLoadBalancerInstance.Builder> getInstances() {
            List<AwsElbLoadBalancerInstance.Builder> result = AwsElbLoadBalancerInstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<AwsElbLoadBalancerInstance.BuilderImpl> instances) {
            this.instances = AwsElbLoadBalancerInstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<AwsElbLoadBalancerInstance> instances) {
            this.instances = AwsElbLoadBalancerInstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(AwsElbLoadBalancerInstance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<AwsElbLoadBalancerInstance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> AwsElbLoadBalancerInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsElbLoadBalancerListenerDescription.Builder> getListenerDescriptions() {
            List<AwsElbLoadBalancerListenerDescription.Builder> result = AwsElbLoadBalancerListenerDescriptionsCopier
                    .copyToBuilder(this.listenerDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerDescriptions(
                Collection<AwsElbLoadBalancerListenerDescription.BuilderImpl> listenerDescriptions) {
            this.listenerDescriptions = AwsElbLoadBalancerListenerDescriptionsCopier.copyFromBuilder(listenerDescriptions);
        }

        @Override
        public final Builder listenerDescriptions(Collection<AwsElbLoadBalancerListenerDescription> listenerDescriptions) {
            this.listenerDescriptions = AwsElbLoadBalancerListenerDescriptionsCopier.copy(listenerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(AwsElbLoadBalancerListenerDescription... listenerDescriptions) {
            listenerDescriptions(Arrays.asList(listenerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(Consumer<AwsElbLoadBalancerListenerDescription.Builder>... listenerDescriptions) {
            listenerDescriptions(Stream.of(listenerDescriptions)
                    .map(c -> AwsElbLoadBalancerListenerDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsElbLoadBalancerAttributes.Builder getLoadBalancerAttributes() {
            return loadBalancerAttributes != null ? loadBalancerAttributes.toBuilder() : null;
        }

        public final void setLoadBalancerAttributes(AwsElbLoadBalancerAttributes.BuilderImpl loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes != null ? loadBalancerAttributes.build() : null;
        }

        @Override
        public final Builder loadBalancerAttributes(AwsElbLoadBalancerAttributes loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final AwsElbLoadBalancerPolicies.Builder getPolicies() {
            return policies != null ? policies.toBuilder() : null;
        }

        public final void setPolicies(AwsElbLoadBalancerPolicies.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        @Override
        public final Builder policies(AwsElbLoadBalancerPolicies policies) {
            this.policies = policies;
            return this;
        }

        public final String getScheme() {
            return scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final AwsElbLoadBalancerSourceSecurityGroup.Builder getSourceSecurityGroup() {
            return sourceSecurityGroup != null ? sourceSecurityGroup.toBuilder() : null;
        }

        public final void setSourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup.BuilderImpl sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup != null ? sourceSecurityGroup.build() : null;
        }

        @Override
        public final Builder sourceSecurityGroup(AwsElbLoadBalancerSourceSecurityGroup sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public AwsElbLoadBalancerDetails build() {
            return new AwsElbLoadBalancerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
