/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationSummary;

public class ListStandardsControlAssociationsPublisher
implements SdkPublisher<ListStandardsControlAssociationsResponse> {
    private final SecurityHubAsyncClient client;
    private final ListStandardsControlAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStandardsControlAssociationsPublisher(SecurityHubAsyncClient client, ListStandardsControlAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStandardsControlAssociationsPublisher(SecurityHubAsyncClient client, ListStandardsControlAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStandardsControlAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStandardsControlAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StandardsControlAssociationSummary> standardsControlAssociationSummaries() {
        Function<ListStandardsControlAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.standardsControlAssociationSummaries() != null) {
                return response.standardsControlAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStandardsControlAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStandardsControlAssociationsResponseFetcher
    implements AsyncPageFetcher<ListStandardsControlAssociationsResponse> {
        private ListStandardsControlAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListStandardsControlAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStandardsControlAssociationsResponse> nextPage(ListStandardsControlAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListStandardsControlAssociationsPublisher.this.client.listStandardsControlAssociations(ListStandardsControlAssociationsPublisher.this.firstRequest);
            }
            return ListStandardsControlAssociationsPublisher.this.client.listStandardsControlAssociations((ListStandardsControlAssociationsRequest)((Object)ListStandardsControlAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

