/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse;
import software.amazon.awssdk.services.securityhub.model.Product;

public class DescribeProductsIterable
implements SdkIterable<DescribeProductsResponse> {
    private final SecurityHubClient client;
    private final DescribeProductsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeProductsIterable(SecurityHubClient client, DescribeProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeProductsResponseFetcher();
    }

    public Iterator<DescribeProductsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Product> products() {
        Function<DescribeProductsResponse, Iterator> getIterator = response -> {
            if (response != null && response.products() != null) {
                return response.products().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeProductsResponseFetcher
    implements SyncPageFetcher<DescribeProductsResponse> {
        private DescribeProductsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeProductsResponse nextPage(DescribeProductsResponse previousPage) {
            if (previousPage == null) {
                return DescribeProductsIterable.this.client.describeProducts(DescribeProductsIterable.this.firstRequest);
            }
            return DescribeProductsIterable.this.client.describeProducts((DescribeProductsRequest)((Object)DescribeProductsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

