/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cvss
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cvss> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Cvss.getter(Cvss::version)).setter(Cvss.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Double> BASE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BaseScore").getter(Cvss.getter(Cvss::baseScore)).setter(Cvss.setter(Builder::baseScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseScore").build()}).build();
    private static final SdkField<String> BASE_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseVector").getter(Cvss.getter(Cvss::baseVector)).setter(Cvss.setter(Builder::baseVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseVector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, BASE_SCORE_FIELD, BASE_VECTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String version;
    private final Double baseScore;
    private final String baseVector;

    private Cvss(BuilderImpl builder) {
        this.version = builder.version;
        this.baseScore = builder.baseScore;
        this.baseVector = builder.baseVector;
    }

    public final String version() {
        return this.version;
    }

    public final Double baseScore() {
        return this.baseScore;
    }

    public final String baseVector() {
        return this.baseVector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseVector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cvss)) {
            return false;
        }
        Cvss other = (Cvss)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.baseScore(), other.baseScore()) && Objects.equals(this.baseVector(), other.baseVector());
    }

    public final String toString() {
        return ToString.builder((String)"Cvss").add("Version", (Object)this.version()).add("BaseScore", (Object)this.baseScore()).add("BaseVector", (Object)this.baseVector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "BaseScore": {
                return Optional.ofNullable(clazz.cast(this.baseScore()));
            }
            case "BaseVector": {
                return Optional.ofNullable(clazz.cast(this.baseVector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cvss, T> g) {
        return obj -> g.apply((Cvss)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private Double baseScore;
        private String baseVector;

        private BuilderImpl() {
        }

        private BuilderImpl(Cvss model) {
            this.version(model.version);
            this.baseScore(model.baseScore);
            this.baseVector(model.baseVector);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Double getBaseScore() {
            return this.baseScore;
        }

        public final void setBaseScore(Double baseScore) {
            this.baseScore = baseScore;
        }

        @Override
        @Transient
        public final Builder baseScore(Double baseScore) {
            this.baseScore = baseScore;
            return this;
        }

        public final String getBaseVector() {
            return this.baseVector;
        }

        public final void setBaseVector(String baseVector) {
            this.baseVector = baseVector;
        }

        @Override
        @Transient
        public final Builder baseVector(String baseVector) {
            this.baseVector = baseVector;
            return this;
        }

        public Cvss build() {
            return new Cvss(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cvss> {
        public Builder version(String var1);

        public Builder baseScore(Double var1);

        public Builder baseVector(String var1);
    }
}

