/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterClusterSettingsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterClusterSettingsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyListCopier;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsClusterDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsClusterDetails> {
    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityProviders").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::capacityProviders)).setter(AwsEcsClusterDetails.setter(Builder::capacityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEcsClusterClusterSettingsDetails>> CLUSTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSettings").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::clusterSettings)).setter(AwsEcsClusterDetails.setter(Builder::clusterSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsClusterClusterSettingsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsEcsClusterConfigurationDetails> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::configuration)).setter(AwsEcsClusterDetails.setter(Builder::configuration)).constructor(AwsEcsClusterConfigurationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>> DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultCapacityProviderStrategy").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::defaultCapacityProviderStrategy)).setter(AwsEcsClusterDetails.setter(Builder::defaultCapacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCapacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsClusterDefaultCapacityProviderStrategyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDERS_FIELD, CLUSTER_SETTINGS_FIELD, CONFIGURATION_FIELD, DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> capacityProviders;
    private final List<AwsEcsClusterClusterSettingsDetails> clusterSettings;
    private final AwsEcsClusterConfigurationDetails configuration;
    private final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy;

    private AwsEcsClusterDetails(BuilderImpl builder) {
        this.capacityProviders = builder.capacityProviders;
        this.clusterSettings = builder.clusterSettings;
        this.configuration = builder.configuration;
        this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
    }

    public final boolean hasCapacityProviders() {
        return this.capacityProviders != null && !(this.capacityProviders instanceof SdkAutoConstructList);
    }

    public final List<String> capacityProviders() {
        return this.capacityProviders;
    }

    public final boolean hasClusterSettings() {
        return this.clusterSettings != null && !(this.clusterSettings instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsClusterClusterSettingsDetails> clusterSettings() {
        return this.clusterSettings;
    }

    public final AwsEcsClusterConfigurationDetails configuration() {
        return this.configuration;
    }

    public final boolean hasDefaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy != null && !(this.defaultCapacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviders() ? this.capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterSettings() ? this.clusterSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultCapacityProviderStrategy() ? this.defaultCapacityProviderStrategy() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsClusterDetails)) {
            return false;
        }
        AwsEcsClusterDetails other = (AwsEcsClusterDetails)obj;
        return this.hasCapacityProviders() == other.hasCapacityProviders() && Objects.equals(this.capacityProviders(), other.capacityProviders()) && this.hasClusterSettings() == other.hasClusterSettings() && Objects.equals(this.clusterSettings(), other.clusterSettings()) && Objects.equals(this.configuration(), other.configuration()) && this.hasDefaultCapacityProviderStrategy() == other.hasDefaultCapacityProviderStrategy() && Objects.equals(this.defaultCapacityProviderStrategy(), other.defaultCapacityProviderStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsClusterDetails").add("CapacityProviders", this.hasCapacityProviders() ? this.capacityProviders() : null).add("ClusterSettings", this.hasClusterSettings() ? this.clusterSettings() : null).add("Configuration", (Object)this.configuration()).add("DefaultCapacityProviderStrategy", this.hasDefaultCapacityProviderStrategy() ? this.defaultCapacityProviderStrategy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityProviders": {
                return Optional.ofNullable(clazz.cast(this.capacityProviders()));
            }
            case "ClusterSettings": {
                return Optional.ofNullable(clazz.cast(this.clusterSettings()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "DefaultCapacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.defaultCapacityProviderStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsClusterDetails, T> g) {
        return obj -> g.apply((AwsEcsClusterDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEcsClusterClusterSettingsDetails> clusterSettings = DefaultSdkAutoConstructList.getInstance();
        private AwsEcsClusterConfigurationDetails configuration;
        private List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsClusterDetails model) {
            this.capacityProviders(model.capacityProviders);
            this.clusterSettings(model.clusterSettings);
            this.configuration(model.configuration);
            this.defaultCapacityProviderStrategy(model.defaultCapacityProviderStrategy);
        }

        public final Collection<String> getCapacityProviders() {
            if (this.capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityProviders;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = NonEmptyStringListCopier.copy(capacityProviders);
        }

        @Override
        @Transient
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = NonEmptyStringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder capacityProviders(String ... capacityProviders) {
            this.capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final List<AwsEcsClusterClusterSettingsDetails.Builder> getClusterSettings() {
            List<AwsEcsClusterClusterSettingsDetails.Builder> result = AwsEcsClusterClusterSettingsListCopier.copyToBuilder(this.clusterSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSettings(Collection<AwsEcsClusterClusterSettingsDetails.BuilderImpl> clusterSettings) {
            this.clusterSettings = AwsEcsClusterClusterSettingsListCopier.copyFromBuilder(clusterSettings);
        }

        @Override
        @Transient
        public final Builder clusterSettings(Collection<AwsEcsClusterClusterSettingsDetails> clusterSettings) {
            this.clusterSettings = AwsEcsClusterClusterSettingsListCopier.copy(clusterSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterSettings(AwsEcsClusterClusterSettingsDetails ... clusterSettings) {
            this.clusterSettings(Arrays.asList(clusterSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterSettings(Consumer<AwsEcsClusterClusterSettingsDetails.Builder> ... clusterSettings) {
            this.clusterSettings(Stream.of(clusterSettings).map(c -> (AwsEcsClusterClusterSettingsDetails)((AwsEcsClusterClusterSettingsDetails.Builder)AwsEcsClusterClusterSettingsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsEcsClusterConfigurationDetails.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AwsEcsClusterConfigurationDetails.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(AwsEcsClusterConfigurationDetails configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> getDefaultCapacityProviderStrategy() {
            List<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> result = AwsEcsClusterDefaultCapacityProviderStrategyListCopier.copyToBuilder(this.defaultCapacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultCapacityProviderStrategy(Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails.BuilderImpl> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = AwsEcsClusterDefaultCapacityProviderStrategyListCopier.copyFromBuilder(defaultCapacityProviderStrategy);
        }

        @Override
        @Transient
        public final Builder defaultCapacityProviderStrategy(Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = AwsEcsClusterDefaultCapacityProviderStrategyListCopier.copy(defaultCapacityProviderStrategy);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(AwsEcsClusterDefaultCapacityProviderStrategyDetails ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Arrays.asList(defaultCapacityProviderStrategy));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(Consumer<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Stream.of(defaultCapacityProviderStrategy).map(c -> (AwsEcsClusterDefaultCapacityProviderStrategyDetails)((AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder)AwsEcsClusterDefaultCapacityProviderStrategyDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsEcsClusterDetails build() {
            return new AwsEcsClusterDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsClusterDetails> {
        public Builder capacityProviders(Collection<String> var1);

        public Builder capacityProviders(String ... var1);

        public Builder clusterSettings(Collection<AwsEcsClusterClusterSettingsDetails> var1);

        public Builder clusterSettings(AwsEcsClusterClusterSettingsDetails ... var1);

        public Builder clusterSettings(Consumer<AwsEcsClusterClusterSettingsDetails.Builder> ... var1);

        public Builder configuration(AwsEcsClusterConfigurationDetails var1);

        default public Builder configuration(Consumer<AwsEcsClusterConfigurationDetails.Builder> configuration) {
            return this.configuration((AwsEcsClusterConfigurationDetails)((AwsEcsClusterConfigurationDetails.Builder)AwsEcsClusterConfigurationDetails.builder().applyMutation(configuration)).build());
        }

        public Builder defaultCapacityProviderStrategy(Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails> var1);

        public Builder defaultCapacityProviderStrategy(AwsEcsClusterDefaultCapacityProviderStrategyDetails ... var1);

        public Builder defaultCapacityProviderStrategy(Consumer<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> ... var1);
    }
}

