/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpRange;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpRangeListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpv6Range;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpv6RangeListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupPrefixListId;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupPrefixListIdListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPairListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2SecurityGroupIpPermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2SecurityGroupIpPermission> {
    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpProtocol").getter(AwsEc2SecurityGroupIpPermission.getter(AwsEc2SecurityGroupIpPermission::ipProtocol)).setter(AwsEc2SecurityGroupIpPermission.setter(Builder::ipProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol").build()}).build();
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FromPort").getter(AwsEc2SecurityGroupIpPermission.getter(AwsEc2SecurityGroupIpPermission::fromPort)).setter(AwsEc2SecurityGroupIpPermission.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").build()}).build();
    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ToPort").getter(AwsEc2SecurityGroupIpPermission.getter(AwsEc2SecurityGroupIpPermission::toPort)).setter(AwsEc2SecurityGroupIpPermission.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").build()}).build();
    private static final SdkField<List<AwsEc2SecurityGroupUserIdGroupPair>> USER_ID_GROUP_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIdGroupPairs").getter(AwsEc2SecurityGroupIpPermission.getter(AwsEc2SecurityGroupIpPermission::userIdGroupPairs)).setter(AwsEc2SecurityGroupIpPermission.setter(Builder::userIdGroupPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdGroupPairs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2SecurityGroupUserIdGroupPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEc2SecurityGroupIpRange>> IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpRanges").getter(AwsEc2SecurityGroupIpPermission.getter(AwsEc2SecurityGroupIpPermission::ipRanges)).setter(AwsEc2SecurityGroupIpPermission.setter(Builder::ipRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2SecurityGroupIpRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEc2SecurityGroupIpv6Range>> IPV6_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Ranges").getter(AwsEc2SecurityGroupIpPermission.getter(AwsEc2SecurityGroupIpPermission::ipv6Ranges)).setter(AwsEc2SecurityGroupIpPermission.setter(Builder::ipv6Ranges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Ranges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2SecurityGroupIpv6Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEc2SecurityGroupPrefixListId>> PREFIX_LIST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrefixListIds").getter(AwsEc2SecurityGroupIpPermission.getter(AwsEc2SecurityGroupIpPermission::prefixListIds)).setter(AwsEc2SecurityGroupIpPermission.setter(Builder::prefixListIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2SecurityGroupPrefixListId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_PROTOCOL_FIELD, FROM_PORT_FIELD, TO_PORT_FIELD, USER_ID_GROUP_PAIRS_FIELD, IP_RANGES_FIELD, IPV6_RANGES_FIELD, PREFIX_LIST_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipProtocol;
    private final Integer fromPort;
    private final Integer toPort;
    private final List<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs;
    private final List<AwsEc2SecurityGroupIpRange> ipRanges;
    private final List<AwsEc2SecurityGroupIpv6Range> ipv6Ranges;
    private final List<AwsEc2SecurityGroupPrefixListId> prefixListIds;

    private AwsEc2SecurityGroupIpPermission(BuilderImpl builder) {
        this.ipProtocol = builder.ipProtocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
        this.ipRanges = builder.ipRanges;
        this.ipv6Ranges = builder.ipv6Ranges;
        this.prefixListIds = builder.prefixListIds;
    }

    public final String ipProtocol() {
        return this.ipProtocol;
    }

    public final Integer fromPort() {
        return this.fromPort;
    }

    public final Integer toPort() {
        return this.toPort;
    }

    public final boolean hasUserIdGroupPairs() {
        return this.userIdGroupPairs != null && !(this.userIdGroupPairs instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs() {
        return this.userIdGroupPairs;
    }

    public final boolean hasIpRanges() {
        return this.ipRanges != null && !(this.ipRanges instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2SecurityGroupIpRange> ipRanges() {
        return this.ipRanges;
    }

    public final boolean hasIpv6Ranges() {
        return this.ipv6Ranges != null && !(this.ipv6Ranges instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2SecurityGroupIpv6Range> ipv6Ranges() {
        return this.ipv6Ranges;
    }

    public final boolean hasPrefixListIds() {
        return this.prefixListIds != null && !(this.prefixListIds instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2SecurityGroupPrefixListId> prefixListIds() {
        return this.prefixListIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIdGroupPairs() ? this.userIdGroupPairs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRanges() ? this.ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Ranges() ? this.ipv6Ranges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrefixListIds() ? this.prefixListIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2SecurityGroupIpPermission)) {
            return false;
        }
        AwsEc2SecurityGroupIpPermission other = (AwsEc2SecurityGroupIpPermission)obj;
        return Objects.equals(this.ipProtocol(), other.ipProtocol()) && Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.toPort(), other.toPort()) && this.hasUserIdGroupPairs() == other.hasUserIdGroupPairs() && Objects.equals(this.userIdGroupPairs(), other.userIdGroupPairs()) && this.hasIpRanges() == other.hasIpRanges() && Objects.equals(this.ipRanges(), other.ipRanges()) && this.hasIpv6Ranges() == other.hasIpv6Ranges() && Objects.equals(this.ipv6Ranges(), other.ipv6Ranges()) && this.hasPrefixListIds() == other.hasPrefixListIds() && Objects.equals(this.prefixListIds(), other.prefixListIds());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2SecurityGroupIpPermission").add("IpProtocol", (Object)this.ipProtocol()).add("FromPort", (Object)this.fromPort()).add("ToPort", (Object)this.toPort()).add("UserIdGroupPairs", this.hasUserIdGroupPairs() ? this.userIdGroupPairs() : null).add("IpRanges", this.hasIpRanges() ? this.ipRanges() : null).add("Ipv6Ranges", this.hasIpv6Ranges() ? this.ipv6Ranges() : null).add("PrefixListIds", this.hasPrefixListIds() ? this.prefixListIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpProtocol": {
                return Optional.ofNullable(clazz.cast(this.ipProtocol()));
            }
            case "FromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "ToPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "UserIdGroupPairs": {
                return Optional.ofNullable(clazz.cast(this.userIdGroupPairs()));
            }
            case "IpRanges": {
                return Optional.ofNullable(clazz.cast(this.ipRanges()));
            }
            case "Ipv6Ranges": {
                return Optional.ofNullable(clazz.cast(this.ipv6Ranges()));
            }
            case "PrefixListIds": {
                return Optional.ofNullable(clazz.cast(this.prefixListIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2SecurityGroupIpPermission, T> g) {
        return obj -> g.apply((AwsEc2SecurityGroupIpPermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipProtocol;
        private Integer fromPort;
        private Integer toPort;
        private List<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEc2SecurityGroupIpRange> ipRanges = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEc2SecurityGroupIpv6Range> ipv6Ranges = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEc2SecurityGroupPrefixListId> prefixListIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2SecurityGroupIpPermission model) {
            this.ipProtocol(model.ipProtocol);
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
            this.userIdGroupPairs(model.userIdGroupPairs);
            this.ipRanges(model.ipRanges);
            this.ipv6Ranges(model.ipv6Ranges);
            this.prefixListIds(model.prefixListIds);
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<AwsEc2SecurityGroupUserIdGroupPair.Builder> getUserIdGroupPairs() {
            if (this.userIdGroupPairs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIdGroupPairs != null ? (Collection)this.userIdGroupPairs.stream().map(AwsEc2SecurityGroupUserIdGroupPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = AwsEc2SecurityGroupUserIdGroupPairListCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(AwsEc2SecurityGroupUserIdGroupPair ... userIdGroupPairs) {
            this.userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(Consumer<AwsEc2SecurityGroupUserIdGroupPair.Builder> ... userIdGroupPairs) {
            this.userIdGroupPairs(Stream.of(userIdGroupPairs).map(c -> (AwsEc2SecurityGroupUserIdGroupPair)((AwsEc2SecurityGroupUserIdGroupPair.Builder)AwsEc2SecurityGroupUserIdGroupPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<AwsEc2SecurityGroupUserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = AwsEc2SecurityGroupUserIdGroupPairListCopier.copyFromBuilder(userIdGroupPairs);
        }

        public final Collection<AwsEc2SecurityGroupIpRange.Builder> getIpRanges() {
            if (this.ipRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipRanges != null ? (Collection)this.ipRanges.stream().map(AwsEc2SecurityGroupIpRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipRanges(Collection<AwsEc2SecurityGroupIpRange> ipRanges) {
            this.ipRanges = AwsEc2SecurityGroupIpRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(AwsEc2SecurityGroupIpRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(Consumer<AwsEc2SecurityGroupIpRange.Builder> ... ipRanges) {
            this.ipRanges(Stream.of(ipRanges).map(c -> (AwsEc2SecurityGroupIpRange)((AwsEc2SecurityGroupIpRange.Builder)AwsEc2SecurityGroupIpRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpRanges(Collection<AwsEc2SecurityGroupIpRange.BuilderImpl> ipRanges) {
            this.ipRanges = AwsEc2SecurityGroupIpRangeListCopier.copyFromBuilder(ipRanges);
        }

        public final Collection<AwsEc2SecurityGroupIpv6Range.Builder> getIpv6Ranges() {
            if (this.ipv6Ranges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Ranges != null ? (Collection)this.ipv6Ranges.stream().map(AwsEc2SecurityGroupIpv6Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Ranges(Collection<AwsEc2SecurityGroupIpv6Range> ipv6Ranges) {
            this.ipv6Ranges = AwsEc2SecurityGroupIpv6RangeListCopier.copy(ipv6Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(AwsEc2SecurityGroupIpv6Range ... ipv6Ranges) {
            this.ipv6Ranges(Arrays.asList(ipv6Ranges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Consumer<AwsEc2SecurityGroupIpv6Range.Builder> ... ipv6Ranges) {
            this.ipv6Ranges(Stream.of(ipv6Ranges).map(c -> (AwsEc2SecurityGroupIpv6Range)((AwsEc2SecurityGroupIpv6Range.Builder)AwsEc2SecurityGroupIpv6Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Ranges(Collection<AwsEc2SecurityGroupIpv6Range.BuilderImpl> ipv6Ranges) {
            this.ipv6Ranges = AwsEc2SecurityGroupIpv6RangeListCopier.copyFromBuilder(ipv6Ranges);
        }

        public final Collection<AwsEc2SecurityGroupPrefixListId.Builder> getPrefixListIds() {
            if (this.prefixListIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.prefixListIds != null ? (Collection)this.prefixListIds.stream().map(AwsEc2SecurityGroupPrefixListId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder prefixListIds(Collection<AwsEc2SecurityGroupPrefixListId> prefixListIds) {
            this.prefixListIds = AwsEc2SecurityGroupPrefixListIdListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(AwsEc2SecurityGroupPrefixListId ... prefixListIds) {
            this.prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(Consumer<AwsEc2SecurityGroupPrefixListId.Builder> ... prefixListIds) {
            this.prefixListIds(Stream.of(prefixListIds).map(c -> (AwsEc2SecurityGroupPrefixListId)((AwsEc2SecurityGroupPrefixListId.Builder)AwsEc2SecurityGroupPrefixListId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrefixListIds(Collection<AwsEc2SecurityGroupPrefixListId.BuilderImpl> prefixListIds) {
            this.prefixListIds = AwsEc2SecurityGroupPrefixListIdListCopier.copyFromBuilder(prefixListIds);
        }

        public AwsEc2SecurityGroupIpPermission build() {
            return new AwsEc2SecurityGroupIpPermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2SecurityGroupIpPermission> {
        public Builder ipProtocol(String var1);

        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder userIdGroupPairs(Collection<AwsEc2SecurityGroupUserIdGroupPair> var1);

        public Builder userIdGroupPairs(AwsEc2SecurityGroupUserIdGroupPair ... var1);

        public Builder userIdGroupPairs(Consumer<AwsEc2SecurityGroupUserIdGroupPair.Builder> ... var1);

        public Builder ipRanges(Collection<AwsEc2SecurityGroupIpRange> var1);

        public Builder ipRanges(AwsEc2SecurityGroupIpRange ... var1);

        public Builder ipRanges(Consumer<AwsEc2SecurityGroupIpRange.Builder> ... var1);

        public Builder ipv6Ranges(Collection<AwsEc2SecurityGroupIpv6Range> var1);

        public Builder ipv6Ranges(AwsEc2SecurityGroupIpv6Range ... var1);

        public Builder ipv6Ranges(Consumer<AwsEc2SecurityGroupIpv6Range.Builder> ... var1);

        public Builder prefixListIds(Collection<AwsEc2SecurityGroupPrefixListId> var1);

        public Builder prefixListIds(AwsEc2SecurityGroupPrefixListId ... var1);

        public Builder prefixListIds(Consumer<AwsEc2SecurityGroupPrefixListId.Builder> ... var1);
    }
}

