/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription;
import software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsSnsTopicDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsSnsTopicDetails> {
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsMasterKeyId").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::kmsMasterKeyId)).setter(AwsSnsTopicDetails.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsMasterKeyId").build()}).build();
    private static final SdkField<List<AwsSnsTopicSubscription>> SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscription").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::subscription)).setter(AwsSnsTopicDetails.setter(Builder::subscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscription").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsSnsTopicSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::topicName)).setter(AwsSnsTopicDetails.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::owner)).setter(AwsSnsTopicDetails.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_MASTER_KEY_ID_FIELD, SUBSCRIPTION_FIELD, TOPIC_NAME_FIELD, OWNER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsMasterKeyId;
    private final List<AwsSnsTopicSubscription> subscription;
    private final String topicName;
    private final String owner;

    private AwsSnsTopicDetails(BuilderImpl builder) {
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.subscription = builder.subscription;
        this.topicName = builder.topicName;
        this.owner = builder.owner;
    }

    public String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public boolean hasSubscription() {
        return this.subscription != null && !(this.subscription instanceof SdkAutoConstructList);
    }

    public List<AwsSnsTopicSubscription> subscription() {
        return this.subscription;
    }

    public String topicName() {
        return this.topicName;
    }

    public String owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscription());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSnsTopicDetails)) {
            return false;
        }
        AwsSnsTopicDetails other = (AwsSnsTopicDetails)obj;
        return Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId()) && Objects.equals(this.subscription(), other.subscription()) && Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.owner(), other.owner());
    }

    public String toString() {
        return ToString.builder((String)"AwsSnsTopicDetails").add("KmsMasterKeyId", (Object)this.kmsMasterKeyId()).add("Subscription", this.subscription()).add("TopicName", (Object)this.topicName()).add("Owner", (Object)this.owner()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
            case "Subscription": {
                return Optional.ofNullable(clazz.cast(this.subscription()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSnsTopicDetails, T> g) {
        return obj -> g.apply((AwsSnsTopicDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsMasterKeyId;
        private List<AwsSnsTopicSubscription> subscription = DefaultSdkAutoConstructList.getInstance();
        private String topicName;
        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSnsTopicDetails model) {
            this.kmsMasterKeyId(model.kmsMasterKeyId);
            this.subscription(model.subscription);
            this.topicName(model.topicName);
            this.owner(model.owner);
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public final Collection<AwsSnsTopicSubscription.Builder> getSubscription() {
            return this.subscription != null ? (Collection)this.subscription.stream().map(AwsSnsTopicSubscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscription(Collection<AwsSnsTopicSubscription> subscription) {
            this.subscription = AwsSnsTopicSubscriptionListCopier.copy(subscription);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscription(AwsSnsTopicSubscription ... subscription) {
            this.subscription(Arrays.asList(subscription));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscription(Consumer<AwsSnsTopicSubscription.Builder> ... subscription) {
            this.subscription(Stream.of(subscription).map(c -> (AwsSnsTopicSubscription)((AwsSnsTopicSubscription.Builder)AwsSnsTopicSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscription(Collection<AwsSnsTopicSubscription.BuilderImpl> subscription) {
            this.subscription = AwsSnsTopicSubscriptionListCopier.copyFromBuilder(subscription);
        }

        public final String getTopicName() {
            return this.topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public AwsSnsTopicDetails build() {
            return new AwsSnsTopicDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsSnsTopicDetails> {
        public Builder kmsMasterKeyId(String var1);

        public Builder subscription(Collection<AwsSnsTopicSubscription> var1);

        public Builder subscription(AwsSnsTopicSubscription ... var1);

        public Builder subscription(Consumer<AwsSnsTopicSubscription.Builder> ... var1);

        public Builder topicName(String var1);

        public Builder owner(String var1);
    }
}

