/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StandardsStatus {
    PENDING("PENDING"),
    READY("READY"),
    FAILED("FAILED"),
    DELETING("DELETING"),
    INCOMPLETE("INCOMPLETE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StandardsStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StandardsStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StandardsStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StandardsStatus> knownValues() {
        return Stream.of(StandardsStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

