/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class StatusReasonsListCopier {
    static List<StatusReason> copy(Collection<StatusReason> statusReasonsListParam) {
        if (statusReasonsListParam == null || statusReasonsListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<StatusReason> statusReasonsListParamCopy = new ArrayList<>(statusReasonsListParam);
        return Collections.unmodifiableList(statusReasonsListParamCopy);
    }

    static List<StatusReason> copyFromBuilder(Collection<? extends StatusReason.Builder> statusReasonsListParam) {
        if (statusReasonsListParam == null) {
            return null;
        }
        return copy(statusReasonsListParam.stream().map(StatusReason.Builder::build).collect(toList()));
    }
}
