/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a Security Hub insight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Insight implements SdkPojo, Serializable, ToCopyableBuilder<Insight.Builder, Insight> {
    private static final SdkField<String> INSIGHT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Insight::insightArn)).setter(setter(Builder::insightArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Insight::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsSecurityFindingFilters> FILTERS_FIELD = SdkField
            .<AwsSecurityFindingFilters> builder(MarshallingType.SDK_POJO).getter(getter(Insight::filters))
            .setter(setter(Builder::filters)).constructor(AwsSecurityFindingFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> GROUP_BY_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Insight::groupByAttribute)).setter(setter(Builder::groupByAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ARN_FIELD, NAME_FIELD,
            FILTERS_FIELD, GROUP_BY_ATTRIBUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String insightArn;

    private final String name;

    private final AwsSecurityFindingFilters filters;

    private final String groupByAttribute;

    private Insight(BuilderImpl builder) {
        this.insightArn = builder.insightArn;
        this.name = builder.name;
        this.filters = builder.filters;
        this.groupByAttribute = builder.groupByAttribute;
    }

    /**
     * <p>
     * The ARN of a Security Hub insight.
     * </p>
     * 
     * @return The ARN of a Security Hub insight.
     */
    public String insightArn() {
        return insightArn;
    }

    /**
     * <p>
     * The name of a Security Hub insight.
     * </p>
     * 
     * @return The name of a Security Hub insight.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * One or more attributes used to filter the findings included in the insight. The insight only includes findings
     * that match the criteria defined in the filters.
     * </p>
     * 
     * @return One or more attributes used to filter the findings included in the insight. The insight only includes
     *         findings that match the criteria defined in the filters.
     */
    public AwsSecurityFindingFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The grouping attribute for the insight's findings. Indicates how to group the matching findings, and identifies
     * the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then
     * the insight produces a list of resource identifiers.
     * </p>
     * 
     * @return The grouping attribute for the insight's findings. Indicates how to group the matching findings, and
     *         identifies the type of item that the insight applies to. For example, if an insight is grouped by
     *         resource identifier, then the insight produces a list of resource identifiers.
     */
    public String groupByAttribute() {
        return groupByAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insightArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupByAttribute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Insight)) {
            return false;
        }
        Insight other = (Insight) obj;
        return Objects.equals(insightArn(), other.insightArn()) && Objects.equals(name(), other.name())
                && Objects.equals(filters(), other.filters()) && Objects.equals(groupByAttribute(), other.groupByAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Insight").add("InsightArn", insightArn()).add("Name", name()).add("Filters", filters())
                .add("GroupByAttribute", groupByAttribute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightArn":
            return Optional.ofNullable(clazz.cast(insightArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "GroupByAttribute":
            return Optional.ofNullable(clazz.cast(groupByAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Insight, T> g) {
        return obj -> g.apply((Insight) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Insight> {
        /**
         * <p>
         * The ARN of a Security Hub insight.
         * </p>
         * 
         * @param insightArn
         *        The ARN of a Security Hub insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightArn(String insightArn);

        /**
         * <p>
         * The name of a Security Hub insight.
         * </p>
         * 
         * @param name
         *        The name of a Security Hub insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * One or more attributes used to filter the findings included in the insight. The insight only includes
         * findings that match the criteria defined in the filters.
         * </p>
         * 
         * @param filters
         *        One or more attributes used to filter the findings included in the insight. The insight only includes
         *        findings that match the criteria defined in the filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AwsSecurityFindingFilters filters);

        /**
         * <p>
         * One or more attributes used to filter the findings included in the insight. The insight only includes
         * findings that match the criteria defined in the filters.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSecurityFindingFilters.Builder} avoiding the
         * need to create one manually via {@link AwsSecurityFindingFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSecurityFindingFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(AwsSecurityFindingFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link AwsSecurityFindingFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(AwsSecurityFindingFilters)
         */
        default Builder filters(Consumer<AwsSecurityFindingFilters.Builder> filters) {
            return filters(AwsSecurityFindingFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The grouping attribute for the insight's findings. Indicates how to group the matching findings, and
         * identifies the type of item that the insight applies to. For example, if an insight is grouped by resource
         * identifier, then the insight produces a list of resource identifiers.
         * </p>
         * 
         * @param groupByAttribute
         *        The grouping attribute for the insight's findings. Indicates how to group the matching findings, and
         *        identifies the type of item that the insight applies to. For example, if an insight is grouped by
         *        resource identifier, then the insight produces a list of resource identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByAttribute(String groupByAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String insightArn;

        private String name;

        private AwsSecurityFindingFilters filters;

        private String groupByAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(Insight model) {
            insightArn(model.insightArn);
            name(model.name);
            filters(model.filters);
            groupByAttribute(model.groupByAttribute);
        }

        public final String getInsightArn() {
            return insightArn;
        }

        @Override
        public final Builder insightArn(String insightArn) {
            this.insightArn = insightArn;
            return this;
        }

        public final void setInsightArn(String insightArn) {
            this.insightArn = insightArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final AwsSecurityFindingFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(AwsSecurityFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(AwsSecurityFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final String getGroupByAttribute() {
            return groupByAttribute;
        }

        @Override
        public final Builder groupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
            return this;
        }

        public final void setGroupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
        }

        @Override
        public Insight build() {
            return new Insight(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
