/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<GetInsightsRequest.Builder, GetInsightsRequest> {
    private static final SdkField<List<String>> INSIGHT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetInsightsRequest::insightArns))
            .setter(setter(Builder::insightArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetInsightsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetInsightsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ARNS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> insightArns;

    private final String nextToken;

    private final Integer maxResults;

    private GetInsightsRequest(BuilderImpl builder) {
        super(builder);
        this.insightArns = builder.insightArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the InsightArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInsightArns() {
        return insightArns != null && !(insightArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the insights to describe. If you do not provide any insight ARNs, then <code>GetInsights</code>
     * returns all of your custom insights. It does not return any managed insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInsightArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARNs of the insights to describe. If you do not provide any insight ARNs, then
     *         <code>GetInsights</code> returns all of your custom insights. It does not return any managed insights.
     */
    public List<String> insightArns() {
        return insightArns;
    }

    /**
     * <p>
     * The token that is required for pagination. On your first call to the <code>GetInsights</code> operation, set the
     * value of this parameter to <code>NULL</code>.
     * </p>
     * <p>
     * For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value
     * returned from the previous response.
     * </p>
     * 
     * @return The token that is required for pagination. On your first call to the <code>GetInsights</code> operation,
     *         set the value of this parameter to <code>NULL</code>.</p>
     *         <p>
     *         For subsequent calls to the operation, to continue listing data, set the value of this parameter to the
     *         value returned from the previous response.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return in the response.
     * </p>
     * 
     * @return The maximum number of items to return in the response.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightArns());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightsRequest)) {
            return false;
        }
        GetInsightsRequest other = (GetInsightsRequest) obj;
        return Objects.equals(insightArns(), other.insightArns()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetInsightsRequest").add("InsightArns", insightArns()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightArns":
            return Optional.ofNullable(clazz.cast(insightArns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightsRequest, T> g) {
        return obj -> g.apply((GetInsightsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightsRequest> {
        /**
         * <p>
         * The ARNs of the insights to describe. If you do not provide any insight ARNs, then <code>GetInsights</code>
         * returns all of your custom insights. It does not return any managed insights.
         * </p>
         * 
         * @param insightArns
         *        The ARNs of the insights to describe. If you do not provide any insight ARNs, then
         *        <code>GetInsights</code> returns all of your custom insights. It does not return any managed insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightArns(Collection<String> insightArns);

        /**
         * <p>
         * The ARNs of the insights to describe. If you do not provide any insight ARNs, then <code>GetInsights</code>
         * returns all of your custom insights. It does not return any managed insights.
         * </p>
         * 
         * @param insightArns
         *        The ARNs of the insights to describe. If you do not provide any insight ARNs, then
         *        <code>GetInsights</code> returns all of your custom insights. It does not return any managed insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightArns(String... insightArns);

        /**
         * <p>
         * The token that is required for pagination. On your first call to the <code>GetInsights</code> operation, set
         * the value of this parameter to <code>NULL</code>.
         * </p>
         * <p>
         * For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value
         * returned from the previous response.
         * </p>
         * 
         * @param nextToken
         *        The token that is required for pagination. On your first call to the <code>GetInsights</code>
         *        operation, set the value of this parameter to <code>NULL</code>.</p>
         *        <p>
         *        For subsequent calls to the operation, to continue listing data, set the value of this parameter to
         *        the value returned from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<String> insightArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightsRequest model) {
            super(model);
            insightArns(model.insightArns);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getInsightArns() {
            return insightArns;
        }

        @Override
        public final Builder insightArns(Collection<String> insightArns) {
            this.insightArns = ArnListCopier.copy(insightArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightArns(String... insightArns) {
            insightArns(Arrays.asList(insightArns));
            return this;
        }

        public final void setInsightArns(Collection<String> insightArns) {
            this.insightArns = ArnListCopier.copy(insightArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInsightsRequest build() {
            return new GetInsightsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
