/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A date filter for querying findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateFilter implements SdkPojo, Serializable, ToCopyableBuilder<DateFilter.Builder, DateFilter> {
    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DateFilter::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DateFilter::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final SdkField<DateRange> DATE_RANGE_FIELD = SdkField.<DateRange> builder(MarshallingType.SDK_POJO)
            .getter(getter(DateFilter::dateRange)).setter(setter(Builder::dateRange)).constructor(DateRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD,
            DATE_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String start;

    private final String end;

    private final DateRange dateRange;

    private DateFilter(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.dateRange = builder.dateRange;
    }

    /**
     * <p>
     * A start date for the date filter.
     * </p>
     * 
     * @return A start date for the date filter.
     */
    public String start() {
        return start;
    }

    /**
     * <p>
     * An end date for the date filter.
     * </p>
     * 
     * @return An end date for the date filter.
     */
    public String end() {
        return end;
    }

    /**
     * <p>
     * A date range for the date filter.
     * </p>
     * 
     * @return A date range for the date filter.
     */
    public DateRange dateRange() {
        return dateRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(dateRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateFilter)) {
            return false;
        }
        DateFilter other = (DateFilter) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end())
                && Objects.equals(dateRange(), other.dateRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DateFilter").add("Start", start()).add("End", end()).add("DateRange", dateRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "DateRange":
            return Optional.ofNullable(clazz.cast(dateRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateFilter, T> g) {
        return obj -> g.apply((DateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateFilter> {
        /**
         * <p>
         * A start date for the date filter.
         * </p>
         * 
         * @param start
         *        A start date for the date filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * <p>
         * An end date for the date filter.
         * </p>
         * 
         * @param end
         *        An end date for the date filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * <p>
         * A date range for the date filter.
         * </p>
         * 
         * @param dateRange
         *        A date range for the date filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateRange(DateRange dateRange);

        /**
         * <p>
         * A date range for the date filter.
         * </p>
         * This is a convenience that creates an instance of the {@link DateRange.Builder} avoiding the need to create
         * one manually via {@link DateRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateRange.Builder#build()} is called immediately and its result
         * is passed to {@link #dateRange(DateRange)}.
         * 
         * @param dateRange
         *        a consumer that will call methods on {@link DateRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateRange(DateRange)
         */
        default Builder dateRange(Consumer<DateRange.Builder> dateRange) {
            return dateRange(DateRange.builder().applyMutation(dateRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String start;

        private String end;

        private DateRange dateRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DateFilter model) {
            start(model.start);
            end(model.end);
            dateRange(model.dateRange);
        }

        public final String getStart() {
            return start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getEnd() {
            return end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        public final DateRange.Builder getDateRange() {
            return dateRange != null ? dateRange.toBuilder() : null;
        }

        @Override
        public final Builder dateRange(DateRange dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        public final void setDateRange(DateRange.BuilderImpl dateRange) {
            this.dateRange = dateRange != null ? dateRange.build() : null;
        }

        @Override
        public DateFilter build() {
            return new DateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
