/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFindingsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<BatchUpdateFindingsRequest.Builder, BatchUpdateFindingsRequest> {
    private static final SdkField<List<AwsSecurityFindingIdentifier>> FINDING_IDENTIFIERS_FIELD = SdkField
            .<List<AwsSecurityFindingIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(BatchUpdateFindingsRequest::findingIdentifiers))
            .setter(setter(Builder::findingIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsSecurityFindingIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsSecurityFindingIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NoteUpdate> NOTE_FIELD = SdkField.<NoteUpdate> builder(MarshallingType.SDK_POJO)
            .getter(getter(BatchUpdateFindingsRequest::note)).setter(setter(Builder::note)).constructor(NoteUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()).build();

    private static final SdkField<SeverityUpdate> SEVERITY_FIELD = SdkField.<SeverityUpdate> builder(MarshallingType.SDK_POJO)
            .getter(getter(BatchUpdateFindingsRequest::severity)).setter(setter(Builder::severity))
            .constructor(SeverityUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchUpdateFindingsRequest::verificationStateAsString)).setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build()).build();

    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchUpdateFindingsRequest::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchUpdateFindingsRequest::criticality)).setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchUpdateFindingsRequest::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> USER_DEFINED_FIELDS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(BatchUpdateFindingsRequest::userDefinedFields))
            .setter(setter(Builder::userDefinedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<WorkflowUpdate> WORKFLOW_FIELD = SdkField.<WorkflowUpdate> builder(MarshallingType.SDK_POJO)
            .getter(getter(BatchUpdateFindingsRequest::workflow)).setter(setter(Builder::workflow))
            .constructor(WorkflowUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflow").build()).build();

    private static final SdkField<List<RelatedFinding>> RELATED_FINDINGS_FIELD = SdkField
            .<List<RelatedFinding>> builder(MarshallingType.LIST)
            .getter(getter(BatchUpdateFindingsRequest::relatedFindings))
            .setter(setter(Builder::relatedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelatedFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelatedFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIERS_FIELD,
            NOTE_FIELD, SEVERITY_FIELD, VERIFICATION_STATE_FIELD, CONFIDENCE_FIELD, CRITICALITY_FIELD, TYPES_FIELD,
            USER_DEFINED_FIELDS_FIELD, WORKFLOW_FIELD, RELATED_FINDINGS_FIELD));

    private final List<AwsSecurityFindingIdentifier> findingIdentifiers;

    private final NoteUpdate note;

    private final SeverityUpdate severity;

    private final String verificationState;

    private final Integer confidence;

    private final Integer criticality;

    private final List<String> types;

    private final Map<String, String> userDefinedFields;

    private final WorkflowUpdate workflow;

    private final List<RelatedFinding> relatedFindings;

    private BatchUpdateFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingIdentifiers = builder.findingIdentifiers;
        this.note = builder.note;
        this.severity = builder.severity;
        this.verificationState = builder.verificationState;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.types = builder.types;
        this.userDefinedFields = builder.userDefinedFields;
        this.workflow = builder.workflow;
        this.relatedFindings = builder.relatedFindings;
    }

    /**
     * Returns true if the FindingIdentifiers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFindingIdentifiers() {
        return findingIdentifiers != null && !(findingIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at a
     * time.
     * </p>
     * <p>
     * For each finding, the list provides the finding identifier and the ARN of the finding provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings
     *         at a time.</p>
     *         <p>
     *         For each finding, the list provides the finding identifier and the ARN of the finding provider.
     */
    public List<AwsSecurityFindingIdentifier> findingIdentifiers() {
        return findingIdentifiers;
    }

    /**
     * Returns the value of the Note property for this object.
     * 
     * @return The value of the Note property for this object.
     */
    public NoteUpdate note() {
        return note;
    }

    /**
     * <p>
     * Used to update the finding severity.
     * </p>
     * 
     * @return Used to update the finding severity.
     */
    public SeverityUpdate severity() {
        return severity;
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * <p>
     * The available values for <code>VerificationState</code> are as follows.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNKNOWN</code> – The default disposition of a security finding
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRUE_POSITIVE</code> – The security finding is confirmed
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't pose any
     * threat, is expected, or both
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return Indicates the veracity of a finding.</p>
     *         <p>
     *         The available values for <code>VerificationState</code> are as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code> – The default disposition of a security finding
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRUE_POSITIVE</code> – The security finding is confirmed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't
     *         pose any threat, is expected, or both
     *         </p>
     *         </li>
     * @see VerificationState
     */
    public VerificationState verificationState() {
        return VerificationState.fromValue(verificationState);
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * <p>
     * The available values for <code>VerificationState</code> are as follows.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNKNOWN</code> – The default disposition of a security finding
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRUE_POSITIVE</code> – The security finding is confirmed
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't pose any
     * threat, is expected, or both
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return Indicates the veracity of a finding.</p>
     *         <p>
     *         The available values for <code>VerificationState</code> are as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code> – The default disposition of a security finding
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRUE_POSITIVE</code> – The security finding is confirmed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't
     *         pose any threat, is expected, or both
     *         </p>
     *         </li>
     * @see VerificationState
     */
    public String verificationStateAsString() {
        return verificationState;
    }

    /**
     * <p>
     * The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately
     * identifies the behavior or issue that it was intended to identify.
     * </p>
     * <p>
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means
     * 100 percent confidence.
     * </p>
     * 
     * @return The updated value for the finding confidence. Confidence is defined as the likelihood that a finding
     *         accurately identifies the behavior or issue that it was intended to identify.</p>
     *         <p>
     *         Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100
     *         means 100 percent confidence.
     */
    public Integer confidence() {
        return confidence;
    }

    /**
     * <p>
     * The updated value for the level of importance assigned to the resources associated with the findings.
     * </p>
     * <p>
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most
     * critical resources.
     * </p>
     * 
     * @return The updated value for the level of importance assigned to the resources associated with the findings.</p>
     *         <p>
     *         A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for
     *         the most critical resources.
     */
    public Integer criticality() {
        return criticality;
    }

    /**
     * Returns true if the Types property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more finding types in the format of namespace/category/classifier that classify a finding.
     * </p>
     * <p>
     * Valid namespace values are as follows.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Software and Configuration Checks
     * </p>
     * </li>
     * <li>
     * <p>
     * TTPs
     * </p>
     * </li>
     * <li>
     * <p>
     * Effects
     * </p>
     * </li>
     * <li>
     * <p>
     * Unusual Behaviors
     * </p>
     * </li>
     * <li>
     * <p>
     * Sensitive Data Identifications
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more finding types in the format of namespace/category/classifier that classify a finding.</p>
     *         <p>
     *         Valid namespace values are as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Software and Configuration Checks
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TTPs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Effects
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Unusual Behaviors
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Sensitive Data Identifications
     *         </p>
     *         </li>
     */
    public List<String> types() {
        return types;
    }

    /**
     * Returns true if the UserDefinedFields property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUserDefinedFields() {
        return userDefinedFields != null && !(userDefinedFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserDefinedFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of name/value string pairs associated with the finding. These are custom, user-defined fields
     *         added to a finding.
     */
    public Map<String, String> userDefinedFields() {
        return userDefinedFields;
    }

    /**
     * <p>
     * Used to update the workflow status of a finding.
     * </p>
     * <p>
     * The workflow status indicates the progress of the investigation into the finding.
     * </p>
     * 
     * @return Used to update the workflow status of a finding.</p>
     *         <p>
     *         The workflow status indicates the progress of the investigation into the finding.
     */
    public WorkflowUpdate workflow() {
        return workflow;
    }

    /**
     * Returns true if the RelatedFindings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRelatedFindings() {
        return relatedFindings != null && !(relatedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of findings that are related to the updated findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedFindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of findings that are related to the updated findings.
     */
    public List<RelatedFinding> relatedFindings() {
        return relatedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(note());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(criticality());
        hashCode = 31 * hashCode + Objects.hashCode(types());
        hashCode = 31 * hashCode + Objects.hashCode(userDefinedFields());
        hashCode = 31 * hashCode + Objects.hashCode(workflow());
        hashCode = 31 * hashCode + Objects.hashCode(relatedFindings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsRequest)) {
            return false;
        }
        BatchUpdateFindingsRequest other = (BatchUpdateFindingsRequest) obj;
        return Objects.equals(findingIdentifiers(), other.findingIdentifiers()) && Objects.equals(note(), other.note())
                && Objects.equals(severity(), other.severity())
                && Objects.equals(verificationStateAsString(), other.verificationStateAsString())
                && Objects.equals(confidence(), other.confidence()) && Objects.equals(criticality(), other.criticality())
                && Objects.equals(types(), other.types()) && Objects.equals(userDefinedFields(), other.userDefinedFields())
                && Objects.equals(workflow(), other.workflow()) && Objects.equals(relatedFindings(), other.relatedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchUpdateFindingsRequest").add("FindingIdentifiers", findingIdentifiers()).add("Note", note())
                .add("Severity", severity()).add("VerificationState", verificationStateAsString())
                .add("Confidence", confidence()).add("Criticality", criticality()).add("Types", types())
                .add("UserDefinedFields", userDefinedFields()).add("Workflow", workflow())
                .add("RelatedFindings", relatedFindings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingIdentifiers":
            return Optional.ofNullable(clazz.cast(findingIdentifiers()));
        case "Note":
            return Optional.ofNullable(clazz.cast(note()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "VerificationState":
            return Optional.ofNullable(clazz.cast(verificationStateAsString()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Types":
            return Optional.ofNullable(clazz.cast(types()));
        case "UserDefinedFields":
            return Optional.ofNullable(clazz.cast(userDefinedFields()));
        case "Workflow":
            return Optional.ofNullable(clazz.cast(workflow()));
        case "RelatedFindings":
            return Optional.ofNullable(clazz.cast(relatedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsRequest, T> g) {
        return obj -> g.apply((BatchUpdateFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateFindingsRequest> {
        /**
         * <p>
         * The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at
         * a time.
         * </p>
         * <p>
         * For each finding, the list provides the finding identifier and the ARN of the finding provider.
         * </p>
         * 
         * @param findingIdentifiers
         *        The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100
         *        findings at a time.</p>
         *        <p>
         *        For each finding, the list provides the finding identifier and the ARN of the finding provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifiers(Collection<AwsSecurityFindingIdentifier> findingIdentifiers);

        /**
         * <p>
         * The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at
         * a time.
         * </p>
         * <p>
         * For each finding, the list provides the finding identifier and the ARN of the finding provider.
         * </p>
         * 
         * @param findingIdentifiers
         *        The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100
         *        findings at a time.</p>
         *        <p>
         *        For each finding, the list provides the finding identifier and the ARN of the finding provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifiers(AwsSecurityFindingIdentifier... findingIdentifiers);

        /**
         * <p>
         * The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at
         * a time.
         * </p>
         * <p>
         * For each finding, the list provides the finding identifier and the ARN of the finding provider.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsSecurityFindingIdentifier>.Builder}
         * avoiding the need to create one manually via {@link List<AwsSecurityFindingIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsSecurityFindingIdentifier>.Builder#build()} is called
         * immediately and its result is passed to {@link #findingIdentifiers(List<AwsSecurityFindingIdentifier>)}.
         * 
         * @param findingIdentifiers
         *        a consumer that will call methods on {@link List<AwsSecurityFindingIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingIdentifiers(List<AwsSecurityFindingIdentifier>)
         */
        Builder findingIdentifiers(Consumer<AwsSecurityFindingIdentifier.Builder>... findingIdentifiers);

        /**
         * Sets the value of the Note property for this object.
         *
         * @param note
         *        The new value for the Note property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(NoteUpdate note);

        /**
         * Sets the value of the Note property for this object.
         *
         * This is a convenience that creates an instance of the {@link NoteUpdate.Builder} avoiding the need to create
         * one manually via {@link NoteUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoteUpdate.Builder#build()} is called immediately and its result
         * is passed to {@link #note(NoteUpdate)}.
         * 
         * @param note
         *        a consumer that will call methods on {@link NoteUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #note(NoteUpdate)
         */
        default Builder note(Consumer<NoteUpdate.Builder> note) {
            return note(NoteUpdate.builder().applyMutation(note).build());
        }

        /**
         * <p>
         * Used to update the finding severity.
         * </p>
         * 
         * @param severity
         *        Used to update the finding severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(SeverityUpdate severity);

        /**
         * <p>
         * Used to update the finding severity.
         * </p>
         * This is a convenience that creates an instance of the {@link SeverityUpdate.Builder} avoiding the need to
         * create one manually via {@link SeverityUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link SeverityUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #severity(SeverityUpdate)}.
         * 
         * @param severity
         *        a consumer that will call methods on {@link SeverityUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severity(SeverityUpdate)
         */
        default Builder severity(Consumer<SeverityUpdate.Builder> severity) {
            return severity(SeverityUpdate.builder().applyMutation(severity).build());
        }

        /**
         * <p>
         * Indicates the veracity of a finding.
         * </p>
         * <p>
         * The available values for <code>VerificationState</code> are as follows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNKNOWN</code> – The default disposition of a security finding
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRUE_POSITIVE</code> – The security finding is confirmed
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't pose
         * any threat, is expected, or both
         * </p>
         * </li>
         * </ul>
         * 
         * @param verificationState
         *        Indicates the veracity of a finding.</p>
         *        <p>
         *        The available values for <code>VerificationState</code> are as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code> – The default disposition of a security finding
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRUE_POSITIVE</code> – The security finding is confirmed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't
         *        pose any threat, is expected, or both
         *        </p>
         *        </li>
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(String verificationState);

        /**
         * <p>
         * Indicates the veracity of a finding.
         * </p>
         * <p>
         * The available values for <code>VerificationState</code> are as follows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNKNOWN</code> – The default disposition of a security finding
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRUE_POSITIVE</code> – The security finding is confirmed
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't pose
         * any threat, is expected, or both
         * </p>
         * </li>
         * </ul>
         * 
         * @param verificationState
         *        Indicates the veracity of a finding.</p>
         *        <p>
         *        The available values for <code>VerificationState</code> are as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code> – The default disposition of a security finding
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRUE_POSITIVE</code> – The security finding is confirmed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't
         *        pose any threat, is expected, or both
         *        </p>
         *        </li>
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(VerificationState verificationState);

        /**
         * <p>
         * The updated value for the finding confidence. Confidence is defined as the likelihood that a finding
         * accurately identifies the behavior or issue that it was intended to identify.
         * </p>
         * <p>
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100
         * means 100 percent confidence.
         * </p>
         * 
         * @param confidence
         *        The updated value for the finding confidence. Confidence is defined as the likelihood that a finding
         *        accurately identifies the behavior or issue that it was intended to identify.</p>
         *        <p>
         *        Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and
         *        100 means 100 percent confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Integer confidence);

        /**
         * <p>
         * The updated value for the level of importance assigned to the resources associated with the findings.
         * </p>
         * <p>
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the
         * most critical resources.
         * </p>
         * 
         * @param criticality
         *        The updated value for the level of importance assigned to the resources associated with the
         *        findings.</p>
         *        <p>
         *        A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved
         *        for the most critical resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Integer criticality);

        /**
         * <p>
         * One or more finding types in the format of namespace/category/classifier that classify a finding.
         * </p>
         * <p>
         * Valid namespace values are as follows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Software and Configuration Checks
         * </p>
         * </li>
         * <li>
         * <p>
         * TTPs
         * </p>
         * </li>
         * <li>
         * <p>
         * Effects
         * </p>
         * </li>
         * <li>
         * <p>
         * Unusual Behaviors
         * </p>
         * </li>
         * <li>
         * <p>
         * Sensitive Data Identifications
         * </p>
         * </li>
         * </ul>
         * 
         * @param types
         *        One or more finding types in the format of namespace/category/classifier that classify a finding.</p>
         *        <p>
         *        Valid namespace values are as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Software and Configuration Checks
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TTPs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Effects
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unusual Behaviors
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Sensitive Data Identifications
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<String> types);

        /**
         * <p>
         * One or more finding types in the format of namespace/category/classifier that classify a finding.
         * </p>
         * <p>
         * Valid namespace values are as follows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Software and Configuration Checks
         * </p>
         * </li>
         * <li>
         * <p>
         * TTPs
         * </p>
         * </li>
         * <li>
         * <p>
         * Effects
         * </p>
         * </li>
         * <li>
         * <p>
         * Unusual Behaviors
         * </p>
         * </li>
         * <li>
         * <p>
         * Sensitive Data Identifications
         * </p>
         * </li>
         * </ul>
         * 
         * @param types
         *        One or more finding types in the format of namespace/category/classifier that classify a finding.</p>
         *        <p>
         *        Valid namespace values are as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Software and Configuration Checks
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TTPs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Effects
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unusual Behaviors
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Sensitive Data Identifications
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(String... types);

        /**
         * <p>
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to
         * a finding.
         * </p>
         * 
         * @param userDefinedFields
         *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields
         *        added to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFields(Map<String, String> userDefinedFields);

        /**
         * <p>
         * Used to update the workflow status of a finding.
         * </p>
         * <p>
         * The workflow status indicates the progress of the investigation into the finding.
         * </p>
         * 
         * @param workflow
         *        Used to update the workflow status of a finding.</p>
         *        <p>
         *        The workflow status indicates the progress of the investigation into the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflow(WorkflowUpdate workflow);

        /**
         * <p>
         * Used to update the workflow status of a finding.
         * </p>
         * <p>
         * The workflow status indicates the progress of the investigation into the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowUpdate.Builder} avoiding the need to
         * create one manually via {@link WorkflowUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #workflow(WorkflowUpdate)}.
         * 
         * @param workflow
         *        a consumer that will call methods on {@link WorkflowUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflow(WorkflowUpdate)
         */
        default Builder workflow(Consumer<WorkflowUpdate.Builder> workflow) {
            return workflow(WorkflowUpdate.builder().applyMutation(workflow).build());
        }

        /**
         * <p>
         * A list of findings that are related to the updated findings.
         * </p>
         * 
         * @param relatedFindings
         *        A list of findings that are related to the updated findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindings(Collection<RelatedFinding> relatedFindings);

        /**
         * <p>
         * A list of findings that are related to the updated findings.
         * </p>
         * 
         * @param relatedFindings
         *        A list of findings that are related to the updated findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindings(RelatedFinding... relatedFindings);

        /**
         * <p>
         * A list of findings that are related to the updated findings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RelatedFinding>.Builder} avoiding the need
         * to create one manually via {@link List<RelatedFinding>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RelatedFinding>.Builder#build()} is called immediately and
         * its result is passed to {@link #relatedFindings(List<RelatedFinding>)}.
         * 
         * @param relatedFindings
         *        a consumer that will call methods on {@link List<RelatedFinding>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindings(List<RelatedFinding>)
         */
        Builder relatedFindings(Consumer<RelatedFinding.Builder>... relatedFindings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<AwsSecurityFindingIdentifier> findingIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private NoteUpdate note;

        private SeverityUpdate severity;

        private String verificationState;

        private Integer confidence;

        private Integer criticality;

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> userDefinedFields = DefaultSdkAutoConstructMap.getInstance();

        private WorkflowUpdate workflow;

        private List<RelatedFinding> relatedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsRequest model) {
            super(model);
            findingIdentifiers(model.findingIdentifiers);
            note(model.note);
            severity(model.severity);
            verificationState(model.verificationState);
            confidence(model.confidence);
            criticality(model.criticality);
            types(model.types);
            userDefinedFields(model.userDefinedFields);
            workflow(model.workflow);
            relatedFindings(model.relatedFindings);
        }

        public final Collection<AwsSecurityFindingIdentifier.Builder> getFindingIdentifiers() {
            return findingIdentifiers != null ? findingIdentifiers.stream().map(AwsSecurityFindingIdentifier::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findingIdentifiers(Collection<AwsSecurityFindingIdentifier> findingIdentifiers) {
            this.findingIdentifiers = AwsSecurityFindingIdentifierListCopier.copy(findingIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(AwsSecurityFindingIdentifier... findingIdentifiers) {
            findingIdentifiers(Arrays.asList(findingIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(Consumer<AwsSecurityFindingIdentifier.Builder>... findingIdentifiers) {
            findingIdentifiers(Stream.of(findingIdentifiers)
                    .map(c -> AwsSecurityFindingIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindingIdentifiers(Collection<AwsSecurityFindingIdentifier.BuilderImpl> findingIdentifiers) {
            this.findingIdentifiers = AwsSecurityFindingIdentifierListCopier.copyFromBuilder(findingIdentifiers);
        }

        public final NoteUpdate.Builder getNote() {
            return note != null ? note.toBuilder() : null;
        }

        @Override
        public final Builder note(NoteUpdate note) {
            this.note = note;
            return this;
        }

        public final void setNote(NoteUpdate.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        public final SeverityUpdate.Builder getSeverity() {
            return severity != null ? severity.toBuilder() : null;
        }

        @Override
        public final Builder severity(SeverityUpdate severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(SeverityUpdate.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        public final String getVerificationState() {
            return verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        public final Integer getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        public final Integer getCriticality() {
            return criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        public final Collection<String> getTypes() {
            return types;
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final void setTypes(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
        }

        public final Map<String, String> getUserDefinedFields() {
            return userDefinedFields;
        }

        @Override
        public final Builder userDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
            return this;
        }

        public final void setUserDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
        }

        public final WorkflowUpdate.Builder getWorkflow() {
            return workflow != null ? workflow.toBuilder() : null;
        }

        @Override
        public final Builder workflow(WorkflowUpdate workflow) {
            this.workflow = workflow;
            return this;
        }

        public final void setWorkflow(WorkflowUpdate.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        public final Collection<RelatedFinding.Builder> getRelatedFindings() {
            return relatedFindings != null ? relatedFindings.stream().map(RelatedFinding::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder relatedFindings(Collection<RelatedFinding> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copy(relatedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(RelatedFinding... relatedFindings) {
            relatedFindings(Arrays.asList(relatedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(Consumer<RelatedFinding.Builder>... relatedFindings) {
            relatedFindings(Stream.of(relatedFindings).map(c -> RelatedFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedFindings(Collection<RelatedFinding.BuilderImpl> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copyFromBuilder(relatedFindings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateFindingsRequest build() {
            return new BatchUpdateFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
