/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon S3 object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3ObjectDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3ObjectDetails.Builder, AwsS3ObjectDetails> {
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsS3ObjectDetails::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsS3ObjectDetails::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsS3ObjectDetails::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsS3ObjectDetails::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> SERVER_SIDE_ENCRYPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsS3ObjectDetails::serverSideEncryption)).setter(setter(Builder::serverSideEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryption").build())
            .build();

    private static final SdkField<String> SSEKMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsS3ObjectDetails::ssekmsKeyId)).setter(setter(Builder::ssekmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEKMSKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_FIELD,
            E_TAG_FIELD, VERSION_ID_FIELD, CONTENT_TYPE_FIELD, SERVER_SIDE_ENCRYPTION_FIELD, SSEKMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lastModified;

    private final String eTag;

    private final String versionId;

    private final String contentType;

    private final String serverSideEncryption;

    private final String ssekmsKeyId;

    private AwsS3ObjectDetails(BuilderImpl builder) {
        this.lastModified = builder.lastModified;
        this.eTag = builder.eTag;
        this.versionId = builder.versionId;
        this.contentType = builder.contentType;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.ssekmsKeyId = builder.ssekmsKeyId;
    }

    /**
     * <p>
     * The date and time when the object was last modified.
     * </p>
     * 
     * @return The date and time when the object was last modified.
     */
    public String lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The opaque identifier assigned by a web server to a specific version of a resource found at a URL.
     * </p>
     * 
     * @return The opaque identifier assigned by a web server to a specific version of a resource found at a URL.
     */
    public String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The version of the object.
     * </p>
     * 
     * @return The version of the object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * A standard MIME type describing the format of the object data.
     * </p>
     * 
     * @return A standard MIME type describing the format of the object data.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * If the object is stored using server-side encryption, the value of the server-side encryption algorithm used when
     * storing this object in Amazon S3.
     * </p>
     * 
     * @return If the object is stored using server-side encryption, the value of the server-side encryption algorithm
     *         used when storing this object in Amazon S3.
     */
    public String serverSideEncryption() {
        return serverSideEncryption;
    }

    /**
     * <p>
     * The identifier of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK)
     * that was used for the object.
     * </p>
     * 
     * @return The identifier of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key
     *         (CMK) that was used for the object.
     */
    public String ssekmsKeyId() {
        return ssekmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(ssekmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3ObjectDetails)) {
            return false;
        }
        AwsS3ObjectDetails other = (AwsS3ObjectDetails) obj;
        return Objects.equals(lastModified(), other.lastModified()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(serverSideEncryption(), other.serverSideEncryption())
                && Objects.equals(ssekmsKeyId(), other.ssekmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsS3ObjectDetails").add("LastModified", lastModified()).add("ETag", eTag())
                .add("VersionId", versionId()).add("ContentType", contentType())
                .add("ServerSideEncryption", serverSideEncryption()).add("SSEKMSKeyId", ssekmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "ServerSideEncryption":
            return Optional.ofNullable(clazz.cast(serverSideEncryption()));
        case "SSEKMSKeyId":
            return Optional.ofNullable(clazz.cast(ssekmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3ObjectDetails, T> g) {
        return obj -> g.apply((AwsS3ObjectDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3ObjectDetails> {
        /**
         * <p>
         * The date and time when the object was last modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time when the object was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(String lastModified);

        /**
         * <p>
         * The opaque identifier assigned by a web server to a specific version of a resource found at a URL.
         * </p>
         * 
         * @param eTag
         *        The opaque identifier assigned by a web server to a specific version of a resource found at a URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The version of the object.
         * </p>
         * 
         * @param versionId
         *        The version of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * A standard MIME type describing the format of the object data.
         * </p>
         * 
         * @param contentType
         *        A standard MIME type describing the format of the object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * If the object is stored using server-side encryption, the value of the server-side encryption algorithm used
         * when storing this object in Amazon S3.
         * </p>
         * 
         * @param serverSideEncryption
         *        If the object is stored using server-side encryption, the value of the server-side encryption
         *        algorithm used when storing this object in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryption(String serverSideEncryption);

        /**
         * <p>
         * The identifier of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key
         * (CMK) that was used for the object.
         * </p>
         * 
         * @param ssekmsKeyId
         *        The identifier of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master
         *        key (CMK) that was used for the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssekmsKeyId(String ssekmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String lastModified;

        private String eTag;

        private String versionId;

        private String contentType;

        private String serverSideEncryption;

        private String ssekmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3ObjectDetails model) {
            lastModified(model.lastModified);
            eTag(model.eTag);
            versionId(model.versionId);
            contentType(model.contentType);
            serverSideEncryption(model.serverSideEncryption);
            ssekmsKeyId(model.ssekmsKeyId);
        }

        public final String getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getServerSideEncryption() {
            return serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getSsekmsKeyId() {
            return ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSsekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        @Override
        public AwsS3ObjectDetails build() {
            return new AwsS3ObjectDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
