/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The function's AWS X-Ray tracing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLambdaFunctionTracingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLambdaFunctionTracingConfig.Builder, AwsLambdaFunctionTracingConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsLambdaFunctionTracingConfig::mode)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private AwsLambdaFunctionTracingConfig(BuilderImpl builder) {
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The tracing mode.
     * </p>
     * 
     * @return The tracing mode.
     */
    public String mode() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaFunctionTracingConfig)) {
            return false;
        }
        AwsLambdaFunctionTracingConfig other = (AwsLambdaFunctionTracingConfig) obj;
        return Objects.equals(mode(), other.mode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsLambdaFunctionTracingConfig").add("Mode", mode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(mode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaFunctionTracingConfig, T> g) {
        return obj -> g.apply((AwsLambdaFunctionTracingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLambdaFunctionTracingConfig> {
        /**
         * <p>
         * The tracing mode.
         * </p>
         * 
         * @param mode
         *        The tracing mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mode(String mode);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaFunctionTracingConfig model) {
            mode(model.mode);
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public AwsLambdaFunctionTracingConfig build() {
            return new AwsLambdaFunctionTracingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
