/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a customer master key (CMK).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsKmsKeyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsKmsKeyDetails.Builder, AwsKmsKeyDetails> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsKmsKeyDetails::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build()).build();

    private static final SdkField<Double> CREATION_DATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(AwsKmsKeyDetails::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsKmsKeyDetails::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> KEY_MANAGER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsKmsKeyDetails::keyManager)).setter(setter(Builder::keyManager))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyManager").build()).build();

    private static final SdkField<String> KEY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsKmsKeyDetails::keyState)).setter(setter(Builder::keyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyState").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsKmsKeyDetails::origin)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            CREATION_DATE_FIELD, KEY_ID_FIELD, KEY_MANAGER_FIELD, KEY_STATE_FIELD, ORIGIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final Double creationDate;

    private final String keyId;

    private final String keyManager;

    private final String keyState;

    private final String origin;

    private AwsKmsKeyDetails(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.creationDate = builder.creationDate;
        this.keyId = builder.keyId;
        this.keyManager = builder.keyManager;
        this.keyState = builder.keyState;
        this.origin = builder.origin;
    }

    /**
     * <p>
     * The twelve-digit account ID of the AWS account that owns the CMK.
     * </p>
     * 
     * @return The twelve-digit account ID of the AWS account that owns the CMK.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The date and time when the CMK was created.
     * </p>
     * 
     * @return The date and time when the CMK was created.
     */
    public Double creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The globally unique identifier for the CMK.
     * </p>
     * 
     * @return The globally unique identifier for the CMK.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The manager of the CMK. CMKs in your AWS account are either customer managed or AWS managed.
     * </p>
     * 
     * @return The manager of the CMK. CMKs in your AWS account are either customer managed or AWS managed.
     */
    public String keyManager() {
        return keyManager;
    }

    /**
     * <p>
     * The state of the CMK.
     * </p>
     * 
     * @return The state of the CMK.
     */
    public String keyState() {
        return keyState;
    }

    /**
     * <p>
     * The source of the CMK's key material.
     * </p>
     * <p>
     * When this value is <code>AWS_KMS</code>, AWS KMS created the key material.
     * </p>
     * <p>
     * When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management
     * infrastructure or the CMK lacks key material.
     * </p>
     * <p>
     * When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the AWS CloudHSM cluster associated
     * with a custom key store.
     * </p>
     * 
     * @return The source of the CMK's key material.</p>
     *         <p>
     *         When this value is <code>AWS_KMS</code>, AWS KMS created the key material.
     *         </p>
     *         <p>
     *         When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management
     *         infrastructure or the CMK lacks key material.
     *         </p>
     *         <p>
     *         When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the AWS CloudHSM cluster
     *         associated with a custom key store.
     */
    public String origin() {
        return origin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(keyManager());
        hashCode = 31 * hashCode + Objects.hashCode(keyState());
        hashCode = 31 * hashCode + Objects.hashCode(origin());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsKmsKeyDetails)) {
            return false;
        }
        AwsKmsKeyDetails other = (AwsKmsKeyDetails) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(keyId(), other.keyId()) && Objects.equals(keyManager(), other.keyManager())
                && Objects.equals(keyState(), other.keyState()) && Objects.equals(origin(), other.origin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsKmsKeyDetails").add("AWSAccountId", awsAccountId()).add("CreationDate", creationDate())
                .add("KeyId", keyId()).add("KeyManager", keyManager()).add("KeyState", keyState()).add("Origin", origin())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AWSAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "KeyManager":
            return Optional.ofNullable(clazz.cast(keyManager()));
        case "KeyState":
            return Optional.ofNullable(clazz.cast(keyState()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(origin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsKmsKeyDetails, T> g) {
        return obj -> g.apply((AwsKmsKeyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsKmsKeyDetails> {
        /**
         * <p>
         * The twelve-digit account ID of the AWS account that owns the CMK.
         * </p>
         * 
         * @param awsAccountId
         *        The twelve-digit account ID of the AWS account that owns the CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The date and time when the CMK was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the CMK was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Double creationDate);

        /**
         * <p>
         * The globally unique identifier for the CMK.
         * </p>
         * 
         * @param keyId
         *        The globally unique identifier for the CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The manager of the CMK. CMKs in your AWS account are either customer managed or AWS managed.
         * </p>
         * 
         * @param keyManager
         *        The manager of the CMK. CMKs in your AWS account are either customer managed or AWS managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyManager(String keyManager);

        /**
         * <p>
         * The state of the CMK.
         * </p>
         * 
         * @param keyState
         *        The state of the CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyState(String keyState);

        /**
         * <p>
         * The source of the CMK's key material.
         * </p>
         * <p>
         * When this value is <code>AWS_KMS</code>, AWS KMS created the key material.
         * </p>
         * <p>
         * When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management
         * infrastructure or the CMK lacks key material.
         * </p>
         * <p>
         * When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the AWS CloudHSM cluster
         * associated with a custom key store.
         * </p>
         * 
         * @param origin
         *        The source of the CMK's key material.</p>
         *        <p>
         *        When this value is <code>AWS_KMS</code>, AWS KMS created the key material.
         *        </p>
         *        <p>
         *        When this value is <code>EXTERNAL</code>, the key material was imported from your existing key
         *        management infrastructure or the CMK lacks key material.
         *        </p>
         *        <p>
         *        When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the AWS CloudHSM cluster
         *        associated with a custom key store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(String origin);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private Double creationDate;

        private String keyId;

        private String keyManager;

        private String keyState;

        private String origin;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsKmsKeyDetails model) {
            awsAccountId(model.awsAccountId);
            creationDate(model.creationDate);
            keyId(model.keyId);
            keyManager(model.keyManager);
            keyState(model.keyState);
            origin(model.origin);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final Double getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Double creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Double creationDate) {
            this.creationDate = creationDate;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getKeyManager() {
            return keyManager;
        }

        @Override
        public final Builder keyManager(String keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        public final void setKeyManager(String keyManager) {
            this.keyManager = keyManager;
        }

        public final String getKeyState() {
            return keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        public final String getOrigin() {
            return origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public AwsKmsKeyDetails build() {
            return new AwsKmsKeyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
