/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an IAM role, including all of the role's policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamRoleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamRoleDetails.Builder, AwsIamRoleDetails> {
    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamRoleDetails::assumeRolePolicyDocument)).setter(setter(Builder::assumeRolePolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build())
            .build();

    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamRoleDetails::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamRoleDetails::roleId)).setter(setter(Builder::roleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamRoleDetails::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AwsIamRoleDetails::maxSessionDuration)).setter(setter(Builder::maxSessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build())
            .build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamRoleDetails::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSUME_ROLE_POLICY_DOCUMENT_FIELD, CREATE_DATE_FIELD, ROLE_ID_FIELD, ROLE_NAME_FIELD, MAX_SESSION_DURATION_FIELD,
            PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assumeRolePolicyDocument;

    private final String createDate;

    private final String roleId;

    private final String roleName;

    private final Integer maxSessionDuration;

    private final String path;

    private AwsIamRoleDetails(BuilderImpl builder) {
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.createDate = builder.createDate;
        this.roleId = builder.roleId;
        this.roleName = builder.roleName;
        this.maxSessionDuration = builder.maxSessionDuration;
        this.path = builder.path;
    }

    /**
     * <p>
     * The trust policy that grants permission to assume the role.
     * </p>
     * 
     * @return The trust policy that grants permission to assume the role.
     */
    public String assumeRolePolicyDocument() {
        return assumeRolePolicyDocument;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 date-time format, when the role was created.
     * </p>
     * 
     * @return The date and time, in ISO 8601 date-time format, when the role was created.
     */
    public String createDate() {
        return createDate;
    }

    /**
     * <p>
     * The stable and unique string identifying the role.
     * </p>
     * 
     * @return The stable and unique string identifying the role.
     */
    public String roleId() {
        return roleId;
    }

    /**
     * <p>
     * The friendly name that identifies the role.
     * </p>
     * 
     * @return The friendly name that identifies the role.
     */
    public String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The maximum session duration (in seconds) that you want to set for the specified role.
     * </p>
     * 
     * @return The maximum session duration (in seconds) that you want to set for the specified role.
     */
    public Integer maxSessionDuration() {
        return maxSessionDuration;
    }

    /**
     * <p>
     * The path to the role.
     * </p>
     * 
     * @return The path to the role.
     */
    public String path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(roleId());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(maxSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamRoleDetails)) {
            return false;
        }
        AwsIamRoleDetails other = (AwsIamRoleDetails) obj;
        return Objects.equals(assumeRolePolicyDocument(), other.assumeRolePolicyDocument())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(roleId(), other.roleId())
                && Objects.equals(roleName(), other.roleName())
                && Objects.equals(maxSessionDuration(), other.maxSessionDuration()) && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsIamRoleDetails").add("AssumeRolePolicyDocument", assumeRolePolicyDocument())
                .add("CreateDate", createDate()).add("RoleId", roleId()).add("RoleName", roleName())
                .add("MaxSessionDuration", maxSessionDuration()).add("Path", path()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssumeRolePolicyDocument":
            return Optional.ofNullable(clazz.cast(assumeRolePolicyDocument()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "RoleId":
            return Optional.ofNullable(clazz.cast(roleId()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "MaxSessionDuration":
            return Optional.ofNullable(clazz.cast(maxSessionDuration()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamRoleDetails, T> g) {
        return obj -> g.apply((AwsIamRoleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamRoleDetails> {
        /**
         * <p>
         * The trust policy that grants permission to assume the role.
         * </p>
         * 
         * @param assumeRolePolicyDocument
         *        The trust policy that grants permission to assume the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumeRolePolicyDocument(String assumeRolePolicyDocument);

        /**
         * <p>
         * The date and time, in ISO 8601 date-time format, when the role was created.
         * </p>
         * 
         * @param createDate
         *        The date and time, in ISO 8601 date-time format, when the role was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(String createDate);

        /**
         * <p>
         * The stable and unique string identifying the role.
         * </p>
         * 
         * @param roleId
         *        The stable and unique string identifying the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleId(String roleId);

        /**
         * <p>
         * The friendly name that identifies the role.
         * </p>
         * 
         * @param roleName
         *        The friendly name that identifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The maximum session duration (in seconds) that you want to set for the specified role.
         * </p>
         * 
         * @param maxSessionDuration
         *        The maximum session duration (in seconds) that you want to set for the specified role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSessionDuration(Integer maxSessionDuration);

        /**
         * <p>
         * The path to the role.
         * </p>
         * 
         * @param path
         *        The path to the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);
    }

    static final class BuilderImpl implements Builder {
        private String assumeRolePolicyDocument;

        private String createDate;

        private String roleId;

        private String roleName;

        private Integer maxSessionDuration;

        private String path;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamRoleDetails model) {
            assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            createDate(model.createDate);
            roleId(model.roleId);
            roleName(model.roleName);
            maxSessionDuration(model.maxSessionDuration);
            path(model.path);
        }

        public final String getAssumeRolePolicyDocument() {
            return assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final String getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public final String getRoleId() {
            return roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final Integer getMaxSessionDuration() {
            return maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public AwsIamRoleDetails build() {
            return new AwsIamRoleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
