/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElasticsearchDomainDomainEndpointOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElasticsearchDomainDomainEndpointOptions.Builder, AwsElasticsearchDomainDomainEndpointOptions> {
    private static final SdkField<Boolean> ENFORCE_HTTPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AwsElasticsearchDomainDomainEndpointOptions::enforceHTTPS)).setter(setter(Builder::enforceHTTPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceHTTPS").build()).build();

    private static final SdkField<String> TLS_SECURITY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsElasticsearchDomainDomainEndpointOptions::tlsSecurityPolicy))
            .setter(setter(Builder::tlsSecurityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSSecurityPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCE_HTTPS_FIELD,
            TLS_SECURITY_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enforceHTTPS;

    private final String tlsSecurityPolicy;

    private AwsElasticsearchDomainDomainEndpointOptions(BuilderImpl builder) {
        this.enforceHTTPS = builder.enforceHTTPS;
        this.tlsSecurityPolicy = builder.tlsSecurityPolicy;
    }

    /**
     * <p>
     * Whether to require that all traffic to the domain arrive over HTTPS.
     * </p>
     * 
     * @return Whether to require that all traffic to the domain arrive over HTTPS.
     */
    public Boolean enforceHTTPS() {
        return enforceHTTPS;
    }

    /**
     * <p>
     * The TLS security policy to apply to the HTTPS endpoint of the Elasticsearch domain.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Policy-Min-TLS-1-0-2019-07</code>, which supports TLSv1.0 and higher
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Policy-Min-TLS-1-2-2019-07</code>, which only supports TLSv1.2
     * </p>
     * </li>
     * </ul>
     * 
     * @return The TLS security policy to apply to the HTTPS endpoint of the Elasticsearch domain.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Policy-Min-TLS-1-0-2019-07</code>, which supports TLSv1.0 and higher
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Policy-Min-TLS-1-2-2019-07</code>, which only supports TLSv1.2
     *         </p>
     *         </li>
     */
    public String tlsSecurityPolicy() {
        return tlsSecurityPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enforceHTTPS());
        hashCode = 31 * hashCode + Objects.hashCode(tlsSecurityPolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticsearchDomainDomainEndpointOptions)) {
            return false;
        }
        AwsElasticsearchDomainDomainEndpointOptions other = (AwsElasticsearchDomainDomainEndpointOptions) obj;
        return Objects.equals(enforceHTTPS(), other.enforceHTTPS())
                && Objects.equals(tlsSecurityPolicy(), other.tlsSecurityPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsElasticsearchDomainDomainEndpointOptions").add("EnforceHTTPS", enforceHTTPS())
                .add("TLSSecurityPolicy", tlsSecurityPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnforceHTTPS":
            return Optional.ofNullable(clazz.cast(enforceHTTPS()));
        case "TLSSecurityPolicy":
            return Optional.ofNullable(clazz.cast(tlsSecurityPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticsearchDomainDomainEndpointOptions, T> g) {
        return obj -> g.apply((AwsElasticsearchDomainDomainEndpointOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElasticsearchDomainDomainEndpointOptions> {
        /**
         * <p>
         * Whether to require that all traffic to the domain arrive over HTTPS.
         * </p>
         * 
         * @param enforceHTTPS
         *        Whether to require that all traffic to the domain arrive over HTTPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforceHTTPS(Boolean enforceHTTPS);

        /**
         * <p>
         * The TLS security policy to apply to the HTTPS endpoint of the Elasticsearch domain.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Policy-Min-TLS-1-0-2019-07</code>, which supports TLSv1.0 and higher
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy-Min-TLS-1-2-2019-07</code>, which only supports TLSv1.2
         * </p>
         * </li>
         * </ul>
         * 
         * @param tlsSecurityPolicy
         *        The TLS security policy to apply to the HTTPS endpoint of the Elasticsearch domain.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Policy-Min-TLS-1-0-2019-07</code>, which supports TLSv1.0 and higher
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy-Min-TLS-1-2-2019-07</code>, which only supports TLSv1.2
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsSecurityPolicy(String tlsSecurityPolicy);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enforceHTTPS;

        private String tlsSecurityPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticsearchDomainDomainEndpointOptions model) {
            enforceHTTPS(model.enforceHTTPS);
            tlsSecurityPolicy(model.tlsSecurityPolicy);
        }

        public final Boolean getEnforceHTTPS() {
            return enforceHTTPS;
        }

        @Override
        public final Builder enforceHTTPS(Boolean enforceHTTPS) {
            this.enforceHTTPS = enforceHTTPS;
            return this;
        }

        public final void setEnforceHTTPS(Boolean enforceHTTPS) {
            this.enforceHTTPS = enforceHTTPS;
        }

        public final String getTlsSecurityPolicy() {
            return tlsSecurityPolicy;
        }

        @Override
        public final Builder tlsSecurityPolicy(String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
            return this;
        }

        public final void setTlsSecurityPolicy(String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
        }

        @Override
        public AwsElasticsearchDomainDomainEndpointOptions build() {
            return new AwsElasticsearchDomainDomainEndpointOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
