/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an EC2 security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2SecurityGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2SecurityGroupDetails.Builder, AwsEc2SecurityGroupDetails> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2SecurityGroupDetails::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2SecurityGroupDetails::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2SecurityGroupDetails::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2SecurityGroupDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<AwsEc2SecurityGroupIpPermission>> IP_PERMISSIONS_FIELD = SdkField
            .<List<AwsEc2SecurityGroupIpPermission>> builder(MarshallingType.LIST)
            .getter(getter(AwsEc2SecurityGroupDetails::ipPermissions))
            .setter(setter(Builder::ipPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2SecurityGroupIpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2SecurityGroupIpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEc2SecurityGroupIpPermission>> IP_PERMISSIONS_EGRESS_FIELD = SdkField
            .<List<AwsEc2SecurityGroupIpPermission>> builder(MarshallingType.LIST)
            .getter(getter(AwsEc2SecurityGroupDetails::ipPermissionsEgress))
            .setter(setter(Builder::ipPermissionsEgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissionsEgress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2SecurityGroupIpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2SecurityGroupIpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            GROUP_ID_FIELD, OWNER_ID_FIELD, VPC_ID_FIELD, IP_PERMISSIONS_FIELD, IP_PERMISSIONS_EGRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String groupId;

    private final String ownerId;

    private final String vpcId;

    private final List<AwsEc2SecurityGroupIpPermission> ipPermissions;

    private final List<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress;

    private AwsEc2SecurityGroupDetails(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
        this.ownerId = builder.ownerId;
        this.vpcId = builder.vpcId;
        this.ipPermissions = builder.ipPermissions;
        this.ipPermissionsEgress = builder.ipPermissionsEgress;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the security group.
     * </p>
     * 
     * @return The AWS account ID of the owner of the security group.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * [VPC only] The ID of the VPC for the security group.
     * </p>
     * 
     * @return [VPC only] The ID of the VPC for the security group.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * Returns true if the IpPermissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpPermissions() {
        return ipPermissions != null && !(ipPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inbound rules associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The inbound rules associated with the security group.
     */
    public List<AwsEc2SecurityGroupIpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * Returns true if the IpPermissionsEgress property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasIpPermissionsEgress() {
        return ipPermissionsEgress != null && !(ipPermissionsEgress instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [VPC only] The outbound rules associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpPermissionsEgress()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [VPC only] The outbound rules associated with the security group.
     */
    public List<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress() {
        return ipPermissionsEgress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(ipPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(ipPermissionsEgress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2SecurityGroupDetails)) {
            return false;
        }
        AwsEc2SecurityGroupDetails other = (AwsEc2SecurityGroupDetails) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(ipPermissions(), other.ipPermissions())
                && Objects.equals(ipPermissionsEgress(), other.ipPermissionsEgress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsEc2SecurityGroupDetails").add("GroupName", groupName()).add("GroupId", groupId())
                .add("OwnerId", ownerId()).add("VpcId", vpcId()).add("IpPermissions", ipPermissions())
                .add("IpPermissionsEgress", ipPermissionsEgress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "IpPermissions":
            return Optional.ofNullable(clazz.cast(ipPermissions()));
        case "IpPermissionsEgress":
            return Optional.ofNullable(clazz.cast(ipPermissionsEgress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2SecurityGroupDetails, T> g) {
        return obj -> g.apply((AwsEc2SecurityGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2SecurityGroupDetails> {
        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The AWS account ID of the owner of the security group.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the owner of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * [VPC only] The ID of the VPC for the security group.
         * </p>
         * 
         * @param vpcId
         *        [VPC only] The ID of the VPC for the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissions
         *        The inbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<AwsEc2SecurityGroupIpPermission> ipPermissions);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissions
         *        The inbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(AwsEc2SecurityGroupIpPermission... ipPermissions);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2SecurityGroupIpPermission>.Builder}
         * avoiding the need to create one manually via {@link List<AwsEc2SecurityGroupIpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2SecurityGroupIpPermission>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipPermissions(List<AwsEc2SecurityGroupIpPermission>)}.
         * 
         * @param ipPermissions
         *        a consumer that will call methods on {@link List<AwsEc2SecurityGroupIpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissions(List<AwsEc2SecurityGroupIpPermission>)
         */
        Builder ipPermissions(Consumer<AwsEc2SecurityGroupIpPermission.Builder>... ipPermissions);

        /**
         * <p>
         * [VPC only] The outbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissionsEgress
         *        [VPC only] The outbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissionsEgress(Collection<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress);

        /**
         * <p>
         * [VPC only] The outbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissionsEgress
         *        [VPC only] The outbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissionsEgress(AwsEc2SecurityGroupIpPermission... ipPermissionsEgress);

        /**
         * <p>
         * [VPC only] The outbound rules associated with the security group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2SecurityGroupIpPermission>.Builder}
         * avoiding the need to create one manually via {@link List<AwsEc2SecurityGroupIpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2SecurityGroupIpPermission>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipPermissionsEgress(List<AwsEc2SecurityGroupIpPermission>)}.
         * 
         * @param ipPermissionsEgress
         *        a consumer that will call methods on {@link List<AwsEc2SecurityGroupIpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissionsEgress(List<AwsEc2SecurityGroupIpPermission>)
         */
        Builder ipPermissionsEgress(Consumer<AwsEc2SecurityGroupIpPermission.Builder>... ipPermissionsEgress);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String groupId;

        private String ownerId;

        private String vpcId;

        private List<AwsEc2SecurityGroupIpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2SecurityGroupDetails model) {
            groupName(model.groupName);
            groupId(model.groupId);
            ownerId(model.ownerId);
            vpcId(model.vpcId);
            ipPermissions(model.ipPermissions);
            ipPermissionsEgress(model.ipPermissionsEgress);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<AwsEc2SecurityGroupIpPermission.Builder> getIpPermissions() {
            return ipPermissions != null ? ipPermissions.stream().map(AwsEc2SecurityGroupIpPermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissions(Collection<AwsEc2SecurityGroupIpPermission> ipPermissions) {
            this.ipPermissions = AwsEc2SecurityGroupIpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(AwsEc2SecurityGroupIpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<AwsEc2SecurityGroupIpPermission.Builder>... ipPermissions) {
            ipPermissions(Stream.of(ipPermissions).map(c -> AwsEc2SecurityGroupIpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissions(Collection<AwsEc2SecurityGroupIpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = AwsEc2SecurityGroupIpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final Collection<AwsEc2SecurityGroupIpPermission.Builder> getIpPermissionsEgress() {
            return ipPermissionsEgress != null ? ipPermissionsEgress.stream().map(AwsEc2SecurityGroupIpPermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissionsEgress(Collection<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress) {
            this.ipPermissionsEgress = AwsEc2SecurityGroupIpPermissionListCopier.copy(ipPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(AwsEc2SecurityGroupIpPermission... ipPermissionsEgress) {
            ipPermissionsEgress(Arrays.asList(ipPermissionsEgress));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(Consumer<AwsEc2SecurityGroupIpPermission.Builder>... ipPermissionsEgress) {
            ipPermissionsEgress(Stream.of(ipPermissionsEgress)
                    .map(c -> AwsEc2SecurityGroupIpPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissionsEgress(Collection<AwsEc2SecurityGroupIpPermission.BuilderImpl> ipPermissionsEgress) {
            this.ipPermissionsEgress = AwsEc2SecurityGroupIpPermissionListCopier.copyFromBuilder(ipPermissionsEgress);
        }

        @Override
        public AwsEc2SecurityGroupDetails build() {
            return new AwsEc2SecurityGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
