/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the network interface
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2NetworkInterfaceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2NetworkInterfaceDetails.Builder, AwsEc2NetworkInterfaceDetails> {
    private static final SdkField<AwsEc2NetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField
            .<AwsEc2NetworkInterfaceAttachment> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsEc2NetworkInterfaceDetails::attachment)).setter(setter(Builder::attachment))
            .constructor(AwsEc2NetworkInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2NetworkInterfaceDetails::networkInterfaceId)).setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<List<AwsEc2NetworkInterfaceSecurityGroup>> SECURITY_GROUPS_FIELD = SdkField
            .<List<AwsEc2NetworkInterfaceSecurityGroup>> builder(MarshallingType.LIST)
            .getter(getter(AwsEc2NetworkInterfaceDetails::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2NetworkInterfaceSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2NetworkInterfaceSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AwsEc2NetworkInterfaceDetails::sourceDestCheck)).setter(setter(Builder::sourceDestCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD,
            NETWORK_INTERFACE_ID_FIELD, SECURITY_GROUPS_FIELD, SOURCE_DEST_CHECK_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsEc2NetworkInterfaceAttachment attachment;

    private final String networkInterfaceId;

    private final List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups;

    private final Boolean sourceDestCheck;

    private AwsEc2NetworkInterfaceDetails(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    /**
     * <p>
     * The network interface attachment.
     * </p>
     * 
     * @return The network interface attachment.
     */
    public AwsEc2NetworkInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Security groups for the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Security groups for the network interface.
     */
    public List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Indicates whether traffic to or from the instance is validated.
     * </p>
     * 
     * @return Indicates whether traffic to or from the instance is validated.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceDetails)) {
            return false;
        }
        AwsEc2NetworkInterfaceDetails other = (AwsEc2NetworkInterfaceDetails) obj;
        return Objects.equals(attachment(), other.attachment())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsEc2NetworkInterfaceDetails").add("Attachment", attachment())
                .add("NetworkInterfaceId", networkInterfaceId()).add("SecurityGroups", securityGroups())
                .add("SourceDestCheck", sourceDestCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceDetails, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2NetworkInterfaceDetails> {
        /**
         * <p>
         * The network interface attachment.
         * </p>
         * 
         * @param attachment
         *        The network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(AwsEc2NetworkInterfaceAttachment attachment);

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2NetworkInterfaceAttachment.Builder}
         * avoiding the need to create one manually via {@link AwsEc2NetworkInterfaceAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2NetworkInterfaceAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #attachment(AwsEc2NetworkInterfaceAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link AwsEc2NetworkInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(AwsEc2NetworkInterfaceAttachment)
         */
        default Builder attachment(Consumer<AwsEc2NetworkInterfaceAttachment.Builder> attachment) {
            return attachment(AwsEc2NetworkInterfaceAttachment.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Security groups for the network interface.
         * </p>
         * 
         * @param securityGroups
         *        Security groups for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup> securityGroups);

        /**
         * <p>
         * Security groups for the network interface.
         * </p>
         * 
         * @param securityGroups
         *        Security groups for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(AwsEc2NetworkInterfaceSecurityGroup... securityGroups);

        /**
         * <p>
         * Security groups for the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEc2NetworkInterfaceSecurityGroup>.Builder} avoiding the need to create one manually via {@link List
         * <AwsEc2NetworkInterfaceSecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2NetworkInterfaceSecurityGroup>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #securityGroups(List<AwsEc2NetworkInterfaceSecurityGroup>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on {@link List<AwsEc2NetworkInterfaceSecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(List<AwsEc2NetworkInterfaceSecurityGroup>)
         */
        Builder securityGroups(Consumer<AwsEc2NetworkInterfaceSecurityGroup.Builder>... securityGroups);

        /**
         * <p>
         * Indicates whether traffic to or from the instance is validated.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether traffic to or from the instance is validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);
    }

    static final class BuilderImpl implements Builder {
        private AwsEc2NetworkInterfaceAttachment attachment;

        private String networkInterfaceId;

        private List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceDetails model) {
            attachment(model.attachment);
            networkInterfaceId(model.networkInterfaceId);
            securityGroups(model.securityGroups);
            sourceDestCheck(model.sourceDestCheck);
        }

        public final AwsEc2NetworkInterfaceAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(AwsEc2NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(AwsEc2NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<AwsEc2NetworkInterfaceSecurityGroup.Builder> getSecurityGroups() {
            return securityGroups != null ? securityGroups.stream().map(AwsEc2NetworkInterfaceSecurityGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup> securityGroups) {
            this.securityGroups = AwsEc2NetworkInterfaceSecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(AwsEc2NetworkInterfaceSecurityGroup... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<AwsEc2NetworkInterfaceSecurityGroup.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups)
                    .map(c -> AwsEc2NetworkInterfaceSecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = AwsEc2NetworkInterfaceSecurityGroupListCopier.copyFromBuilder(securityGroups);
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public AwsEc2NetworkInterfaceDetails build() {
            return new AwsEc2NetworkInterfaceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
