/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An <code>ActionTarget</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionTarget implements SdkPojo, Serializable, ToCopyableBuilder<ActionTarget.Builder, ActionTarget> {
    private static final SdkField<String> ACTION_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionTarget::actionTargetArn)).setter(setter(Builder::actionTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionTargetArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionTarget::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionTarget::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TARGET_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionTargetArn;

    private final String name;

    private final String description;

    private ActionTarget(BuilderImpl builder) {
        this.actionTargetArn = builder.actionTargetArn;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ARN for the target action.
     * </p>
     * 
     * @return The ARN for the target action.
     */
    public String actionTargetArn() {
        return actionTargetArn;
    }

    /**
     * <p>
     * The name of the action target.
     * </p>
     * 
     * @return The name of the action target.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the target action.
     * </p>
     * 
     * @return The description of the target action.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTarget)) {
            return false;
        }
        ActionTarget other = (ActionTarget) obj;
        return Objects.equals(actionTargetArn(), other.actionTargetArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActionTarget").add("ActionTargetArn", actionTargetArn()).add("Name", name())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionTargetArn":
            return Optional.ofNullable(clazz.cast(actionTargetArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionTarget, T> g) {
        return obj -> g.apply((ActionTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionTarget> {
        /**
         * <p>
         * The ARN for the target action.
         * </p>
         * 
         * @param actionTargetArn
         *        The ARN for the target action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTargetArn(String actionTargetArn);

        /**
         * <p>
         * The name of the action target.
         * </p>
         * 
         * @param name
         *        The name of the action target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the target action.
         * </p>
         * 
         * @param description
         *        The description of the target action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String actionTargetArn;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTarget model) {
            actionTargetArn(model.actionTargetArn);
            name(model.name);
            description(model.description);
        }

        public final String getActionTargetArn() {
            return actionTargetArn;
        }

        @Override
        public final Builder actionTargetArn(String actionTargetArn) {
            this.actionTargetArn = actionTargetArn;
            return this;
        }

        public final void setActionTargetArn(String actionTargetArn) {
            this.actionTargetArn = actionTargetArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public ActionTarget build() {
            return new ActionTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
