/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ProductSubscriptionArnListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnabledProductsForImportResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListEnabledProductsForImportResponse> {
    private static final SdkField<List<String>> PRODUCT_SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListEnabledProductsForImportResponse.getter(ListEnabledProductsForImportResponse::productSubscriptions)).setter(ListEnabledProductsForImportResponse.setter(Builder::productSubscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSubscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListEnabledProductsForImportResponse.getter(ListEnabledProductsForImportResponse::nextToken)).setter(ListEnabledProductsForImportResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_SUBSCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> productSubscriptions;
    private final String nextToken;

    private ListEnabledProductsForImportResponse(BuilderImpl builder) {
        super(builder);
        this.productSubscriptions = builder.productSubscriptions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasProductSubscriptions() {
        return this.productSubscriptions != null && !(this.productSubscriptions instanceof SdkAutoConstructList);
    }

    public List<String> productSubscriptions() {
        return this.productSubscriptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productSubscriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnabledProductsForImportResponse)) {
            return false;
        }
        ListEnabledProductsForImportResponse other = (ListEnabledProductsForImportResponse)((Object)obj);
        return Objects.equals(this.productSubscriptions(), other.productSubscriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEnabledProductsForImportResponse").add("ProductSubscriptions", this.productSubscriptions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductSubscriptions": {
                return Optional.ofNullable(clazz.cast(this.productSubscriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnabledProductsForImportResponse, T> g) {
        return obj -> g.apply((ListEnabledProductsForImportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<String> productSubscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnabledProductsForImportResponse model) {
            super(model);
            this.productSubscriptions(model.productSubscriptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getProductSubscriptions() {
            return this.productSubscriptions;
        }

        @Override
        public final Builder productSubscriptions(Collection<String> productSubscriptions) {
            this.productSubscriptions = ProductSubscriptionArnListCopier.copy(productSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productSubscriptions(String ... productSubscriptions) {
            this.productSubscriptions(Arrays.asList(productSubscriptions));
            return this;
        }

        public final void setProductSubscriptions(Collection<String> productSubscriptions) {
            this.productSubscriptions = ProductSubscriptionArnListCopier.copy(productSubscriptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEnabledProductsForImportResponse build() {
            return new ListEnabledProductsForImportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnabledProductsForImportResponse> {
        public Builder productSubscriptions(Collection<String> var1);

        public Builder productSubscriptions(String ... var1);

        public Builder nextToken(String var1);
    }
}

