/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDetails;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails;
import software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerDetails;
import software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails;
import software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails;
import software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails;
import software.amazon.awssdk.services.securityhub.model.AwsSnsTopicDetails;
import software.amazon.awssdk.services.securityhub.model.AwsSqsQueueDetails;
import software.amazon.awssdk.services.securityhub.model.AwsWafWebAclDetails;
import software.amazon.awssdk.services.securityhub.model.ContainerDetails;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDetails> {
    private static final SdkField<AwsCodeBuildProjectDetails> AWS_CODE_BUILD_PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsCodeBuildProject)).setter(ResourceDetails.setter(Builder::awsCodeBuildProject)).constructor(AwsCodeBuildProjectDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCodeBuildProject").build()}).build();
    private static final SdkField<AwsCloudFrontDistributionDetails> AWS_CLOUD_FRONT_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsCloudFrontDistribution)).setter(ResourceDetails.setter(Builder::awsCloudFrontDistribution)).constructor(AwsCloudFrontDistributionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCloudFrontDistribution").build()}).build();
    private static final SdkField<AwsEc2InstanceDetails> AWS_EC2_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsEc2Instance)).setter(ResourceDetails.setter(Builder::awsEc2Instance)).constructor(AwsEc2InstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Instance").build()}).build();
    private static final SdkField<AwsEc2NetworkInterfaceDetails> AWS_EC2_NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsEc2NetworkInterface)).setter(ResourceDetails.setter(Builder::awsEc2NetworkInterface)).constructor(AwsEc2NetworkInterfaceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterface").build()}).build();
    private static final SdkField<AwsEc2SecurityGroupDetails> AWS_EC2_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsEc2SecurityGroup)).setter(ResourceDetails.setter(Builder::awsEc2SecurityGroup)).constructor(AwsEc2SecurityGroupDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2SecurityGroup").build()}).build();
    private static final SdkField<AwsElbv2LoadBalancerDetails> AWS_ELBV2_LOAD_BALANCER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsElbv2LoadBalancer)).setter(ResourceDetails.setter(Builder::awsElbv2LoadBalancer)).constructor(AwsElbv2LoadBalancerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElbv2LoadBalancer").build()}).build();
    private static final SdkField<AwsElasticsearchDomainDetails> AWS_ELASTICSEARCH_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsElasticsearchDomain)).setter(ResourceDetails.setter(Builder::awsElasticsearchDomain)).constructor(AwsElasticsearchDomainDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElasticsearchDomain").build()}).build();
    private static final SdkField<AwsS3BucketDetails> AWS_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsS3Bucket)).setter(ResourceDetails.setter(Builder::awsS3Bucket)).constructor(AwsS3BucketDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsS3Bucket").build()}).build();
    private static final SdkField<AwsIamAccessKeyDetails> AWS_IAM_ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsIamAccessKey)).setter(ResourceDetails.setter(Builder::awsIamAccessKey)).constructor(AwsIamAccessKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamAccessKey").build()}).build();
    private static final SdkField<AwsIamRoleDetails> AWS_IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsIamRole)).setter(ResourceDetails.setter(Builder::awsIamRole)).constructor(AwsIamRoleDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamRole").build()}).build();
    private static final SdkField<AwsKmsKeyDetails> AWS_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsKmsKey)).setter(ResourceDetails.setter(Builder::awsKmsKey)).constructor(AwsKmsKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKey").build()}).build();
    private static final SdkField<AwsLambdaFunctionDetails> AWS_LAMBDA_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsLambdaFunction)).setter(ResourceDetails.setter(Builder::awsLambdaFunction)).constructor(AwsLambdaFunctionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambdaFunction").build()}).build();
    private static final SdkField<AwsLambdaLayerVersionDetails> AWS_LAMBDA_LAYER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsLambdaLayerVersion)).setter(ResourceDetails.setter(Builder::awsLambdaLayerVersion)).constructor(AwsLambdaLayerVersionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambdaLayerVersion").build()}).build();
    private static final SdkField<AwsRdsDbInstanceDetails> AWS_RDS_DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsRdsDbInstance)).setter(ResourceDetails.setter(Builder::awsRdsDbInstance)).constructor(AwsRdsDbInstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRdsDbInstance").build()}).build();
    private static final SdkField<AwsSnsTopicDetails> AWS_SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsSnsTopic)).setter(ResourceDetails.setter(Builder::awsSnsTopic)).constructor(AwsSnsTopicDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSnsTopic").build()}).build();
    private static final SdkField<AwsSqsQueueDetails> AWS_SQS_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsSqsQueue)).setter(ResourceDetails.setter(Builder::awsSqsQueue)).constructor(AwsSqsQueueDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSqsQueue").build()}).build();
    private static final SdkField<AwsWafWebAclDetails> AWS_WAF_WEB_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsWafWebAcl)).setter(ResourceDetails.setter(Builder::awsWafWebAcl)).constructor(AwsWafWebAclDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafWebAcl").build()}).build();
    private static final SdkField<ContainerDetails> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::container)).setter(ResourceDetails.setter(Builder::container)).constructor(ContainerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()}).build();
    private static final SdkField<Map<String, String>> OTHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ResourceDetails.getter(ResourceDetails::other)).setter(ResourceDetails.setter(Builder::other)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Other").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_CODE_BUILD_PROJECT_FIELD, AWS_CLOUD_FRONT_DISTRIBUTION_FIELD, AWS_EC2_INSTANCE_FIELD, AWS_EC2_NETWORK_INTERFACE_FIELD, AWS_EC2_SECURITY_GROUP_FIELD, AWS_ELBV2_LOAD_BALANCER_FIELD, AWS_ELASTICSEARCH_DOMAIN_FIELD, AWS_S3_BUCKET_FIELD, AWS_IAM_ACCESS_KEY_FIELD, AWS_IAM_ROLE_FIELD, AWS_KMS_KEY_FIELD, AWS_LAMBDA_FUNCTION_FIELD, AWS_LAMBDA_LAYER_VERSION_FIELD, AWS_RDS_DB_INSTANCE_FIELD, AWS_SNS_TOPIC_FIELD, AWS_SQS_QUEUE_FIELD, AWS_WAF_WEB_ACL_FIELD, CONTAINER_FIELD, OTHER_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsCodeBuildProjectDetails awsCodeBuildProject;
    private final AwsCloudFrontDistributionDetails awsCloudFrontDistribution;
    private final AwsEc2InstanceDetails awsEc2Instance;
    private final AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface;
    private final AwsEc2SecurityGroupDetails awsEc2SecurityGroup;
    private final AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer;
    private final AwsElasticsearchDomainDetails awsElasticsearchDomain;
    private final AwsS3BucketDetails awsS3Bucket;
    private final AwsIamAccessKeyDetails awsIamAccessKey;
    private final AwsIamRoleDetails awsIamRole;
    private final AwsKmsKeyDetails awsKmsKey;
    private final AwsLambdaFunctionDetails awsLambdaFunction;
    private final AwsLambdaLayerVersionDetails awsLambdaLayerVersion;
    private final AwsRdsDbInstanceDetails awsRdsDbInstance;
    private final AwsSnsTopicDetails awsSnsTopic;
    private final AwsSqsQueueDetails awsSqsQueue;
    private final AwsWafWebAclDetails awsWafWebAcl;
    private final ContainerDetails container;
    private final Map<String, String> other;

    private ResourceDetails(BuilderImpl builder) {
        this.awsCodeBuildProject = builder.awsCodeBuildProject;
        this.awsCloudFrontDistribution = builder.awsCloudFrontDistribution;
        this.awsEc2Instance = builder.awsEc2Instance;
        this.awsEc2NetworkInterface = builder.awsEc2NetworkInterface;
        this.awsEc2SecurityGroup = builder.awsEc2SecurityGroup;
        this.awsElbv2LoadBalancer = builder.awsElbv2LoadBalancer;
        this.awsElasticsearchDomain = builder.awsElasticsearchDomain;
        this.awsS3Bucket = builder.awsS3Bucket;
        this.awsIamAccessKey = builder.awsIamAccessKey;
        this.awsIamRole = builder.awsIamRole;
        this.awsKmsKey = builder.awsKmsKey;
        this.awsLambdaFunction = builder.awsLambdaFunction;
        this.awsLambdaLayerVersion = builder.awsLambdaLayerVersion;
        this.awsRdsDbInstance = builder.awsRdsDbInstance;
        this.awsSnsTopic = builder.awsSnsTopic;
        this.awsSqsQueue = builder.awsSqsQueue;
        this.awsWafWebAcl = builder.awsWafWebAcl;
        this.container = builder.container;
        this.other = builder.other;
    }

    public AwsCodeBuildProjectDetails awsCodeBuildProject() {
        return this.awsCodeBuildProject;
    }

    public AwsCloudFrontDistributionDetails awsCloudFrontDistribution() {
        return this.awsCloudFrontDistribution;
    }

    public AwsEc2InstanceDetails awsEc2Instance() {
        return this.awsEc2Instance;
    }

    public AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface() {
        return this.awsEc2NetworkInterface;
    }

    public AwsEc2SecurityGroupDetails awsEc2SecurityGroup() {
        return this.awsEc2SecurityGroup;
    }

    public AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer() {
        return this.awsElbv2LoadBalancer;
    }

    public AwsElasticsearchDomainDetails awsElasticsearchDomain() {
        return this.awsElasticsearchDomain;
    }

    public AwsS3BucketDetails awsS3Bucket() {
        return this.awsS3Bucket;
    }

    public AwsIamAccessKeyDetails awsIamAccessKey() {
        return this.awsIamAccessKey;
    }

    public AwsIamRoleDetails awsIamRole() {
        return this.awsIamRole;
    }

    public AwsKmsKeyDetails awsKmsKey() {
        return this.awsKmsKey;
    }

    public AwsLambdaFunctionDetails awsLambdaFunction() {
        return this.awsLambdaFunction;
    }

    public AwsLambdaLayerVersionDetails awsLambdaLayerVersion() {
        return this.awsLambdaLayerVersion;
    }

    public AwsRdsDbInstanceDetails awsRdsDbInstance() {
        return this.awsRdsDbInstance;
    }

    public AwsSnsTopicDetails awsSnsTopic() {
        return this.awsSnsTopic;
    }

    public AwsSqsQueueDetails awsSqsQueue() {
        return this.awsSqsQueue;
    }

    public AwsWafWebAclDetails awsWafWebAcl() {
        return this.awsWafWebAcl;
    }

    public ContainerDetails container() {
        return this.container;
    }

    public boolean hasOther() {
        return this.other != null && !(this.other instanceof SdkAutoConstructMap);
    }

    public Map<String, String> other() {
        return this.other;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsCodeBuildProject());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsCloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2NetworkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2SecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsElbv2LoadBalancer());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsElasticsearchDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIamAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsKmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLambdaLayerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRdsDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsSnsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsSqsQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsWafWebAcl());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.other());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails)obj;
        return Objects.equals(this.awsCodeBuildProject(), other.awsCodeBuildProject()) && Objects.equals(this.awsCloudFrontDistribution(), other.awsCloudFrontDistribution()) && Objects.equals(this.awsEc2Instance(), other.awsEc2Instance()) && Objects.equals(this.awsEc2NetworkInterface(), other.awsEc2NetworkInterface()) && Objects.equals(this.awsEc2SecurityGroup(), other.awsEc2SecurityGroup()) && Objects.equals(this.awsElbv2LoadBalancer(), other.awsElbv2LoadBalancer()) && Objects.equals(this.awsElasticsearchDomain(), other.awsElasticsearchDomain()) && Objects.equals(this.awsS3Bucket(), other.awsS3Bucket()) && Objects.equals(this.awsIamAccessKey(), other.awsIamAccessKey()) && Objects.equals(this.awsIamRole(), other.awsIamRole()) && Objects.equals(this.awsKmsKey(), other.awsKmsKey()) && Objects.equals(this.awsLambdaFunction(), other.awsLambdaFunction()) && Objects.equals(this.awsLambdaLayerVersion(), other.awsLambdaLayerVersion()) && Objects.equals(this.awsRdsDbInstance(), other.awsRdsDbInstance()) && Objects.equals(this.awsSnsTopic(), other.awsSnsTopic()) && Objects.equals(this.awsSqsQueue(), other.awsSqsQueue()) && Objects.equals(this.awsWafWebAcl(), other.awsWafWebAcl()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.other(), other.other());
    }

    public String toString() {
        return ToString.builder((String)"ResourceDetails").add("AwsCodeBuildProject", (Object)this.awsCodeBuildProject()).add("AwsCloudFrontDistribution", (Object)this.awsCloudFrontDistribution()).add("AwsEc2Instance", (Object)this.awsEc2Instance()).add("AwsEc2NetworkInterface", (Object)this.awsEc2NetworkInterface()).add("AwsEc2SecurityGroup", (Object)this.awsEc2SecurityGroup()).add("AwsElbv2LoadBalancer", (Object)this.awsElbv2LoadBalancer()).add("AwsElasticsearchDomain", (Object)this.awsElasticsearchDomain()).add("AwsS3Bucket", (Object)this.awsS3Bucket()).add("AwsIamAccessKey", (Object)this.awsIamAccessKey()).add("AwsIamRole", (Object)this.awsIamRole()).add("AwsKmsKey", (Object)this.awsKmsKey()).add("AwsLambdaFunction", (Object)this.awsLambdaFunction()).add("AwsLambdaLayerVersion", (Object)this.awsLambdaLayerVersion()).add("AwsRdsDbInstance", (Object)this.awsRdsDbInstance()).add("AwsSnsTopic", (Object)this.awsSnsTopic()).add("AwsSqsQueue", (Object)this.awsSqsQueue()).add("AwsWafWebAcl", (Object)this.awsWafWebAcl()).add("Container", (Object)this.container()).add("Other", this.other()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsCodeBuildProject": {
                return Optional.ofNullable(clazz.cast(this.awsCodeBuildProject()));
            }
            case "AwsCloudFrontDistribution": {
                return Optional.ofNullable(clazz.cast(this.awsCloudFrontDistribution()));
            }
            case "AwsEc2Instance": {
                return Optional.ofNullable(clazz.cast(this.awsEc2Instance()));
            }
            case "AwsEc2NetworkInterface": {
                return Optional.ofNullable(clazz.cast(this.awsEc2NetworkInterface()));
            }
            case "AwsEc2SecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.awsEc2SecurityGroup()));
            }
            case "AwsElbv2LoadBalancer": {
                return Optional.ofNullable(clazz.cast(this.awsElbv2LoadBalancer()));
            }
            case "AwsElasticsearchDomain": {
                return Optional.ofNullable(clazz.cast(this.awsElasticsearchDomain()));
            }
            case "AwsS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.awsS3Bucket()));
            }
            case "AwsIamAccessKey": {
                return Optional.ofNullable(clazz.cast(this.awsIamAccessKey()));
            }
            case "AwsIamRole": {
                return Optional.ofNullable(clazz.cast(this.awsIamRole()));
            }
            case "AwsKmsKey": {
                return Optional.ofNullable(clazz.cast(this.awsKmsKey()));
            }
            case "AwsLambdaFunction": {
                return Optional.ofNullable(clazz.cast(this.awsLambdaFunction()));
            }
            case "AwsLambdaLayerVersion": {
                return Optional.ofNullable(clazz.cast(this.awsLambdaLayerVersion()));
            }
            case "AwsRdsDbInstance": {
                return Optional.ofNullable(clazz.cast(this.awsRdsDbInstance()));
            }
            case "AwsSnsTopic": {
                return Optional.ofNullable(clazz.cast(this.awsSnsTopic()));
            }
            case "AwsSqsQueue": {
                return Optional.ofNullable(clazz.cast(this.awsSqsQueue()));
            }
            case "AwsWafWebAcl": {
                return Optional.ofNullable(clazz.cast(this.awsWafWebAcl()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "Other": {
                return Optional.ofNullable(clazz.cast(this.other()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsCodeBuildProjectDetails awsCodeBuildProject;
        private AwsCloudFrontDistributionDetails awsCloudFrontDistribution;
        private AwsEc2InstanceDetails awsEc2Instance;
        private AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface;
        private AwsEc2SecurityGroupDetails awsEc2SecurityGroup;
        private AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer;
        private AwsElasticsearchDomainDetails awsElasticsearchDomain;
        private AwsS3BucketDetails awsS3Bucket;
        private AwsIamAccessKeyDetails awsIamAccessKey;
        private AwsIamRoleDetails awsIamRole;
        private AwsKmsKeyDetails awsKmsKey;
        private AwsLambdaFunctionDetails awsLambdaFunction;
        private AwsLambdaLayerVersionDetails awsLambdaLayerVersion;
        private AwsRdsDbInstanceDetails awsRdsDbInstance;
        private AwsSnsTopicDetails awsSnsTopic;
        private AwsSqsQueueDetails awsSqsQueue;
        private AwsWafWebAclDetails awsWafWebAcl;
        private ContainerDetails container;
        private Map<String, String> other = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            this.awsCodeBuildProject(model.awsCodeBuildProject);
            this.awsCloudFrontDistribution(model.awsCloudFrontDistribution);
            this.awsEc2Instance(model.awsEc2Instance);
            this.awsEc2NetworkInterface(model.awsEc2NetworkInterface);
            this.awsEc2SecurityGroup(model.awsEc2SecurityGroup);
            this.awsElbv2LoadBalancer(model.awsElbv2LoadBalancer);
            this.awsElasticsearchDomain(model.awsElasticsearchDomain);
            this.awsS3Bucket(model.awsS3Bucket);
            this.awsIamAccessKey(model.awsIamAccessKey);
            this.awsIamRole(model.awsIamRole);
            this.awsKmsKey(model.awsKmsKey);
            this.awsLambdaFunction(model.awsLambdaFunction);
            this.awsLambdaLayerVersion(model.awsLambdaLayerVersion);
            this.awsRdsDbInstance(model.awsRdsDbInstance);
            this.awsSnsTopic(model.awsSnsTopic);
            this.awsSqsQueue(model.awsSqsQueue);
            this.awsWafWebAcl(model.awsWafWebAcl);
            this.container(model.container);
            this.other(model.other);
        }

        public final AwsCodeBuildProjectDetails.Builder getAwsCodeBuildProject() {
            return this.awsCodeBuildProject != null ? this.awsCodeBuildProject.toBuilder() : null;
        }

        @Override
        public final Builder awsCodeBuildProject(AwsCodeBuildProjectDetails awsCodeBuildProject) {
            this.awsCodeBuildProject = awsCodeBuildProject;
            return this;
        }

        public final void setAwsCodeBuildProject(AwsCodeBuildProjectDetails.BuilderImpl awsCodeBuildProject) {
            this.awsCodeBuildProject = awsCodeBuildProject != null ? awsCodeBuildProject.build() : null;
        }

        public final AwsCloudFrontDistributionDetails.Builder getAwsCloudFrontDistribution() {
            return this.awsCloudFrontDistribution != null ? this.awsCloudFrontDistribution.toBuilder() : null;
        }

        @Override
        public final Builder awsCloudFrontDistribution(AwsCloudFrontDistributionDetails awsCloudFrontDistribution) {
            this.awsCloudFrontDistribution = awsCloudFrontDistribution;
            return this;
        }

        public final void setAwsCloudFrontDistribution(AwsCloudFrontDistributionDetails.BuilderImpl awsCloudFrontDistribution) {
            this.awsCloudFrontDistribution = awsCloudFrontDistribution != null ? awsCloudFrontDistribution.build() : null;
        }

        public final AwsEc2InstanceDetails.Builder getAwsEc2Instance() {
            return this.awsEc2Instance != null ? this.awsEc2Instance.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance;
            return this;
        }

        public final void setAwsEc2Instance(AwsEc2InstanceDetails.BuilderImpl awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance != null ? awsEc2Instance.build() : null;
        }

        public final AwsEc2NetworkInterfaceDetails.Builder getAwsEc2NetworkInterface() {
            return this.awsEc2NetworkInterface != null ? this.awsEc2NetworkInterface.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface) {
            this.awsEc2NetworkInterface = awsEc2NetworkInterface;
            return this;
        }

        public final void setAwsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails.BuilderImpl awsEc2NetworkInterface) {
            this.awsEc2NetworkInterface = awsEc2NetworkInterface != null ? awsEc2NetworkInterface.build() : null;
        }

        public final AwsEc2SecurityGroupDetails.Builder getAwsEc2SecurityGroup() {
            return this.awsEc2SecurityGroup != null ? this.awsEc2SecurityGroup.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2SecurityGroup(AwsEc2SecurityGroupDetails awsEc2SecurityGroup) {
            this.awsEc2SecurityGroup = awsEc2SecurityGroup;
            return this;
        }

        public final void setAwsEc2SecurityGroup(AwsEc2SecurityGroupDetails.BuilderImpl awsEc2SecurityGroup) {
            this.awsEc2SecurityGroup = awsEc2SecurityGroup != null ? awsEc2SecurityGroup.build() : null;
        }

        public final AwsElbv2LoadBalancerDetails.Builder getAwsElbv2LoadBalancer() {
            return this.awsElbv2LoadBalancer != null ? this.awsElbv2LoadBalancer.toBuilder() : null;
        }

        @Override
        public final Builder awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer) {
            this.awsElbv2LoadBalancer = awsElbv2LoadBalancer;
            return this;
        }

        public final void setAwsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails.BuilderImpl awsElbv2LoadBalancer) {
            this.awsElbv2LoadBalancer = awsElbv2LoadBalancer != null ? awsElbv2LoadBalancer.build() : null;
        }

        public final AwsElasticsearchDomainDetails.Builder getAwsElasticsearchDomain() {
            return this.awsElasticsearchDomain != null ? this.awsElasticsearchDomain.toBuilder() : null;
        }

        @Override
        public final Builder awsElasticsearchDomain(AwsElasticsearchDomainDetails awsElasticsearchDomain) {
            this.awsElasticsearchDomain = awsElasticsearchDomain;
            return this;
        }

        public final void setAwsElasticsearchDomain(AwsElasticsearchDomainDetails.BuilderImpl awsElasticsearchDomain) {
            this.awsElasticsearchDomain = awsElasticsearchDomain != null ? awsElasticsearchDomain.build() : null;
        }

        public final AwsS3BucketDetails.Builder getAwsS3Bucket() {
            return this.awsS3Bucket != null ? this.awsS3Bucket.toBuilder() : null;
        }

        @Override
        public final Builder awsS3Bucket(AwsS3BucketDetails awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket;
            return this;
        }

        public final void setAwsS3Bucket(AwsS3BucketDetails.BuilderImpl awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket != null ? awsS3Bucket.build() : null;
        }

        public final AwsIamAccessKeyDetails.Builder getAwsIamAccessKey() {
            return this.awsIamAccessKey != null ? this.awsIamAccessKey.toBuilder() : null;
        }

        @Override
        public final Builder awsIamAccessKey(AwsIamAccessKeyDetails awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey;
            return this;
        }

        public final void setAwsIamAccessKey(AwsIamAccessKeyDetails.BuilderImpl awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey != null ? awsIamAccessKey.build() : null;
        }

        public final AwsIamRoleDetails.Builder getAwsIamRole() {
            return this.awsIamRole != null ? this.awsIamRole.toBuilder() : null;
        }

        @Override
        public final Builder awsIamRole(AwsIamRoleDetails awsIamRole) {
            this.awsIamRole = awsIamRole;
            return this;
        }

        public final void setAwsIamRole(AwsIamRoleDetails.BuilderImpl awsIamRole) {
            this.awsIamRole = awsIamRole != null ? awsIamRole.build() : null;
        }

        public final AwsKmsKeyDetails.Builder getAwsKmsKey() {
            return this.awsKmsKey != null ? this.awsKmsKey.toBuilder() : null;
        }

        @Override
        public final Builder awsKmsKey(AwsKmsKeyDetails awsKmsKey) {
            this.awsKmsKey = awsKmsKey;
            return this;
        }

        public final void setAwsKmsKey(AwsKmsKeyDetails.BuilderImpl awsKmsKey) {
            this.awsKmsKey = awsKmsKey != null ? awsKmsKey.build() : null;
        }

        public final AwsLambdaFunctionDetails.Builder getAwsLambdaFunction() {
            return this.awsLambdaFunction != null ? this.awsLambdaFunction.toBuilder() : null;
        }

        @Override
        public final Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction;
            return this;
        }

        public final void setAwsLambdaFunction(AwsLambdaFunctionDetails.BuilderImpl awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction != null ? awsLambdaFunction.build() : null;
        }

        public final AwsLambdaLayerVersionDetails.Builder getAwsLambdaLayerVersion() {
            return this.awsLambdaLayerVersion != null ? this.awsLambdaLayerVersion.toBuilder() : null;
        }

        @Override
        public final Builder awsLambdaLayerVersion(AwsLambdaLayerVersionDetails awsLambdaLayerVersion) {
            this.awsLambdaLayerVersion = awsLambdaLayerVersion;
            return this;
        }

        public final void setAwsLambdaLayerVersion(AwsLambdaLayerVersionDetails.BuilderImpl awsLambdaLayerVersion) {
            this.awsLambdaLayerVersion = awsLambdaLayerVersion != null ? awsLambdaLayerVersion.build() : null;
        }

        public final AwsRdsDbInstanceDetails.Builder getAwsRdsDbInstance() {
            return this.awsRdsDbInstance != null ? this.awsRdsDbInstance.toBuilder() : null;
        }

        @Override
        public final Builder awsRdsDbInstance(AwsRdsDbInstanceDetails awsRdsDbInstance) {
            this.awsRdsDbInstance = awsRdsDbInstance;
            return this;
        }

        public final void setAwsRdsDbInstance(AwsRdsDbInstanceDetails.BuilderImpl awsRdsDbInstance) {
            this.awsRdsDbInstance = awsRdsDbInstance != null ? awsRdsDbInstance.build() : null;
        }

        public final AwsSnsTopicDetails.Builder getAwsSnsTopic() {
            return this.awsSnsTopic != null ? this.awsSnsTopic.toBuilder() : null;
        }

        @Override
        public final Builder awsSnsTopic(AwsSnsTopicDetails awsSnsTopic) {
            this.awsSnsTopic = awsSnsTopic;
            return this;
        }

        public final void setAwsSnsTopic(AwsSnsTopicDetails.BuilderImpl awsSnsTopic) {
            this.awsSnsTopic = awsSnsTopic != null ? awsSnsTopic.build() : null;
        }

        public final AwsSqsQueueDetails.Builder getAwsSqsQueue() {
            return this.awsSqsQueue != null ? this.awsSqsQueue.toBuilder() : null;
        }

        @Override
        public final Builder awsSqsQueue(AwsSqsQueueDetails awsSqsQueue) {
            this.awsSqsQueue = awsSqsQueue;
            return this;
        }

        public final void setAwsSqsQueue(AwsSqsQueueDetails.BuilderImpl awsSqsQueue) {
            this.awsSqsQueue = awsSqsQueue != null ? awsSqsQueue.build() : null;
        }

        public final AwsWafWebAclDetails.Builder getAwsWafWebAcl() {
            return this.awsWafWebAcl != null ? this.awsWafWebAcl.toBuilder() : null;
        }

        @Override
        public final Builder awsWafWebAcl(AwsWafWebAclDetails awsWafWebAcl) {
            this.awsWafWebAcl = awsWafWebAcl;
            return this;
        }

        public final void setAwsWafWebAcl(AwsWafWebAclDetails.BuilderImpl awsWafWebAcl) {
            this.awsWafWebAcl = awsWafWebAcl != null ? awsWafWebAcl.build() : null;
        }

        public final ContainerDetails.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerDetails container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerDetails.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final Map<String, String> getOther() {
            return this.other;
        }

        @Override
        public final Builder other(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
            return this;
        }

        public final void setOther(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
        }

        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDetails> {
        public Builder awsCodeBuildProject(AwsCodeBuildProjectDetails var1);

        default public Builder awsCodeBuildProject(Consumer<AwsCodeBuildProjectDetails.Builder> awsCodeBuildProject) {
            return this.awsCodeBuildProject((AwsCodeBuildProjectDetails)((AwsCodeBuildProjectDetails.Builder)AwsCodeBuildProjectDetails.builder().applyMutation(awsCodeBuildProject)).build());
        }

        public Builder awsCloudFrontDistribution(AwsCloudFrontDistributionDetails var1);

        default public Builder awsCloudFrontDistribution(Consumer<AwsCloudFrontDistributionDetails.Builder> awsCloudFrontDistribution) {
            return this.awsCloudFrontDistribution((AwsCloudFrontDistributionDetails)((AwsCloudFrontDistributionDetails.Builder)AwsCloudFrontDistributionDetails.builder().applyMutation(awsCloudFrontDistribution)).build());
        }

        public Builder awsEc2Instance(AwsEc2InstanceDetails var1);

        default public Builder awsEc2Instance(Consumer<AwsEc2InstanceDetails.Builder> awsEc2Instance) {
            return this.awsEc2Instance((AwsEc2InstanceDetails)((AwsEc2InstanceDetails.Builder)AwsEc2InstanceDetails.builder().applyMutation(awsEc2Instance)).build());
        }

        public Builder awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails var1);

        default public Builder awsEc2NetworkInterface(Consumer<AwsEc2NetworkInterfaceDetails.Builder> awsEc2NetworkInterface) {
            return this.awsEc2NetworkInterface((AwsEc2NetworkInterfaceDetails)((AwsEc2NetworkInterfaceDetails.Builder)AwsEc2NetworkInterfaceDetails.builder().applyMutation(awsEc2NetworkInterface)).build());
        }

        public Builder awsEc2SecurityGroup(AwsEc2SecurityGroupDetails var1);

        default public Builder awsEc2SecurityGroup(Consumer<AwsEc2SecurityGroupDetails.Builder> awsEc2SecurityGroup) {
            return this.awsEc2SecurityGroup((AwsEc2SecurityGroupDetails)((AwsEc2SecurityGroupDetails.Builder)AwsEc2SecurityGroupDetails.builder().applyMutation(awsEc2SecurityGroup)).build());
        }

        public Builder awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails var1);

        default public Builder awsElbv2LoadBalancer(Consumer<AwsElbv2LoadBalancerDetails.Builder> awsElbv2LoadBalancer) {
            return this.awsElbv2LoadBalancer((AwsElbv2LoadBalancerDetails)((AwsElbv2LoadBalancerDetails.Builder)AwsElbv2LoadBalancerDetails.builder().applyMutation(awsElbv2LoadBalancer)).build());
        }

        public Builder awsElasticsearchDomain(AwsElasticsearchDomainDetails var1);

        default public Builder awsElasticsearchDomain(Consumer<AwsElasticsearchDomainDetails.Builder> awsElasticsearchDomain) {
            return this.awsElasticsearchDomain((AwsElasticsearchDomainDetails)((AwsElasticsearchDomainDetails.Builder)AwsElasticsearchDomainDetails.builder().applyMutation(awsElasticsearchDomain)).build());
        }

        public Builder awsS3Bucket(AwsS3BucketDetails var1);

        default public Builder awsS3Bucket(Consumer<AwsS3BucketDetails.Builder> awsS3Bucket) {
            return this.awsS3Bucket((AwsS3BucketDetails)((AwsS3BucketDetails.Builder)AwsS3BucketDetails.builder().applyMutation(awsS3Bucket)).build());
        }

        public Builder awsIamAccessKey(AwsIamAccessKeyDetails var1);

        default public Builder awsIamAccessKey(Consumer<AwsIamAccessKeyDetails.Builder> awsIamAccessKey) {
            return this.awsIamAccessKey((AwsIamAccessKeyDetails)((AwsIamAccessKeyDetails.Builder)AwsIamAccessKeyDetails.builder().applyMutation(awsIamAccessKey)).build());
        }

        public Builder awsIamRole(AwsIamRoleDetails var1);

        default public Builder awsIamRole(Consumer<AwsIamRoleDetails.Builder> awsIamRole) {
            return this.awsIamRole((AwsIamRoleDetails)((AwsIamRoleDetails.Builder)AwsIamRoleDetails.builder().applyMutation(awsIamRole)).build());
        }

        public Builder awsKmsKey(AwsKmsKeyDetails var1);

        default public Builder awsKmsKey(Consumer<AwsKmsKeyDetails.Builder> awsKmsKey) {
            return this.awsKmsKey((AwsKmsKeyDetails)((AwsKmsKeyDetails.Builder)AwsKmsKeyDetails.builder().applyMutation(awsKmsKey)).build());
        }

        public Builder awsLambdaFunction(AwsLambdaFunctionDetails var1);

        default public Builder awsLambdaFunction(Consumer<AwsLambdaFunctionDetails.Builder> awsLambdaFunction) {
            return this.awsLambdaFunction((AwsLambdaFunctionDetails)((AwsLambdaFunctionDetails.Builder)AwsLambdaFunctionDetails.builder().applyMutation(awsLambdaFunction)).build());
        }

        public Builder awsLambdaLayerVersion(AwsLambdaLayerVersionDetails var1);

        default public Builder awsLambdaLayerVersion(Consumer<AwsLambdaLayerVersionDetails.Builder> awsLambdaLayerVersion) {
            return this.awsLambdaLayerVersion((AwsLambdaLayerVersionDetails)((AwsLambdaLayerVersionDetails.Builder)AwsLambdaLayerVersionDetails.builder().applyMutation(awsLambdaLayerVersion)).build());
        }

        public Builder awsRdsDbInstance(AwsRdsDbInstanceDetails var1);

        default public Builder awsRdsDbInstance(Consumer<AwsRdsDbInstanceDetails.Builder> awsRdsDbInstance) {
            return this.awsRdsDbInstance((AwsRdsDbInstanceDetails)((AwsRdsDbInstanceDetails.Builder)AwsRdsDbInstanceDetails.builder().applyMutation(awsRdsDbInstance)).build());
        }

        public Builder awsSnsTopic(AwsSnsTopicDetails var1);

        default public Builder awsSnsTopic(Consumer<AwsSnsTopicDetails.Builder> awsSnsTopic) {
            return this.awsSnsTopic((AwsSnsTopicDetails)((AwsSnsTopicDetails.Builder)AwsSnsTopicDetails.builder().applyMutation(awsSnsTopic)).build());
        }

        public Builder awsSqsQueue(AwsSqsQueueDetails var1);

        default public Builder awsSqsQueue(Consumer<AwsSqsQueueDetails.Builder> awsSqsQueue) {
            return this.awsSqsQueue((AwsSqsQueueDetails)((AwsSqsQueueDetails.Builder)AwsSqsQueueDetails.builder().applyMutation(awsSqsQueue)).build());
        }

        public Builder awsWafWebAcl(AwsWafWebAclDetails var1);

        default public Builder awsWafWebAcl(Consumer<AwsWafWebAclDetails.Builder> awsWafWebAcl) {
            return this.awsWafWebAcl((AwsWafWebAclDetails)((AwsWafWebAclDetails.Builder)AwsWafWebAclDetails.builder().applyMutation(awsWafWebAcl)).build());
        }

        public Builder container(ContainerDetails var1);

        default public Builder container(Consumer<ContainerDetails.Builder> container) {
            return this.container((ContainerDetails)((ContainerDetails.Builder)ContainerDetails.builder().applyMutation(container)).build());
        }

        public Builder other(Map<String, String> var1);
    }
}

