/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A string filter for querying findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringFilter implements SdkPojo, Serializable, ToCopyableBuilder<StringFilter.Builder, StringFilter> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StringFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> COMPARISON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StringFilter::comparisonAsString)).setter(setter(Builder::comparison))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VALUE_FIELD, COMPARISON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String comparison;

    private StringFilter(BuilderImpl builder) {
        this.value = builder.value;
        this.comparison = builder.comparison;
    }

    /**
     * <p>
     * The string filter value.
     * </p>
     * 
     * @return The string filter value.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The condition to be applied to a string value when querying for findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparison} will
     * return {@link StringFilterComparison#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #comparisonAsString}.
     * </p>
     * 
     * @return The condition to be applied to a string value when querying for findings.
     * @see StringFilterComparison
     */
    public StringFilterComparison comparison() {
        return StringFilterComparison.fromValue(comparison);
    }

    /**
     * <p>
     * The condition to be applied to a string value when querying for findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparison} will
     * return {@link StringFilterComparison#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #comparisonAsString}.
     * </p>
     * 
     * @return The condition to be applied to a string value when querying for findings.
     * @see StringFilterComparison
     */
    public String comparisonAsString() {
        return comparison;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringFilter)) {
            return false;
        }
        StringFilter other = (StringFilter) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(comparisonAsString(), other.comparisonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StringFilter").add("Value", value()).add("Comparison", comparisonAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Comparison":
            return Optional.ofNullable(clazz.cast(comparisonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringFilter, T> g) {
        return obj -> g.apply((StringFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringFilter> {
        /**
         * <p>
         * The string filter value.
         * </p>
         * 
         * @param value
         *        The string filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The condition to be applied to a string value when querying for findings.
         * </p>
         * 
         * @param comparison
         *        The condition to be applied to a string value when querying for findings.
         * @see StringFilterComparison
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringFilterComparison
         */
        Builder comparison(String comparison);

        /**
         * <p>
         * The condition to be applied to a string value when querying for findings.
         * </p>
         * 
         * @param comparison
         *        The condition to be applied to a string value when querying for findings.
         * @see StringFilterComparison
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringFilterComparison
         */
        Builder comparison(StringFilterComparison comparison);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String comparison;

        private BuilderImpl() {
        }

        private BuilderImpl(StringFilter model) {
            value(model.value);
            comparison(model.comparison);
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getComparisonAsString() {
            return comparison;
        }

        @Override
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        @Override
        public final Builder comparison(StringFilterComparison comparison) {
            this.comparison(comparison == null ? null : comparison.toString());
            return this;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        public StringFilter build() {
            return new StringFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
