/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The severity of the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Severity implements SdkPojo, Serializable, ToCopyableBuilder<Severity.Builder, Severity> {
    private static final SdkField<Double> PRODUCT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Severity::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<Integer> NORMALIZED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Severity::normalized)).setter(setter(Builder::normalized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normalized").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_FIELD,
            NORMALIZED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double product;

    private final Integer normalized;

    private Severity(BuilderImpl builder) {
        this.product = builder.product;
        this.normalized = builder.normalized;
    }

    /**
     * <p>
     * The native severity as defined by the AWS service or integrated partner product that generated the finding.
     * </p>
     * 
     * @return The native severity as defined by the AWS service or integrated partner product that generated the
     *         finding.
     */
    public Double product() {
        return product;
    }

    /**
     * <p>
     * The normalized severity of a finding.
     * </p>
     * 
     * @return The normalized severity of a finding.
     */
    public Integer normalized() {
        return normalized;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(normalized());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Severity)) {
            return false;
        }
        Severity other = (Severity) obj;
        return Objects.equals(product(), other.product()) && Objects.equals(normalized(), other.normalized());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Severity").add("Product", product()).add("Normalized", normalized()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "Normalized":
            return Optional.ofNullable(clazz.cast(normalized()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Severity, T> g) {
        return obj -> g.apply((Severity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Severity> {
        /**
         * <p>
         * The native severity as defined by the AWS service or integrated partner product that generated the finding.
         * </p>
         * 
         * @param product
         *        The native severity as defined by the AWS service or integrated partner product that generated the
         *        finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(Double product);

        /**
         * <p>
         * The normalized severity of a finding.
         * </p>
         * 
         * @param normalized
         *        The normalized severity of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normalized(Integer normalized);
    }

    static final class BuilderImpl implements Builder {
        private Double product;

        private Integer normalized;

        private BuilderImpl() {
        }

        private BuilderImpl(Severity model) {
            product(model.product);
            normalized(model.normalized);
        }

        public final Double getProduct() {
            return product;
        }

        @Override
        public final Builder product(Double product) {
            this.product = product;
            return this;
        }

        public final void setProduct(Double product) {
            this.product = product;
        }

        public final Integer getNormalized() {
            return normalized;
        }

        @Override
        public final Builder normalized(Integer normalized) {
            this.normalized = normalized;
            return this;
        }

        public final void setNormalized(Integer normalized) {
            this.normalized = normalized;
        }

        @Override
        public Severity build() {
            return new Severity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
