/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the account that wasn't processed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Result implements SdkPojo, Serializable, ToCopyableBuilder<Result.Builder, Result> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Result::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> PROCESSING_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Result::processingResult)).setter(setter(Builder::processingResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            PROCESSING_RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String processingResult;

    private Result(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.processingResult = builder.processingResult;
    }

    /**
     * <p>
     * An AWS account ID of the account that wasn't be processed.
     * </p>
     * 
     * @return An AWS account ID of the account that wasn't be processed.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The reason that the account wasn't be processed.
     * </p>
     * 
     * @return The reason that the account wasn't be processed.
     */
    public String processingResult() {
        return processingResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(processingResult());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Result)) {
            return false;
        }
        Result other = (Result) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(processingResult(), other.processingResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Result").add("AccountId", accountId()).add("ProcessingResult", processingResult()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ProcessingResult":
            return Optional.ofNullable(clazz.cast(processingResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Result, T> g) {
        return obj -> g.apply((Result) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Result> {
        /**
         * <p>
         * An AWS account ID of the account that wasn't be processed.
         * </p>
         * 
         * @param accountId
         *        An AWS account ID of the account that wasn't be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The reason that the account wasn't be processed.
         * </p>
         * 
         * @param processingResult
         *        The reason that the account wasn't be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingResult(String processingResult);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String processingResult;

        private BuilderImpl() {
        }

        private BuilderImpl(Result model) {
            accountId(model.accountId);
            processingResult(model.processingResult);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getProcessingResult() {
            return processingResult;
        }

        @Override
        public final Builder processingResult(String processingResult) {
            this.processingResult = processingResult;
            return this;
        }

        public final void setProcessingResult(String processingResult) {
            this.processingResult = processingResult;
        }

        @Override
        public Result build() {
            return new Result(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
