/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional details about a resource related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDetails.Builder, ResourceDetails> {
    private static final SdkField<AwsCloudFrontDistributionDetails> AWS_CLOUD_FRONT_DISTRIBUTION_FIELD = SdkField
            .<AwsCloudFrontDistributionDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceDetails::awsCloudFrontDistribution)).setter(setter(Builder::awsCloudFrontDistribution))
            .constructor(AwsCloudFrontDistributionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCloudFrontDistribution").build())
            .build();

    private static final SdkField<AwsEc2InstanceDetails> AWS_EC2_INSTANCE_FIELD = SdkField
            .<AwsEc2InstanceDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsEc2Instance))
            .setter(setter(Builder::awsEc2Instance)).constructor(AwsEc2InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Instance").build()).build();

    private static final SdkField<AwsElbv2LoadBalancerDetails> AWS_ELBV2_LOAD_BALANCER_FIELD = SdkField
            .<AwsElbv2LoadBalancerDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceDetails::awsElbv2LoadBalancer)).setter(setter(Builder::awsElbv2LoadBalancer))
            .constructor(AwsElbv2LoadBalancerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElbv2LoadBalancer").build())
            .build();

    private static final SdkField<AwsS3BucketDetails> AWS_S3_BUCKET_FIELD = SdkField
            .<AwsS3BucketDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsS3Bucket))
            .setter(setter(Builder::awsS3Bucket)).constructor(AwsS3BucketDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsS3Bucket").build()).build();

    private static final SdkField<AwsIamAccessKeyDetails> AWS_IAM_ACCESS_KEY_FIELD = SdkField
            .<AwsIamAccessKeyDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsIamAccessKey))
            .setter(setter(Builder::awsIamAccessKey)).constructor(AwsIamAccessKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamAccessKey").build()).build();

    private static final SdkField<AwsIamRoleDetails> AWS_IAM_ROLE_FIELD = SdkField
            .<AwsIamRoleDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsIamRole))
            .setter(setter(Builder::awsIamRole)).constructor(AwsIamRoleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamRole").build()).build();

    private static final SdkField<AwsKmsKeyDetails> AWS_KMS_KEY_FIELD = SdkField
            .<AwsKmsKeyDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsKmsKey))
            .setter(setter(Builder::awsKmsKey)).constructor(AwsKmsKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKey").build()).build();

    private static final SdkField<AwsLambdaFunctionDetails> AWS_LAMBDA_FUNCTION_FIELD = SdkField
            .<AwsLambdaFunctionDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsLambdaFunction))
            .setter(setter(Builder::awsLambdaFunction)).constructor(AwsLambdaFunctionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambdaFunction").build()).build();

    private static final SdkField<AwsSnsTopicDetails> AWS_SNS_TOPIC_FIELD = SdkField
            .<AwsSnsTopicDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsSnsTopic))
            .setter(setter(Builder::awsSnsTopic)).constructor(AwsSnsTopicDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSnsTopic").build()).build();

    private static final SdkField<AwsSqsQueueDetails> AWS_SQS_QUEUE_FIELD = SdkField
            .<AwsSqsQueueDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsSqsQueue))
            .setter(setter(Builder::awsSqsQueue)).constructor(AwsSqsQueueDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSqsQueue").build()).build();

    private static final SdkField<ContainerDetails> CONTAINER_FIELD = SdkField
            .<ContainerDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::container))
            .setter(setter(Builder::container)).constructor(ContainerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final SdkField<Map<String, String>> OTHER_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ResourceDetails::other))
            .setter(setter(Builder::other))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Other").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_CLOUD_FRONT_DISTRIBUTION_FIELD, AWS_EC2_INSTANCE_FIELD, AWS_ELBV2_LOAD_BALANCER_FIELD, AWS_S3_BUCKET_FIELD,
            AWS_IAM_ACCESS_KEY_FIELD, AWS_IAM_ROLE_FIELD, AWS_KMS_KEY_FIELD, AWS_LAMBDA_FUNCTION_FIELD, AWS_SNS_TOPIC_FIELD,
            AWS_SQS_QUEUE_FIELD, CONTAINER_FIELD, OTHER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsCloudFrontDistributionDetails awsCloudFrontDistribution;

    private final AwsEc2InstanceDetails awsEc2Instance;

    private final AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer;

    private final AwsS3BucketDetails awsS3Bucket;

    private final AwsIamAccessKeyDetails awsIamAccessKey;

    private final AwsIamRoleDetails awsIamRole;

    private final AwsKmsKeyDetails awsKmsKey;

    private final AwsLambdaFunctionDetails awsLambdaFunction;

    private final AwsSnsTopicDetails awsSnsTopic;

    private final AwsSqsQueueDetails awsSqsQueue;

    private final ContainerDetails container;

    private final Map<String, String> other;

    private ResourceDetails(BuilderImpl builder) {
        this.awsCloudFrontDistribution = builder.awsCloudFrontDistribution;
        this.awsEc2Instance = builder.awsEc2Instance;
        this.awsElbv2LoadBalancer = builder.awsElbv2LoadBalancer;
        this.awsS3Bucket = builder.awsS3Bucket;
        this.awsIamAccessKey = builder.awsIamAccessKey;
        this.awsIamRole = builder.awsIamRole;
        this.awsKmsKey = builder.awsKmsKey;
        this.awsLambdaFunction = builder.awsLambdaFunction;
        this.awsSnsTopic = builder.awsSnsTopic;
        this.awsSqsQueue = builder.awsSqsQueue;
        this.container = builder.container;
        this.other = builder.other;
    }

    /**
     * <p>
     * Details about a CloudFront distribution.
     * </p>
     * 
     * @return Details about a CloudFront distribution.
     */
    public AwsCloudFrontDistributionDetails awsCloudFrontDistribution() {
        return awsCloudFrontDistribution;
    }

    /**
     * <p>
     * Details about an Amazon EC2 instance related to a finding.
     * </p>
     * 
     * @return Details about an Amazon EC2 instance related to a finding.
     */
    public AwsEc2InstanceDetails awsEc2Instance() {
        return awsEc2Instance;
    }

    /**
     * <p>
     * Details about a load balancer.
     * </p>
     * 
     * @return Details about a load balancer.
     */
    public AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer() {
        return awsElbv2LoadBalancer;
    }

    /**
     * <p>
     * Details about an Amazon S3 Bucket related to a finding.
     * </p>
     * 
     * @return Details about an Amazon S3 Bucket related to a finding.
     */
    public AwsS3BucketDetails awsS3Bucket() {
        return awsS3Bucket;
    }

    /**
     * <p>
     * Details about an IAM access key related to a finding.
     * </p>
     * 
     * @return Details about an IAM access key related to a finding.
     */
    public AwsIamAccessKeyDetails awsIamAccessKey() {
        return awsIamAccessKey;
    }

    /**
     * <p>
     * Details about an IAM role.
     * </p>
     * 
     * @return Details about an IAM role.
     */
    public AwsIamRoleDetails awsIamRole() {
        return awsIamRole;
    }

    /**
     * <p>
     * Details about a KMS key.
     * </p>
     * 
     * @return Details about a KMS key.
     */
    public AwsKmsKeyDetails awsKmsKey() {
        return awsKmsKey;
    }

    /**
     * <p>
     * Details about a Lambda function.
     * </p>
     * 
     * @return Details about a Lambda function.
     */
    public AwsLambdaFunctionDetails awsLambdaFunction() {
        return awsLambdaFunction;
    }

    /**
     * <p>
     * Details about an SNS topic.
     * </p>
     * 
     * @return Details about an SNS topic.
     */
    public AwsSnsTopicDetails awsSnsTopic() {
        return awsSnsTopic;
    }

    /**
     * <p>
     * Details about an SQS queue.
     * </p>
     * 
     * @return Details about an SQS queue.
     */
    public AwsSqsQueueDetails awsSqsQueue() {
        return awsSqsQueue;
    }

    /**
     * <p>
     * Details about a container resource related to a finding.
     * </p>
     * 
     * @return Details about a container resource related to a finding.
     */
    public ContainerDetails container() {
        return container;
    }

    /**
     * Returns true if the Other property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOther() {
        return other != null && !(other instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details about a resource that doesn't have a specific type defined.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOther()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details about a resource that doesn't have a specific type defined.
     */
    public Map<String, String> other() {
        return other;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsCloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(awsElbv2LoadBalancer());
        hashCode = 31 * hashCode + Objects.hashCode(awsS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamRole());
        hashCode = 31 * hashCode + Objects.hashCode(awsKmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(awsLambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(awsSnsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(awsSqsQueue());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(other());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails) obj;
        return Objects.equals(awsCloudFrontDistribution(), other.awsCloudFrontDistribution())
                && Objects.equals(awsEc2Instance(), other.awsEc2Instance())
                && Objects.equals(awsElbv2LoadBalancer(), other.awsElbv2LoadBalancer())
                && Objects.equals(awsS3Bucket(), other.awsS3Bucket())
                && Objects.equals(awsIamAccessKey(), other.awsIamAccessKey()) && Objects.equals(awsIamRole(), other.awsIamRole())
                && Objects.equals(awsKmsKey(), other.awsKmsKey())
                && Objects.equals(awsLambdaFunction(), other.awsLambdaFunction())
                && Objects.equals(awsSnsTopic(), other.awsSnsTopic()) && Objects.equals(awsSqsQueue(), other.awsSqsQueue())
                && Objects.equals(container(), other.container()) && Objects.equals(other(), other.other());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceDetails").add("AwsCloudFrontDistribution", awsCloudFrontDistribution())
                .add("AwsEc2Instance", awsEc2Instance()).add("AwsElbv2LoadBalancer", awsElbv2LoadBalancer())
                .add("AwsS3Bucket", awsS3Bucket()).add("AwsIamAccessKey", awsIamAccessKey()).add("AwsIamRole", awsIamRole())
                .add("AwsKmsKey", awsKmsKey()).add("AwsLambdaFunction", awsLambdaFunction()).add("AwsSnsTopic", awsSnsTopic())
                .add("AwsSqsQueue", awsSqsQueue()).add("Container", container()).add("Other", other()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsCloudFrontDistribution":
            return Optional.ofNullable(clazz.cast(awsCloudFrontDistribution()));
        case "AwsEc2Instance":
            return Optional.ofNullable(clazz.cast(awsEc2Instance()));
        case "AwsElbv2LoadBalancer":
            return Optional.ofNullable(clazz.cast(awsElbv2LoadBalancer()));
        case "AwsS3Bucket":
            return Optional.ofNullable(clazz.cast(awsS3Bucket()));
        case "AwsIamAccessKey":
            return Optional.ofNullable(clazz.cast(awsIamAccessKey()));
        case "AwsIamRole":
            return Optional.ofNullable(clazz.cast(awsIamRole()));
        case "AwsKmsKey":
            return Optional.ofNullable(clazz.cast(awsKmsKey()));
        case "AwsLambdaFunction":
            return Optional.ofNullable(clazz.cast(awsLambdaFunction()));
        case "AwsSnsTopic":
            return Optional.ofNullable(clazz.cast(awsSnsTopic()));
        case "AwsSqsQueue":
            return Optional.ofNullable(clazz.cast(awsSqsQueue()));
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        case "Other":
            return Optional.ofNullable(clazz.cast(other()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDetails> {
        /**
         * <p>
         * Details about a CloudFront distribution.
         * </p>
         * 
         * @param awsCloudFrontDistribution
         *        Details about a CloudFront distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCloudFrontDistribution(AwsCloudFrontDistributionDetails awsCloudFrontDistribution);

        /**
         * <p>
         * Details about a CloudFront distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCloudFrontDistributionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsCloudFrontDistributionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsCloudFrontDistribution(AwsCloudFrontDistributionDetails)}.
         * 
         * @param awsCloudFrontDistribution
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCloudFrontDistribution(AwsCloudFrontDistributionDetails)
         */
        default Builder awsCloudFrontDistribution(Consumer<AwsCloudFrontDistributionDetails.Builder> awsCloudFrontDistribution) {
            return awsCloudFrontDistribution(AwsCloudFrontDistributionDetails.builder().applyMutation(awsCloudFrontDistribution)
                    .build());
        }

        /**
         * <p>
         * Details about an Amazon EC2 instance related to a finding.
         * </p>
         * 
         * @param awsEc2Instance
         *        Details about an Amazon EC2 instance related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance);

        /**
         * <p>
         * Details about an Amazon EC2 instance related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2InstanceDetails.Builder} avoiding the need
         * to create one manually via {@link AwsEc2InstanceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2InstanceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEc2Instance(AwsEc2InstanceDetails)}.
         * 
         * @param awsEc2Instance
         *        a consumer that will call methods on {@link AwsEc2InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2Instance(AwsEc2InstanceDetails)
         */
        default Builder awsEc2Instance(Consumer<AwsEc2InstanceDetails.Builder> awsEc2Instance) {
            return awsEc2Instance(AwsEc2InstanceDetails.builder().applyMutation(awsEc2Instance).build());
        }

        /**
         * <p>
         * Details about a load balancer.
         * </p>
         * 
         * @param awsElbv2LoadBalancer
         *        Details about a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer);

        /**
         * <p>
         * Details about a load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsElbv2LoadBalancerDetails.Builder} avoiding
         * the need to create one manually via {@link AwsElbv2LoadBalancerDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElbv2LoadBalancerDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails)}.
         * 
         * @param awsElbv2LoadBalancer
         *        a consumer that will call methods on {@link AwsElbv2LoadBalancerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails)
         */
        default Builder awsElbv2LoadBalancer(Consumer<AwsElbv2LoadBalancerDetails.Builder> awsElbv2LoadBalancer) {
            return awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails.builder().applyMutation(awsElbv2LoadBalancer).build());
        }

        /**
         * <p>
         * Details about an Amazon S3 Bucket related to a finding.
         * </p>
         * 
         * @param awsS3Bucket
         *        Details about an Amazon S3 Bucket related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsS3Bucket(AwsS3BucketDetails awsS3Bucket);

        /**
         * <p>
         * Details about an Amazon S3 Bucket related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsS3BucketDetails.Builder} avoiding the need to
         * create one manually via {@link AwsS3BucketDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsS3BucketDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsS3Bucket(AwsS3BucketDetails)}.
         * 
         * @param awsS3Bucket
         *        a consumer that will call methods on {@link AwsS3BucketDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsS3Bucket(AwsS3BucketDetails)
         */
        default Builder awsS3Bucket(Consumer<AwsS3BucketDetails.Builder> awsS3Bucket) {
            return awsS3Bucket(AwsS3BucketDetails.builder().applyMutation(awsS3Bucket).build());
        }

        /**
         * <p>
         * Details about an IAM access key related to a finding.
         * </p>
         * 
         * @param awsIamAccessKey
         *        Details about an IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamAccessKey(AwsIamAccessKeyDetails awsIamAccessKey);

        /**
         * <p>
         * Details about an IAM access key related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsIamAccessKeyDetails.Builder} avoiding the
         * need to create one manually via {@link AwsIamAccessKeyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsIamAccessKeyDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsIamAccessKey(AwsIamAccessKeyDetails)}.
         * 
         * @param awsIamAccessKey
         *        a consumer that will call methods on {@link AwsIamAccessKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamAccessKey(AwsIamAccessKeyDetails)
         */
        default Builder awsIamAccessKey(Consumer<AwsIamAccessKeyDetails.Builder> awsIamAccessKey) {
            return awsIamAccessKey(AwsIamAccessKeyDetails.builder().applyMutation(awsIamAccessKey).build());
        }

        /**
         * <p>
         * Details about an IAM role.
         * </p>
         * 
         * @param awsIamRole
         *        Details about an IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamRole(AwsIamRoleDetails awsIamRole);

        /**
         * <p>
         * Details about an IAM role.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsIamRoleDetails.Builder} avoiding the need to
         * create one manually via {@link AwsIamRoleDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsIamRoleDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsIamRole(AwsIamRoleDetails)}.
         * 
         * @param awsIamRole
         *        a consumer that will call methods on {@link AwsIamRoleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamRole(AwsIamRoleDetails)
         */
        default Builder awsIamRole(Consumer<AwsIamRoleDetails.Builder> awsIamRole) {
            return awsIamRole(AwsIamRoleDetails.builder().applyMutation(awsIamRole).build());
        }

        /**
         * <p>
         * Details about a KMS key.
         * </p>
         * 
         * @param awsKmsKey
         *        Details about a KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsKmsKey(AwsKmsKeyDetails awsKmsKey);

        /**
         * <p>
         * Details about a KMS key.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsKmsKeyDetails.Builder} avoiding the need to
         * create one manually via {@link AwsKmsKeyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsKmsKeyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsKmsKey(AwsKmsKeyDetails)}.
         * 
         * @param awsKmsKey
         *        a consumer that will call methods on {@link AwsKmsKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsKmsKey(AwsKmsKeyDetails)
         */
        default Builder awsKmsKey(Consumer<AwsKmsKeyDetails.Builder> awsKmsKey) {
            return awsKmsKey(AwsKmsKeyDetails.builder().applyMutation(awsKmsKey).build());
        }

        /**
         * <p>
         * Details about a Lambda function.
         * </p>
         * 
         * @param awsLambdaFunction
         *        Details about a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction);

        /**
         * <p>
         * Details about a Lambda function.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaFunctionDetails.Builder} avoiding the
         * need to create one manually via {@link AwsLambdaFunctionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsLambdaFunction(AwsLambdaFunctionDetails)}.
         * 
         * @param awsLambdaFunction
         *        a consumer that will call methods on {@link AwsLambdaFunctionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLambdaFunction(AwsLambdaFunctionDetails)
         */
        default Builder awsLambdaFunction(Consumer<AwsLambdaFunctionDetails.Builder> awsLambdaFunction) {
            return awsLambdaFunction(AwsLambdaFunctionDetails.builder().applyMutation(awsLambdaFunction).build());
        }

        /**
         * <p>
         * Details about an SNS topic.
         * </p>
         * 
         * @param awsSnsTopic
         *        Details about an SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSnsTopic(AwsSnsTopicDetails awsSnsTopic);

        /**
         * <p>
         * Details about an SNS topic.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSnsTopicDetails.Builder} avoiding the need to
         * create one manually via {@link AwsSnsTopicDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSnsTopicDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsSnsTopic(AwsSnsTopicDetails)}.
         * 
         * @param awsSnsTopic
         *        a consumer that will call methods on {@link AwsSnsTopicDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSnsTopic(AwsSnsTopicDetails)
         */
        default Builder awsSnsTopic(Consumer<AwsSnsTopicDetails.Builder> awsSnsTopic) {
            return awsSnsTopic(AwsSnsTopicDetails.builder().applyMutation(awsSnsTopic).build());
        }

        /**
         * <p>
         * Details about an SQS queue.
         * </p>
         * 
         * @param awsSqsQueue
         *        Details about an SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSqsQueue(AwsSqsQueueDetails awsSqsQueue);

        /**
         * <p>
         * Details about an SQS queue.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSqsQueueDetails.Builder} avoiding the need to
         * create one manually via {@link AwsSqsQueueDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSqsQueueDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsSqsQueue(AwsSqsQueueDetails)}.
         * 
         * @param awsSqsQueue
         *        a consumer that will call methods on {@link AwsSqsQueueDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSqsQueue(AwsSqsQueueDetails)
         */
        default Builder awsSqsQueue(Consumer<AwsSqsQueueDetails.Builder> awsSqsQueue) {
            return awsSqsQueue(AwsSqsQueueDetails.builder().applyMutation(awsSqsQueue).build());
        }

        /**
         * <p>
         * Details about a container resource related to a finding.
         * </p>
         * 
         * @param container
         *        Details about a container resource related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(ContainerDetails container);

        /**
         * <p>
         * Details about a container resource related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerDetails.Builder} avoiding the need to
         * create one manually via {@link ContainerDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #container(ContainerDetails)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link ContainerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(ContainerDetails)
         */
        default Builder container(Consumer<ContainerDetails.Builder> container) {
            return container(ContainerDetails.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * Details about a resource that doesn't have a specific type defined.
         * </p>
         * 
         * @param other
         *        Details about a resource that doesn't have a specific type defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder other(Map<String, String> other);
    }

    static final class BuilderImpl implements Builder {
        private AwsCloudFrontDistributionDetails awsCloudFrontDistribution;

        private AwsEc2InstanceDetails awsEc2Instance;

        private AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer;

        private AwsS3BucketDetails awsS3Bucket;

        private AwsIamAccessKeyDetails awsIamAccessKey;

        private AwsIamRoleDetails awsIamRole;

        private AwsKmsKeyDetails awsKmsKey;

        private AwsLambdaFunctionDetails awsLambdaFunction;

        private AwsSnsTopicDetails awsSnsTopic;

        private AwsSqsQueueDetails awsSqsQueue;

        private ContainerDetails container;

        private Map<String, String> other = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            awsCloudFrontDistribution(model.awsCloudFrontDistribution);
            awsEc2Instance(model.awsEc2Instance);
            awsElbv2LoadBalancer(model.awsElbv2LoadBalancer);
            awsS3Bucket(model.awsS3Bucket);
            awsIamAccessKey(model.awsIamAccessKey);
            awsIamRole(model.awsIamRole);
            awsKmsKey(model.awsKmsKey);
            awsLambdaFunction(model.awsLambdaFunction);
            awsSnsTopic(model.awsSnsTopic);
            awsSqsQueue(model.awsSqsQueue);
            container(model.container);
            other(model.other);
        }

        public final AwsCloudFrontDistributionDetails.Builder getAwsCloudFrontDistribution() {
            return awsCloudFrontDistribution != null ? awsCloudFrontDistribution.toBuilder() : null;
        }

        @Override
        public final Builder awsCloudFrontDistribution(AwsCloudFrontDistributionDetails awsCloudFrontDistribution) {
            this.awsCloudFrontDistribution = awsCloudFrontDistribution;
            return this;
        }

        public final void setAwsCloudFrontDistribution(AwsCloudFrontDistributionDetails.BuilderImpl awsCloudFrontDistribution) {
            this.awsCloudFrontDistribution = awsCloudFrontDistribution != null ? awsCloudFrontDistribution.build() : null;
        }

        public final AwsEc2InstanceDetails.Builder getAwsEc2Instance() {
            return awsEc2Instance != null ? awsEc2Instance.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance;
            return this;
        }

        public final void setAwsEc2Instance(AwsEc2InstanceDetails.BuilderImpl awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance != null ? awsEc2Instance.build() : null;
        }

        public final AwsElbv2LoadBalancerDetails.Builder getAwsElbv2LoadBalancer() {
            return awsElbv2LoadBalancer != null ? awsElbv2LoadBalancer.toBuilder() : null;
        }

        @Override
        public final Builder awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer) {
            this.awsElbv2LoadBalancer = awsElbv2LoadBalancer;
            return this;
        }

        public final void setAwsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails.BuilderImpl awsElbv2LoadBalancer) {
            this.awsElbv2LoadBalancer = awsElbv2LoadBalancer != null ? awsElbv2LoadBalancer.build() : null;
        }

        public final AwsS3BucketDetails.Builder getAwsS3Bucket() {
            return awsS3Bucket != null ? awsS3Bucket.toBuilder() : null;
        }

        @Override
        public final Builder awsS3Bucket(AwsS3BucketDetails awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket;
            return this;
        }

        public final void setAwsS3Bucket(AwsS3BucketDetails.BuilderImpl awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket != null ? awsS3Bucket.build() : null;
        }

        public final AwsIamAccessKeyDetails.Builder getAwsIamAccessKey() {
            return awsIamAccessKey != null ? awsIamAccessKey.toBuilder() : null;
        }

        @Override
        public final Builder awsIamAccessKey(AwsIamAccessKeyDetails awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey;
            return this;
        }

        public final void setAwsIamAccessKey(AwsIamAccessKeyDetails.BuilderImpl awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey != null ? awsIamAccessKey.build() : null;
        }

        public final AwsIamRoleDetails.Builder getAwsIamRole() {
            return awsIamRole != null ? awsIamRole.toBuilder() : null;
        }

        @Override
        public final Builder awsIamRole(AwsIamRoleDetails awsIamRole) {
            this.awsIamRole = awsIamRole;
            return this;
        }

        public final void setAwsIamRole(AwsIamRoleDetails.BuilderImpl awsIamRole) {
            this.awsIamRole = awsIamRole != null ? awsIamRole.build() : null;
        }

        public final AwsKmsKeyDetails.Builder getAwsKmsKey() {
            return awsKmsKey != null ? awsKmsKey.toBuilder() : null;
        }

        @Override
        public final Builder awsKmsKey(AwsKmsKeyDetails awsKmsKey) {
            this.awsKmsKey = awsKmsKey;
            return this;
        }

        public final void setAwsKmsKey(AwsKmsKeyDetails.BuilderImpl awsKmsKey) {
            this.awsKmsKey = awsKmsKey != null ? awsKmsKey.build() : null;
        }

        public final AwsLambdaFunctionDetails.Builder getAwsLambdaFunction() {
            return awsLambdaFunction != null ? awsLambdaFunction.toBuilder() : null;
        }

        @Override
        public final Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction;
            return this;
        }

        public final void setAwsLambdaFunction(AwsLambdaFunctionDetails.BuilderImpl awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction != null ? awsLambdaFunction.build() : null;
        }

        public final AwsSnsTopicDetails.Builder getAwsSnsTopic() {
            return awsSnsTopic != null ? awsSnsTopic.toBuilder() : null;
        }

        @Override
        public final Builder awsSnsTopic(AwsSnsTopicDetails awsSnsTopic) {
            this.awsSnsTopic = awsSnsTopic;
            return this;
        }

        public final void setAwsSnsTopic(AwsSnsTopicDetails.BuilderImpl awsSnsTopic) {
            this.awsSnsTopic = awsSnsTopic != null ? awsSnsTopic.build() : null;
        }

        public final AwsSqsQueueDetails.Builder getAwsSqsQueue() {
            return awsSqsQueue != null ? awsSqsQueue.toBuilder() : null;
        }

        @Override
        public final Builder awsSqsQueue(AwsSqsQueueDetails awsSqsQueue) {
            this.awsSqsQueue = awsSqsQueue;
            return this;
        }

        public final void setAwsSqsQueue(AwsSqsQueueDetails.BuilderImpl awsSqsQueue) {
            this.awsSqsQueue = awsSqsQueue != null ? awsSqsQueue.build() : null;
        }

        public final ContainerDetails.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerDetails container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerDetails.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final Map<String, String> getOther() {
            return other;
        }

        @Override
        public final Builder other(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
            return this;
        }

        public final void setOther(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
        }

        @Override
        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
