/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Product implements SdkPojo, Serializable, ToCopyableBuilder<Product.Builder, Product> {
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Product::productArn)).setter(setter(Builder::productArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Product::productName)).setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Product::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Product::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Product::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKETPLACE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Product::marketplaceUrl)).setter(setter(Builder::marketplaceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceUrl").build()).build();

    private static final SdkField<String> ACTIVATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Product::activationUrl)).setter(setter(Builder::activationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationUrl").build()).build();

    private static final SdkField<String> PRODUCT_SUBSCRIPTION_RESOURCE_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Product::productSubscriptionResourcePolicy))
            .setter(setter(Builder::productSubscriptionResourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSubscriptionResourcePolicy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ARN_FIELD,
            PRODUCT_NAME_FIELD, COMPANY_NAME_FIELD, DESCRIPTION_FIELD, CATEGORIES_FIELD, MARKETPLACE_URL_FIELD,
            ACTIVATION_URL_FIELD, PRODUCT_SUBSCRIPTION_RESOURCE_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String productArn;

    private final String productName;

    private final String companyName;

    private final String description;

    private final List<String> categories;

    private final String marketplaceUrl;

    private final String activationUrl;

    private final String productSubscriptionResourcePolicy;

    private Product(BuilderImpl builder) {
        this.productArn = builder.productArn;
        this.productName = builder.productName;
        this.companyName = builder.companyName;
        this.description = builder.description;
        this.categories = builder.categories;
        this.marketplaceUrl = builder.marketplaceUrl;
        this.activationUrl = builder.activationUrl;
        this.productSubscriptionResourcePolicy = builder.productSubscriptionResourcePolicy;
    }

    /**
     * <p>
     * The ARN assigned to the product.
     * </p>
     * 
     * @return The ARN assigned to the product.
     */
    public String productArn() {
        return productArn;
    }

    /**
     * <p>
     * The name of the product.
     * </p>
     * 
     * @return The name of the product.
     */
    public String productName() {
        return productName;
    }

    /**
     * <p>
     * The name of the company that provides the product.
     * </p>
     * 
     * @return The name of the company that provides the product.
     */
    public String companyName() {
        return companyName;
    }

    /**
     * <p>
     * A description of the product.
     * </p>
     * 
     * @return A description of the product.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Categories property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categories assigned to the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCategories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The categories assigned to the product.
     */
    public List<String> categories() {
        return categories;
    }

    /**
     * <p>
     * The URL for the page that contains more information about the product.
     * </p>
     * 
     * @return The URL for the page that contains more information about the product.
     */
    public String marketplaceUrl() {
        return marketplaceUrl;
    }

    /**
     * <p>
     * The URL used to activate the product.
     * </p>
     * 
     * @return The URL used to activate the product.
     */
    public String activationUrl() {
        return activationUrl;
    }

    /**
     * <p>
     * The resource policy associated with the product.
     * </p>
     * 
     * @return The resource policy associated with the product.
     */
    public String productSubscriptionResourcePolicy() {
        return productSubscriptionResourcePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productArn());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(categories());
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(activationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(productSubscriptionResourcePolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Product)) {
            return false;
        }
        Product other = (Product) obj;
        return Objects.equals(productArn(), other.productArn()) && Objects.equals(productName(), other.productName())
                && Objects.equals(companyName(), other.companyName()) && Objects.equals(description(), other.description())
                && Objects.equals(categories(), other.categories()) && Objects.equals(marketplaceUrl(), other.marketplaceUrl())
                && Objects.equals(activationUrl(), other.activationUrl())
                && Objects.equals(productSubscriptionResourcePolicy(), other.productSubscriptionResourcePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Product").add("ProductArn", productArn()).add("ProductName", productName())
                .add("CompanyName", companyName()).add("Description", description()).add("Categories", categories())
                .add("MarketplaceUrl", marketplaceUrl()).add("ActivationUrl", activationUrl())
                .add("ProductSubscriptionResourcePolicy", productSubscriptionResourcePolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductArn":
            return Optional.ofNullable(clazz.cast(productArn()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "MarketplaceUrl":
            return Optional.ofNullable(clazz.cast(marketplaceUrl()));
        case "ActivationUrl":
            return Optional.ofNullable(clazz.cast(activationUrl()));
        case "ProductSubscriptionResourcePolicy":
            return Optional.ofNullable(clazz.cast(productSubscriptionResourcePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Product, T> g) {
        return obj -> g.apply((Product) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Product> {
        /**
         * <p>
         * The ARN assigned to the product.
         * </p>
         * 
         * @param productArn
         *        The ARN assigned to the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(String productArn);

        /**
         * <p>
         * The name of the product.
         * </p>
         * 
         * @param productName
         *        The name of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * The name of the company that provides the product.
         * </p>
         * 
         * @param companyName
         *        The name of the company that provides the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * A description of the product.
         * </p>
         * 
         * @param description
         *        A description of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The categories assigned to the product.
         * </p>
         * 
         * @param categories
         *        The categories assigned to the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<String> categories);

        /**
         * <p>
         * The categories assigned to the product.
         * </p>
         * 
         * @param categories
         *        The categories assigned to the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(String... categories);

        /**
         * <p>
         * The URL for the page that contains more information about the product.
         * </p>
         * 
         * @param marketplaceUrl
         *        The URL for the page that contains more information about the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceUrl(String marketplaceUrl);

        /**
         * <p>
         * The URL used to activate the product.
         * </p>
         * 
         * @param activationUrl
         *        The URL used to activate the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationUrl(String activationUrl);

        /**
         * <p>
         * The resource policy associated with the product.
         * </p>
         * 
         * @param productSubscriptionResourcePolicy
         *        The resource policy associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productSubscriptionResourcePolicy(String productSubscriptionResourcePolicy);
    }

    static final class BuilderImpl implements Builder {
        private String productArn;

        private String productName;

        private String companyName;

        private String description;

        private List<String> categories = DefaultSdkAutoConstructList.getInstance();

        private String marketplaceUrl;

        private String activationUrl;

        private String productSubscriptionResourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(Product model) {
            productArn(model.productArn);
            productName(model.productName);
            companyName(model.companyName);
            description(model.description);
            categories(model.categories);
            marketplaceUrl(model.marketplaceUrl);
            activationUrl(model.activationUrl);
            productSubscriptionResourcePolicy(model.productSubscriptionResourcePolicy);
        }

        public final String getProductArn() {
            return productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        public final String getProductName() {
            return productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        public final String getCompanyName() {
            return companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getCategories() {
            return categories;
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
        }

        public final String getMarketplaceUrl() {
            return marketplaceUrl;
        }

        @Override
        public final Builder marketplaceUrl(String marketplaceUrl) {
            this.marketplaceUrl = marketplaceUrl;
            return this;
        }

        public final void setMarketplaceUrl(String marketplaceUrl) {
            this.marketplaceUrl = marketplaceUrl;
        }

        public final String getActivationUrl() {
            return activationUrl;
        }

        @Override
        public final Builder activationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
            return this;
        }

        public final void setActivationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
        }

        public final String getProductSubscriptionResourcePolicy() {
            return productSubscriptionResourcePolicy;
        }

        @Override
        public final Builder productSubscriptionResourcePolicy(String productSubscriptionResourcePolicy) {
            this.productSubscriptionResourcePolicy = productSubscriptionResourcePolicy;
            return this;
        }

        public final void setProductSubscriptionResourcePolicy(String productSubscriptionResourcePolicy) {
            this.productSubscriptionResourcePolicy = productSubscriptionResourcePolicy;
        }

        @Override
        public Product build() {
            return new Product(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
