/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnabledProductsForImportResponse extends SecurityHubResponse implements
        ToCopyableBuilder<ListEnabledProductsForImportResponse.Builder, ListEnabledProductsForImportResponse> {
    private static final SdkField<List<String>> PRODUCT_SUBSCRIPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListEnabledProductsForImportResponse::productSubscriptions))
            .setter(setter(Builder::productSubscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSubscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEnabledProductsForImportResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_SUBSCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> productSubscriptions;

    private final String nextToken;

    private ListEnabledProductsForImportResponse(BuilderImpl builder) {
        super(builder);
        this.productSubscriptions = builder.productSubscriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ProductSubscriptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProductSubscriptions() {
        return productSubscriptions != null && !(productSubscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs for the resources that represent your subscriptions to products.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductSubscriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ARNs for the resources that represent your subscriptions to products.
     */
    public List<String> productSubscriptions() {
        return productSubscriptions;
    }

    /**
     * <p>
     * The token that is required for pagination.
     * </p>
     * 
     * @return The token that is required for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productSubscriptions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnabledProductsForImportResponse)) {
            return false;
        }
        ListEnabledProductsForImportResponse other = (ListEnabledProductsForImportResponse) obj;
        return Objects.equals(productSubscriptions(), other.productSubscriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEnabledProductsForImportResponse").add("ProductSubscriptions", productSubscriptions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductSubscriptions":
            return Optional.ofNullable(clazz.cast(productSubscriptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnabledProductsForImportResponse, T> g) {
        return obj -> g.apply((ListEnabledProductsForImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnabledProductsForImportResponse> {
        /**
         * <p>
         * A list of ARNs for the resources that represent your subscriptions to products.
         * </p>
         * 
         * @param productSubscriptions
         *        A list of ARNs for the resources that represent your subscriptions to products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productSubscriptions(Collection<String> productSubscriptions);

        /**
         * <p>
         * A list of ARNs for the resources that represent your subscriptions to products.
         * </p>
         * 
         * @param productSubscriptions
         *        A list of ARNs for the resources that represent your subscriptions to products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productSubscriptions(String... productSubscriptions);

        /**
         * <p>
         * The token that is required for pagination.
         * </p>
         * 
         * @param nextToken
         *        The token that is required for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<String> productSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnabledProductsForImportResponse model) {
            super(model);
            productSubscriptions(model.productSubscriptions);
            nextToken(model.nextToken);
        }

        public final Collection<String> getProductSubscriptions() {
            return productSubscriptions;
        }

        @Override
        public final Builder productSubscriptions(Collection<String> productSubscriptions) {
            this.productSubscriptions = ProductSubscriptionArnListCopier.copy(productSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productSubscriptions(String... productSubscriptions) {
            productSubscriptions(Arrays.asList(productSubscriptions));
            return this;
        }

        public final void setProductSubscriptions(Collection<String> productSubscriptions) {
            this.productSubscriptions = ProductSubscriptionArnListCopier.copy(productSubscriptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEnabledProductsForImportResponse build() {
            return new ListEnabledProductsForImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
