/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchImportFindingsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<BatchImportFindingsResponse.Builder, BatchImportFindingsResponse> {
    private static final SdkField<Integer> FAILED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchImportFindingsResponse::failedCount)).setter(setter(Builder::failedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedCount").build()).build();

    private static final SdkField<Integer> SUCCESS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchImportFindingsResponse::successCount)).setter(setter(Builder::successCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessCount").build()).build();

    private static final SdkField<List<ImportFindingsError>> FAILED_FINDINGS_FIELD = SdkField
            .<List<ImportFindingsError>> builder(MarshallingType.LIST)
            .getter(getter(BatchImportFindingsResponse::failedFindings))
            .setter(setter(Builder::failedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportFindingsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportFindingsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_COUNT_FIELD,
            SUCCESS_COUNT_FIELD, FAILED_FINDINGS_FIELD));

    private final Integer failedCount;

    private final Integer successCount;

    private final List<ImportFindingsError> failedFindings;

    private BatchImportFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.failedCount = builder.failedCount;
        this.successCount = builder.successCount;
        this.failedFindings = builder.failedFindings;
    }

    /**
     * <p>
     * The number of findings that failed to import.
     * </p>
     * 
     * @return The number of findings that failed to import.
     */
    public Integer failedCount() {
        return failedCount;
    }

    /**
     * <p>
     * The number of findings that were successfully imported.
     * </p>
     * 
     * @return The number of findings that were successfully imported.
     */
    public Integer successCount() {
        return successCount;
    }

    /**
     * Returns true if the FailedFindings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailedFindings() {
        return failedFindings != null && !(failedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the findings that failed to import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedFindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of the findings that failed to import.
     */
    public List<ImportFindingsError> failedFindings() {
        return failedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedCount());
        hashCode = 31 * hashCode + Objects.hashCode(successCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedFindings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchImportFindingsResponse)) {
            return false;
        }
        BatchImportFindingsResponse other = (BatchImportFindingsResponse) obj;
        return Objects.equals(failedCount(), other.failedCount()) && Objects.equals(successCount(), other.successCount())
                && Objects.equals(failedFindings(), other.failedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchImportFindingsResponse").add("FailedCount", failedCount())
                .add("SuccessCount", successCount()).add("FailedFindings", failedFindings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedCount":
            return Optional.ofNullable(clazz.cast(failedCount()));
        case "SuccessCount":
            return Optional.ofNullable(clazz.cast(successCount()));
        case "FailedFindings":
            return Optional.ofNullable(clazz.cast(failedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchImportFindingsResponse, T> g) {
        return obj -> g.apply((BatchImportFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchImportFindingsResponse> {
        /**
         * <p>
         * The number of findings that failed to import.
         * </p>
         * 
         * @param failedCount
         *        The number of findings that failed to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedCount(Integer failedCount);

        /**
         * <p>
         * The number of findings that were successfully imported.
         * </p>
         * 
         * @param successCount
         *        The number of findings that were successfully imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successCount(Integer successCount);

        /**
         * <p>
         * The list of the findings that failed to import.
         * </p>
         * 
         * @param failedFindings
         *        The list of the findings that failed to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedFindings(Collection<ImportFindingsError> failedFindings);

        /**
         * <p>
         * The list of the findings that failed to import.
         * </p>
         * 
         * @param failedFindings
         *        The list of the findings that failed to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedFindings(ImportFindingsError... failedFindings);

        /**
         * <p>
         * The list of the findings that failed to import.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImportFindingsError>.Builder} avoiding the
         * need to create one manually via {@link List<ImportFindingsError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportFindingsError>.Builder#build()} is called immediately
         * and its result is passed to {@link #failedFindings(List<ImportFindingsError>)}.
         * 
         * @param failedFindings
         *        a consumer that will call methods on {@link List<ImportFindingsError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedFindings(List<ImportFindingsError>)
         */
        Builder failedFindings(Consumer<ImportFindingsError.Builder>... failedFindings);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private Integer failedCount;

        private Integer successCount;

        private List<ImportFindingsError> failedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchImportFindingsResponse model) {
            super(model);
            failedCount(model.failedCount);
            successCount(model.successCount);
            failedFindings(model.failedFindings);
        }

        public final Integer getFailedCount() {
            return failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        public final Integer getSuccessCount() {
            return successCount;
        }

        @Override
        public final Builder successCount(Integer successCount) {
            this.successCount = successCount;
            return this;
        }

        public final void setSuccessCount(Integer successCount) {
            this.successCount = successCount;
        }

        public final Collection<ImportFindingsError.Builder> getFailedFindings() {
            return failedFindings != null ? failedFindings.stream().map(ImportFindingsError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedFindings(Collection<ImportFindingsError> failedFindings) {
            this.failedFindings = ImportFindingsErrorListCopier.copy(failedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedFindings(ImportFindingsError... failedFindings) {
            failedFindings(Arrays.asList(failedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedFindings(Consumer<ImportFindingsError.Builder>... failedFindings) {
            failedFindings(Stream.of(failedFindings).map(c -> ImportFindingsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedFindings(Collection<ImportFindingsError.BuilderImpl> failedFindings) {
            this.failedFindings = ImportFindingsErrorListCopier.copyFromBuilder(failedFindings);
        }

        @Override
        public BatchImportFindingsResponse build() {
            return new BatchImportFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
