/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchImportFindingsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<BatchImportFindingsRequest.Builder, BatchImportFindingsRequest> {
    private static final SdkField<List<AwsSecurityFinding>> FINDINGS_FIELD = SdkField
            .<List<AwsSecurityFinding>> builder(MarshallingType.LIST)
            .getter(getter(BatchImportFindingsRequest::findings))
            .setter(setter(Builder::findings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Findings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsSecurityFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsSecurityFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD));

    private final List<AwsSecurityFinding> findings;

    private BatchImportFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
    }

    /**
     * Returns true if the Findings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFindings() {
        return findings != null && !(findings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of findings to import. To successfully import a finding, it must follow the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security
     * Finding Format</a>. Maximum of 100 findings per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of findings to import. To successfully import a finding, it must follow the <a
     *         href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS
     *         Security Finding Format</a>. Maximum of 100 findings per request.
     */
    public List<AwsSecurityFinding> findings() {
        return findings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchImportFindingsRequest)) {
            return false;
        }
        BatchImportFindingsRequest other = (BatchImportFindingsRequest) obj;
        return Objects.equals(findings(), other.findings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchImportFindingsRequest").add("Findings", findings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Findings":
            return Optional.ofNullable(clazz.cast(findings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchImportFindingsRequest, T> g) {
        return obj -> g.apply((BatchImportFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchImportFindingsRequest> {
        /**
         * <p>
         * A list of findings to import. To successfully import a finding, it must follow the <a
         * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security
         * Finding Format</a>. Maximum of 100 findings per request.
         * </p>
         * 
         * @param findings
         *        A list of findings to import. To successfully import a finding, it must follow the <a
         *        href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS
         *        Security Finding Format</a>. Maximum of 100 findings per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Collection<AwsSecurityFinding> findings);

        /**
         * <p>
         * A list of findings to import. To successfully import a finding, it must follow the <a
         * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security
         * Finding Format</a>. Maximum of 100 findings per request.
         * </p>
         * 
         * @param findings
         *        A list of findings to import. To successfully import a finding, it must follow the <a
         *        href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS
         *        Security Finding Format</a>. Maximum of 100 findings per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(AwsSecurityFinding... findings);

        /**
         * <p>
         * A list of findings to import. To successfully import a finding, it must follow the <a
         * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security
         * Finding Format</a>. Maximum of 100 findings per request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsSecurityFinding>.Builder} avoiding the
         * need to create one manually via {@link List<AwsSecurityFinding>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsSecurityFinding>.Builder#build()} is called immediately
         * and its result is passed to {@link #findings(List<AwsSecurityFinding>)}.
         * 
         * @param findings
         *        a consumer that will call methods on {@link List<AwsSecurityFinding>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findings(List<AwsSecurityFinding>)
         */
        Builder findings(Consumer<AwsSecurityFinding.Builder>... findings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<AwsSecurityFinding> findings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchImportFindingsRequest model) {
            super(model);
            findings(model.findings);
        }

        public final Collection<AwsSecurityFinding.Builder> getFindings() {
            return findings != null ? findings.stream().map(AwsSecurityFinding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findings(Collection<AwsSecurityFinding> findings) {
            this.findings = AwsSecurityFindingListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(AwsSecurityFinding... findings) {
            findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<AwsSecurityFinding.Builder>... findings) {
            findings(Stream.of(findings).map(c -> AwsSecurityFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFindings(Collection<AwsSecurityFinding.BuilderImpl> findings) {
            this.findings = AwsSecurityFindingListCopier.copyFromBuilder(findings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchImportFindingsRequest build() {
            return new BatchImportFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
