/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * IAM access key details related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamAccessKeyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamAccessKeyDetails.Builder, AwsIamAccessKeyDetails> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamAccessKeyDetails::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamAccessKeyDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamAccessKeyDetails::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamAccessKeyDetails::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamAccessKeyDetails::principalType)).setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final SdkField<String> PRINCIPAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsIamAccessKeyDetails::principalName)).setter(setter(Builder::principalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, STATUS_FIELD,
            CREATED_AT_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String status;

    private final String createdAt;

    private final String principalId;

    private final String principalType;

    private final String principalName;

    private AwsIamAccessKeyDetails(BuilderImpl builder) {
        this.userName = builder.userName;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.principalName = builder.principalName;
    }

    /**
     * <p>
     * The user associated with the IAM access key related to a finding.
     * </p>
     * <p>
     * The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter because
     * access keys can also be assigned to principals that are not IAM users.
     * </p>
     * 
     * @return The user associated with the IAM access key related to a finding.</p>
     *         <p>
     *         The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter
     *         because access keys can also be assigned to principals that are not IAM users.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AwsIamAccessKeyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the IAM access key related to a finding.
     * @see AwsIamAccessKeyStatus
     */
    public AwsIamAccessKeyStatus status() {
        return AwsIamAccessKeyStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AwsIamAccessKeyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the IAM access key related to a finding.
     * @see AwsIamAccessKeyStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation date/time of the IAM access key related to a finding.
     * </p>
     * 
     * @return The creation date/time of the IAM access key related to a finding.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the principal associated with an access key.
     * </p>
     * 
     * @return The ID of the principal associated with an access key.
     */
    public String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The type of principal associated with an access key.
     * </p>
     * 
     * @return The type of principal associated with an access key.
     */
    public String principalType() {
        return principalType;
    }

    /**
     * <p>
     * The name of the principal.
     * </p>
     * 
     * @return The name of the principal.
     */
    public String principalName() {
        return principalName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(principalType());
        hashCode = 31 * hashCode + Objects.hashCode(principalName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamAccessKeyDetails)) {
            return false;
        }
        AwsIamAccessKeyDetails other = (AwsIamAccessKeyDetails) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(principalType(), other.principalType())
                && Objects.equals(principalName(), other.principalName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsIamAccessKeyDetails").add("UserName", userName()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("PrincipalId", principalId()).add("PrincipalType", principalType())
                .add("PrincipalName", principalName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalType()));
        case "PrincipalName":
            return Optional.ofNullable(clazz.cast(principalName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamAccessKeyDetails, T> g) {
        return obj -> g.apply((AwsIamAccessKeyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamAccessKeyDetails> {
        /**
         * <p>
         * The user associated with the IAM access key related to a finding.
         * </p>
         * <p>
         * The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter because
         * access keys can also be assigned to principals that are not IAM users.
         * </p>
         * 
         * @param userName
         *        The user associated with the IAM access key related to a finding.</p>
         *        <p>
         *        The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter
         *        because access keys can also be assigned to principals that are not IAM users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The status of the IAM access key related to a finding.
         * </p>
         * 
         * @param status
         *        The status of the IAM access key related to a finding.
         * @see AwsIamAccessKeyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsIamAccessKeyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the IAM access key related to a finding.
         * </p>
         * 
         * @param status
         *        The status of the IAM access key related to a finding.
         * @see AwsIamAccessKeyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsIamAccessKeyStatus
         */
        Builder status(AwsIamAccessKeyStatus status);

        /**
         * <p>
         * The creation date/time of the IAM access key related to a finding.
         * </p>
         * 
         * @param createdAt
         *        The creation date/time of the IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The ID of the principal associated with an access key.
         * </p>
         * 
         * @param principalId
         *        The ID of the principal associated with an access key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The type of principal associated with an access key.
         * </p>
         * 
         * @param principalType
         *        The type of principal associated with an access key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The name of the principal.
         * </p>
         * 
         * @param principalName
         *        The name of the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalName(String principalName);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String status;

        private String createdAt;

        private String principalId;

        private String principalType;

        private String principalName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamAccessKeyDetails model) {
            userName(model.userName);
            status(model.status);
            createdAt(model.createdAt);
            principalId(model.principalId);
            principalType(model.principalType);
            principalName(model.principalName);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AwsIamAccessKeyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        public final String getPrincipalName() {
            return principalName;
        }

        @Override
        public final Builder principalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public final void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        @Override
        public AwsIamAccessKeyDetails build() {
            return new AwsIamAccessKeyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
