/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.CreateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.CreateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.CreateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.CreateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeHubRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeHubResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMembersRequest;
import software.amazon.awssdk.services.securityhub.model.GetMembersResponse;
import software.amazon.awssdk.services.securityhub.model.InviteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.InviteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.ListMembersRequest;
import software.amazon.awssdk.services.securityhub.model.ListMembersResponse;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityhub.model.TagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.TagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlResponse;
import software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher;

/**
 * Service client for accessing AWS SecurityHub asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Security Hub provides you with a comprehensive view of the security state of your AWS environment and resources. It
 * also provides you with the compliance status of your environment based on CIS AWS Foundations compliance checks.
 * Security Hub collects security data from AWS accounts, services, and integrated third-party products and helps you
 * analyze security trends in your environment to identify the highest priority security issues. For more information
 * about Security Hub, see the <i> <a
 * href="https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html">AWS Security Hub User
 * Guide</a> </i>.
 * </p>
 * <p>
 * When you use operations in the Security Hub API, the requests are executed only in the AWS Region that is currently
 * active or in the specific AWS Region that you specify in your request. Any configuration or settings change that
 * results from the operation is applied only to that Region. To make the same change in other Regions, execute the same
 * command for each Region to apply the change to. For example, if your Region is set to <code>us-west-2</code>, when
 * you use <code>CreateMembers</code> to add a member account to Security Hub, the association of the member account
 * with the master account is created only in the us-west-2 Region. Security Hub must be enabled for the member account
 * in the same Region that the invite was sent from.
 * </p>
 * <p>
 * The following throttling limits apply to using Security Hub API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>GetFindings</code> - RateLimit of 3 requests per second, and a BurstLimit of 6 requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateFindings</code> - RateLimit of 1 request per second, and a BurstLimit of 5 requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * All other operations - RateLimit of 10 request per second, and a BurstLimit of 30 requests per second.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SecurityHubAsyncClient extends SdkClient {
    String SERVICE_NAME = "securityhub";

    /**
     * Create a {@link SecurityHubAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecurityHubAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecurityHubAsyncClient}.
     */
    static SecurityHubAsyncClientBuilder builder() {
        return new DefaultSecurityHubAsyncClientBuilder();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub master account that the
     * invitation was sent from. When the member account accepts the invitation, permission is granted to the master
     * account to view findings generated in the member account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.AcceptInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptInvitationResponse> acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub master account that the
     * invitation was sent from. When the member account accepts the invitation, permission is granted to the master
     * account to view findings generated in the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptInvitationRequest#builder()}
     * </p>
     *
     * @param acceptInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptInvitationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.AcceptInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptInvitationResponse> acceptInvitation(
            Consumer<AcceptInvitationRequest.Builder> acceptInvitationRequest) {
        return acceptInvitation(AcceptInvitationRequest.builder().applyMutation(acceptInvitationRequest).build());
    }

    /**
     * <p>
     * Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>. For more information,
     * see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Standards
     * Supported in AWS Security Hub</a>.
     * </p>
     *
     * @param batchDisableStandardsRequest
     * @return A Java Future containing the result of the BatchDisableStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchDisableStandards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisableStandardsResponse> batchDisableStandards(
            BatchDisableStandardsRequest batchDisableStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>. For more information,
     * see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Standards
     * Supported in AWS Security Hub</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisableStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDisableStandardsRequest#builder()}
     * </p>
     *
     * @param batchDisableStandardsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDisableStandardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDisableStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchDisableStandards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisableStandardsResponse> batchDisableStandards(
            Consumer<BatchDisableStandardsRequest.Builder> batchDisableStandardsRequest) {
        return batchDisableStandards(BatchDisableStandardsRequest.builder().applyMutation(batchDisableStandardsRequest).build());
    }

    /**
     * <p>
     * Enables the standards specified by the provided <code>standardsArn</code>. In this release, only CIS AWS
     * Foundations standards are supported. For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Standards Supported in
     * AWS Security Hub</a>.
     * </p>
     *
     * @param batchEnableStandardsRequest
     * @return A Java Future containing the result of the BatchEnableStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchEnableStandards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchEnableStandardsResponse> batchEnableStandards(
            BatchEnableStandardsRequest batchEnableStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the standards specified by the provided <code>standardsArn</code>. In this release, only CIS AWS
     * Foundations standards are supported. For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Standards Supported in
     * AWS Security Hub</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEnableStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchEnableStandardsRequest#builder()}
     * </p>
     *
     * @param batchEnableStandardsRequest
     *        A {@link Consumer} that will call methods on {@link BatchEnableStandardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchEnableStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchEnableStandards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchEnableStandardsResponse> batchEnableStandards(
            Consumer<BatchEnableStandardsRequest.Builder> batchEnableStandardsRequest) {
        return batchEnableStandards(BatchEnableStandardsRequest.builder().applyMutation(batchEnableStandardsRequest).build());
    }

    /**
     * <p>
     * Imports security findings generated from an integrated third-party product into Security Hub. This action is
     * requested by the integrated product to import its findings into Security Hub. The maximum allowed size for a
     * finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     * </p>
     *
     * @param batchImportFindingsRequest
     * @return A Java Future containing the result of the BatchImportFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchImportFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchImportFindingsResponse> batchImportFindings(
            BatchImportFindingsRequest batchImportFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports security findings generated from an integrated third-party product into Security Hub. This action is
     * requested by the integrated product to import its findings into Security Hub. The maximum allowed size for a
     * finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchImportFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchImportFindingsRequest#builder()}
     * </p>
     *
     * @param batchImportFindingsRequest
     *        A {@link Consumer} that will call methods on {@link BatchImportFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchImportFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchImportFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchImportFindingsResponse> batchImportFindings(
            Consumer<BatchImportFindingsRequest.Builder> batchImportFindingsRequest) {
        return batchImportFindings(BatchImportFindingsRequest.builder().applyMutation(batchImportFindingsRequest).build());
    }

    /**
     * <p>
     * Creates a custom action target in Security Hub. You can use custom actions on findings and insights in Security
     * Hub to trigger target actions in Amazon CloudWatch Events.
     * </p>
     *
     * @param createActionTargetRequest
     * @return A Java Future containing the result of the CreateActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateActionTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateActionTargetResponse> createActionTarget(CreateActionTargetRequest createActionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom action target in Security Hub. You can use custom actions on findings and insights in Security
     * Hub to trigger target actions in Amazon CloudWatch Events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateActionTargetRequest#builder()}
     * </p>
     *
     * @param createActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link CreateActionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateActionTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateActionTargetResponse> createActionTarget(
            Consumer<CreateActionTargetRequest.Builder> createActionTargetRequest) {
        return createActionTarget(CreateActionTargetRequest.builder().applyMutation(createActionTargetRequest).build());
    }

    /**
     * <p>
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security
     * issue that requires attention or remediation. Use the <code>GroupByAttribute</code> to group the related findings
     * in the insight.
     * </p>
     *
     * @param createInsightRequest
     * @return A Java Future containing the result of the CreateInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateInsight
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInsightResponse> createInsight(CreateInsightRequest createInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security
     * issue that requires attention or remediation. Use the <code>GroupByAttribute</code> to group the related findings
     * in the insight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInsightRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInsightRequest#builder()}
     * </p>
     *
     * @param createInsightRequest
     *        A {@link Consumer} that will call methods on {@link CreateInsightRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateInsight
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInsightResponse> createInsight(Consumer<CreateInsightRequest.Builder> createInsightRequest) {
        return createInsight(CreateInsightRequest.builder().applyMutation(createInsightRequest).build());
    }

    /**
     * <p>
     * Creates a member association in Security Hub between the specified accounts and the account used to make the
     * request, which is the master account. To successfully create a member, you must use this action from an account
     * that already has Security Hub enabled. You can use the <a>EnableSecurityHub</a> to enable Security Hub.
     * </p>
     * <p>
     * After you use <code>CreateMembers</code> to create member account associations in Security Hub, you need to use
     * the <a>InviteMembers</a> action, which invites the accounts to enable Security Hub and become member accounts in
     * Security Hub. If the invitation is accepted by the account owner, the account becomes a member account in
     * Security Hub, and a permission policy is added that permits the master account to view the findings generated in
     * the member account. When Security Hub is enabled in the invited account, findings start being sent to both the
     * member and master accounts.
     * </p>
     * <p>
     * You can remove the association between the master and member accounts by using the
     * <a>DisassociateFromMasterAccount</a> or <a>DisassociateMembers</a> operation.
     * </p>
     *
     * @param createMembersRequest
     * @return A Java Future containing the result of the CreateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMembersResponse> createMembers(CreateMembersRequest createMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a member association in Security Hub between the specified accounts and the account used to make the
     * request, which is the master account. To successfully create a member, you must use this action from an account
     * that already has Security Hub enabled. You can use the <a>EnableSecurityHub</a> to enable Security Hub.
     * </p>
     * <p>
     * After you use <code>CreateMembers</code> to create member account associations in Security Hub, you need to use
     * the <a>InviteMembers</a> action, which invites the accounts to enable Security Hub and become member accounts in
     * Security Hub. If the invitation is accepted by the account owner, the account becomes a member account in
     * Security Hub, and a permission policy is added that permits the master account to view the findings generated in
     * the member account. When Security Hub is enabled in the invited account, findings start being sent to both the
     * member and master accounts.
     * </p>
     * <p>
     * You can remove the association between the master and member accounts by using the
     * <a>DisassociateFromMasterAccount</a> or <a>DisassociateMembers</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembersRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMembersRequest#builder()}
     * </p>
     *
     * @param createMembersRequest
     *        A {@link Consumer} that will call methods on {@link CreateMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMembersResponse> createMembers(Consumer<CreateMembersRequest.Builder> createMembersRequest) {
        return createMembers(CreateMembersRequest.builder().applyMutation(createMembersRequest).build());
    }

    /**
     * <p>
     * Declines invitations to become a member account.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeclineInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeclineInvitationsResponse> declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Declines invitations to become a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeclineInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeclineInvitationsRequest#builder()}
     * </p>
     *
     * @param declineInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeclineInvitationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeclineInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeclineInvitationsResponse> declineInvitations(
            Consumer<DeclineInvitationsRequest.Builder> declineInvitationsRequest) {
        return declineInvitations(DeclineInvitationsRequest.builder().applyMutation(declineInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes a custom action target from Security Hub. Deleting a custom action target doesn't affect any findings or
     * insights that were already sent to Amazon CloudWatch Events using the custom action.
     * </p>
     *
     * @param deleteActionTargetRequest
     * @return A Java Future containing the result of the DeleteActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteActionTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteActionTargetResponse> deleteActionTarget(DeleteActionTargetRequest deleteActionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom action target from Security Hub. Deleting a custom action target doesn't affect any findings or
     * insights that were already sent to Amazon CloudWatch Events using the custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteActionTargetRequest#builder()}
     * </p>
     *
     * @param deleteActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteActionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteActionTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteActionTargetResponse> deleteActionTarget(
            Consumer<DeleteActionTargetRequest.Builder> deleteActionTargetRequest) {
        return deleteActionTarget(DeleteActionTargetRequest.builder().applyMutation(deleteActionTargetRequest).build());
    }

    /**
     * <p>
     * Deletes the insight specified by the <code>InsightArn</code>.
     * </p>
     *
     * @param deleteInsightRequest
     * @return A Java Future containing the result of the DeleteInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteInsight
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInsightResponse> deleteInsight(DeleteInsightRequest deleteInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the insight specified by the <code>InsightArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInsightRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInsightRequest#builder()}
     * </p>
     *
     * @param deleteInsightRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInsightRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteInsight
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInsightResponse> deleteInsight(Consumer<DeleteInsightRequest.Builder> deleteInsightRequest) {
        return deleteInsight(DeleteInsightRequest.builder().applyMutation(deleteInsightRequest).build());
    }

    /**
     * <p>
     * Deletes invitations received by the AWS account to become a member account.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInvitationsResponse> deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes invitations received by the AWS account to become a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvitationsRequest#builder()}
     * </p>
     *
     * @param deleteInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInvitationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInvitationsResponse> deleteInvitations(
            Consumer<DeleteInvitationsRequest.Builder> deleteInvitationsRequest) {
        return deleteInvitations(DeleteInvitationsRequest.builder().applyMutation(deleteInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified member accounts from Security Hub.
     * </p>
     *
     * @param deleteMembersRequest
     * @return A Java Future containing the result of the DeleteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMembersResponse> deleteMembers(DeleteMembersRequest deleteMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified member accounts from Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMembersRequest#builder()}
     * </p>
     *
     * @param deleteMembersRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMembersResponse> deleteMembers(Consumer<DeleteMembersRequest.Builder> deleteMembersRequest) {
        return deleteMembers(DeleteMembersRequest.builder().applyMutation(deleteMembersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     *
     * @param describeActionTargetsRequest
     * @return A Java Future containing the result of the DescribeActionTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeActionTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeActionTargetsResponse> describeActionTargets(
            DescribeActionTargetsRequest describeActionTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActionTargetsRequest#builder()}
     * </p>
     *
     * @param describeActionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActionTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeActionTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeActionTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeActionTargetsResponse> describeActionTargets(
            Consumer<DescribeActionTargetsRequest.Builder> describeActionTargetsRequest) {
        return describeActionTargets(DescribeActionTargetsRequest.builder().applyMutation(describeActionTargetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher publisher = client.describeActionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher publisher = client.describeActionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeActionTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeActionTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsPublisher describeActionTargetsPaginator(
            DescribeActionTargetsRequest describeActionTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher publisher = client.describeActionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher publisher = client.describeActionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActionTargetsRequest#builder()}
     * </p>
     *
     * @param describeActionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActionTargetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeActionTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsPublisher describeActionTargetsPaginator(
            Consumer<DescribeActionTargetsRequest.Builder> describeActionTargetsRequest) {
        return describeActionTargetsPaginator(DescribeActionTargetsRequest.builder().applyMutation(describeActionTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you
     * enabled Security Hub.
     * </p>
     *
     * @param describeHubRequest
     * @return A Java Future containing the result of the DescribeHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeHub
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeHubResponse> describeHub(DescribeHubRequest describeHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you
     * enabled Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHubRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeHubRequest#builder()}
     * </p>
     *
     * @param describeHubRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHubRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeHub
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeHubResponse> describeHub(Consumer<DescribeHubRequest.Builder> describeHubRequest) {
        return describeHub(DescribeHubRequest.builder().applyMutation(describeHubRequest).build());
    }

    /**
     * <p>
     * Returns information about the products available that you can subscribe to and integrate with Security Hub to
     * consolidate findings.
     * </p>
     *
     * @param describeProductsRequest
     * @return A Java Future containing the result of the DescribeProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeProductsResponse> describeProducts(DescribeProductsRequest describeProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the products available that you can subscribe to and integrate with Security Hub to
     * consolidate findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductsRequest#builder()}
     * </p>
     *
     * @param describeProductsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeProductsResponse> describeProducts(
            Consumer<DescribeProductsRequest.Builder> describeProductsRequest) {
        return describeProducts(DescribeProductsRequest.builder().applyMutation(describeProductsRequest).build());
    }

    /**
     * <p>
     * Returns information about the products available that you can subscribe to and integrate with Security Hub to
     * consolidate findings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher publisher = client.describeProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher publisher = client.describeProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsPublisher describeProductsPaginator(DescribeProductsRequest describeProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the products available that you can subscribe to and integrate with Security Hub to
     * consolidate findings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher publisher = client.describeProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher publisher = client.describeProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductsRequest#builder()}
     * </p>
     *
     * @param describeProductsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsPublisher describeProductsPaginator(Consumer<DescribeProductsRequest.Builder> describeProductsRequest) {
        return describeProductsPaginator(DescribeProductsRequest.builder().applyMutation(describeProductsRequest).build());
    }

    /**
     * <p>
     * Returns a list of compliance standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     *
     * @param describeStandardsControlsRequest
     * @return A Java Future containing the result of the DescribeStandardsControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandardsControls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStandardsControlsResponse> describeStandardsControls(
            DescribeStandardsControlsRequest describeStandardsControlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of compliance standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStandardsControlsRequest#builder()}
     * </p>
     *
     * @param describeStandardsControlsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsControlsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStandardsControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandardsControls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStandardsControlsResponse> describeStandardsControls(
            Consumer<DescribeStandardsControlsRequest.Builder> describeStandardsControlsRequest) {
        return describeStandardsControls(DescribeStandardsControlsRequest.builder()
                .applyMutation(describeStandardsControlsRequest).build());
    }

    /**
     * <p>
     * Disables the integration of the specified product with Security Hub. Findings from that product are no longer
     * sent to Security Hub after the integration is disabled.
     * </p>
     *
     * @param disableImportFindingsForProductRequest
     * @return A Java Future containing the result of the DisableImportFindingsForProduct operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableImportFindingsForProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableImportFindingsForProductResponse> disableImportFindingsForProduct(
            DisableImportFindingsForProductRequest disableImportFindingsForProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the integration of the specified product with Security Hub. Findings from that product are no longer
     * sent to Security Hub after the integration is disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableImportFindingsForProductRequest.Builder}
     * avoiding the need to create one manually via {@link DisableImportFindingsForProductRequest#builder()}
     * </p>
     *
     * @param disableImportFindingsForProductRequest
     *        A {@link Consumer} that will call methods on {@link DisableImportFindingsForProductRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableImportFindingsForProduct operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableImportFindingsForProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableImportFindingsForProductResponse> disableImportFindingsForProduct(
            Consumer<DisableImportFindingsForProductRequest.Builder> disableImportFindingsForProductRequest) {
        return disableImportFindingsForProduct(DisableImportFindingsForProductRequest.builder()
                .applyMutation(disableImportFindingsForProductRequest).build());
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub. When you disable Security Hub for a
     * master account, it doesn't disable Security Hub for any associated member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and can't be recovered. Any standards that were enabled are disabled, and your master
     * and member account associations are removed. If you want to save your existing findings, you must export them
     * before you disable Security Hub.
     * </p>
     *
     * @param disableSecurityHubRequest
     * @return A Java Future containing the result of the DisableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableSecurityHub
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableSecurityHubResponse> disableSecurityHub(DisableSecurityHubRequest disableSecurityHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub. When you disable Security Hub for a
     * master account, it doesn't disable Security Hub for any associated member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and can't be recovered. Any standards that were enabled are disabled, and your master
     * and member account associations are removed. If you want to save your existing findings, you must export them
     * before you disable Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableSecurityHubRequest.Builder} avoiding the
     * need to create one manually via {@link DisableSecurityHubRequest#builder()}
     * </p>
     *
     * @param disableSecurityHubRequest
     *        A {@link Consumer} that will call methods on {@link DisableSecurityHubRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableSecurityHub
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableSecurityHubResponse> disableSecurityHub(
            Consumer<DisableSecurityHubRequest.Builder> disableSecurityHubRequest) {
        return disableSecurityHub(DisableSecurityHubRequest.builder().applyMutation(disableSecurityHubRequest).build());
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub. When you disable Security Hub for a
     * master account, it doesn't disable Security Hub for any associated member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and can't be recovered. Any standards that were enabled are disabled, and your master
     * and member account associations are removed. If you want to save your existing findings, you must export them
     * before you disable Security Hub.
     * </p>
     *
     * @return A Java Future containing the result of the DisableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableSecurityHub
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableSecurityHubResponse> disableSecurityHub() {
        return disableSecurityHub(DisableSecurityHubRequest.builder().build());
    }

    /**
     * <p>
     * Disassociates the current Security Hub member account from the associated master account.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateFromMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the current Security Hub member account from the associated master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFromMasterAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFromMasterAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromMasterAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateFromMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            Consumer<DisassociateFromMasterAccountRequest.Builder> disassociateFromMasterAccountRequest) {
        return disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.builder()
                .applyMutation(disassociateFromMasterAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified member accounts from the associated master account.
     * </p>
     *
     * @param disassociateMembersRequest
     * @return A Java Future containing the result of the DisassociateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMembersResponse> disassociateMembers(
            DisassociateMembersRequest disassociateMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified member accounts from the associated master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMembersRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMembersRequest#builder()}
     * </p>
     *
     * @param disassociateMembersRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMembersResponse> disassociateMembers(
            Consumer<DisassociateMembersRequest.Builder> disassociateMembersRequest) {
        return disassociateMembers(DisassociateMembersRequest.builder().applyMutation(disassociateMembersRequest).build());
    }

    /**
     * <p>
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security
     * Hub. When you enable a product integration, a permission policy that grants permission for the product to send
     * findings to Security Hub is applied.
     * </p>
     *
     * @param enableImportFindingsForProductRequest
     * @return A Java Future containing the result of the EnableImportFindingsForProduct operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableImportFindingsForProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableImportFindingsForProductResponse> enableImportFindingsForProduct(
            EnableImportFindingsForProductRequest enableImportFindingsForProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security
     * Hub. When you enable a product integration, a permission policy that grants permission for the product to send
     * findings to Security Hub is applied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableImportFindingsForProductRequest.Builder}
     * avoiding the need to create one manually via {@link EnableImportFindingsForProductRequest#builder()}
     * </p>
     *
     * @param enableImportFindingsForProductRequest
     *        A {@link Consumer} that will call methods on {@link EnableImportFindingsForProductRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableImportFindingsForProduct operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableImportFindingsForProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableImportFindingsForProductResponse> enableImportFindingsForProduct(
            Consumer<EnableImportFindingsForProductRequest.Builder> enableImportFindingsForProductRequest) {
        return enableImportFindingsForProduct(EnableImportFindingsForProductRequest.builder()
                .applyMutation(enableImportFindingsForProductRequest).build());
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request. Enabling
     * Security Hub also enables the CIS AWS Foundations standard. When you enable Security Hub, you grant to Security
     * Hub the permissions necessary to gather findings from AWS Config, Amazon GuardDuty, Amazon Inspector, and Amazon
     * Macie. To learn more, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">Setting Up AWS
     * Security Hub</a>.
     * </p>
     *
     * @param enableSecurityHubRequest
     * @return A Java Future containing the result of the EnableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action specified in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableSecurityHub
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableSecurityHubResponse> enableSecurityHub(EnableSecurityHubRequest enableSecurityHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request. Enabling
     * Security Hub also enables the CIS AWS Foundations standard. When you enable Security Hub, you grant to Security
     * Hub the permissions necessary to gather findings from AWS Config, Amazon GuardDuty, Amazon Inspector, and Amazon
     * Macie. To learn more, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">Setting Up AWS
     * Security Hub</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSecurityHubRequest.Builder} avoiding the need
     * to create one manually via {@link EnableSecurityHubRequest#builder()}
     * </p>
     *
     * @param enableSecurityHubRequest
     *        A {@link Consumer} that will call methods on {@link EnableSecurityHubRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action specified in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableSecurityHub
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableSecurityHubResponse> enableSecurityHub(
            Consumer<EnableSecurityHubRequest.Builder> enableSecurityHubRequest) {
        return enableSecurityHub(EnableSecurityHubRequest.builder().applyMutation(enableSecurityHubRequest).build());
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request. Enabling
     * Security Hub also enables the CIS AWS Foundations standard. When you enable Security Hub, you grant to Security
     * Hub the permissions necessary to gather findings from AWS Config, Amazon GuardDuty, Amazon Inspector, and Amazon
     * Macie. To learn more, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">Setting Up AWS
     * Security Hub</a>.
     * </p>
     *
     * @return A Java Future containing the result of the EnableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action specified in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableSecurityHub
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableSecurityHubResponse> enableSecurityHub() {
        return enableSecurityHub(EnableSecurityHubRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     *
     * @param getEnabledStandardsRequest
     * @return A Java Future containing the result of the GetEnabledStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetEnabledStandards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnabledStandardsResponse> getEnabledStandards(
            GetEnabledStandardsRequest getEnabledStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledStandardsRequest#builder()}
     * </p>
     *
     * @param getEnabledStandardsRequest
     *        A {@link Consumer} that will call methods on {@link GetEnabledStandardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnabledStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetEnabledStandards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnabledStandardsResponse> getEnabledStandards(
            Consumer<GetEnabledStandardsRequest.Builder> getEnabledStandardsRequest) {
        return getEnabledStandards(GetEnabledStandardsRequest.builder().applyMutation(getEnabledStandardsRequest).build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     *
     * @param getFindingsRequest
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) {
        return getFindings(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     *
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings() {
        return getFindings(GetFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsPublisher getFindingsPaginator() {
        return getFindingsPaginator(GetFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @param getFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsPublisher getFindingsPaginator(GetFindingsRequest getFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsPublisher getFindingsPaginator(Consumer<GetFindingsRequest.Builder> getFindingsRequest) {
        return getFindingsPaginator(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Lists the results of the Security Hub insight that the insight ARN specifies.
     * </p>
     *
     * @param getInsightResultsRequest
     * @return A Java Future containing the result of the GetInsightResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsightResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInsightResultsResponse> getInsightResults(GetInsightResultsRequest getInsightResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the results of the Security Hub insight that the insight ARN specifies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetInsightResultsRequest#builder()}
     * </p>
     *
     * @param getInsightResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightResultsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInsightResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsightResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInsightResultsResponse> getInsightResults(
            Consumer<GetInsightResultsRequest.Builder> getInsightResultsRequest) {
        return getInsightResults(GetInsightResultsRequest.builder().applyMutation(getInsightResultsRequest).build());
    }

    /**
     * <p>
     * Lists and describes insights that insight ARNs specify.
     * </p>
     *
     * @param getInsightsRequest
     * @return A Java Future containing the result of the GetInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsights
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInsightsResponse> getInsights(GetInsightsRequest getInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists and describes insights that insight ARNs specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsights
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInsightsResponse> getInsights(Consumer<GetInsightsRequest.Builder> getInsightsRequest) {
        return getInsights(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * Lists and describes insights that insight ARNs specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher publisher = client.getInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher publisher = client.getInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)} operation.</b>
     * </p>
     *
     * @param getInsightsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsights
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsPublisher getInsightsPaginator(GetInsightsRequest getInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists and describes insights that insight ARNs specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher publisher = client.getInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher publisher = client.getInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsights
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsPublisher getInsightsPaginator(Consumer<GetInsightsRequest.Builder> getInsightsRequest) {
        return getInsightsPaginator(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInvitationsCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            GetInvitationsCountRequest getInvitationsCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationsCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetInvitationsCountRequest#builder()}
     * </p>
     *
     * @param getInvitationsCountRequest
     *        A {@link Consumer} that will call methods on {@link GetInvitationsCountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInvitationsCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            Consumer<GetInvitationsCountRequest.Builder> getInvitationsCountRequest) {
        return getInvitationsCount(GetInvitationsCountRequest.builder().applyMutation(getInvitationsCountRequest).build());
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     *
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInvitationsCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount() {
        return getInvitationsCount(GetInvitationsCountRequest.builder().build());
    }

    /**
     * <p>
     * Provides the details for the Security Hub master account to the current member account.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details for the Security Hub master account to the current member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMasterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetMasterAccountRequest#builder()}
     * </p>
     *
     * @param getMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetMasterAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount(
            Consumer<GetMasterAccountRequest.Builder> getMasterAccountRequest) {
        return getMasterAccount(GetMasterAccountRequest.builder().applyMutation(getMasterAccountRequest).build());
    }

    /**
     * <p>
     * Provides the details for the Security Hub master account to the current member account.
     * </p>
     *
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount() {
        return getMasterAccount(GetMasterAccountRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details on the Security Hub member accounts that the account IDs specify.
     * </p>
     *
     * @param getMembersRequest
     * @return A Java Future containing the result of the GetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMembersResponse> getMembers(GetMembersRequest getMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details on the Security Hub member accounts that the account IDs specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembersRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembersRequest#builder()}
     * </p>
     *
     * @param getMembersRequest
     *        A {@link Consumer} that will call methods on {@link GetMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMembersResponse> getMembers(Consumer<GetMembersRequest.Builder> getMembersRequest) {
        return getMembers(GetMembersRequest.builder().applyMutation(getMembersRequest).build());
    }

    /**
     * <p>
     * Invites other AWS accounts to become member accounts for the Security Hub master account that the invitation is
     * sent from. Before you can use this action to invite a member, you must first create the member account in
     * Security Hub by using the <a>CreateMembers</a> action. When the account owner accepts the invitation to become a
     * member account and enables Security Hub, the master account can view the findings generated from member account.
     * </p>
     *
     * @param inviteMembersRequest
     * @return A Java Future containing the result of the InviteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.InviteMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InviteMembersResponse> inviteMembers(InviteMembersRequest inviteMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invites other AWS accounts to become member accounts for the Security Hub master account that the invitation is
     * sent from. Before you can use this action to invite a member, you must first create the member account in
     * Security Hub by using the <a>CreateMembers</a> action. When the account owner accepts the invitation to become a
     * member account and enables Security Hub, the master account can view the findings generated from member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InviteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link InviteMembersRequest#builder()}
     * </p>
     *
     * @param inviteMembersRequest
     *        A {@link Consumer} that will call methods on {@link InviteMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InviteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.InviteMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InviteMembersResponse> inviteMembers(Consumer<InviteMembersRequest.Builder> inviteMembersRequest) {
        return inviteMembers(InviteMembersRequest.builder().applyMutation(inviteMembersRequest).build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) whose findings you have subscribed to receive in Security Hub.
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     * @return A Java Future containing the result of the ListEnabledProductsForImport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledProductsForImportResponse> listEnabledProductsForImport(
            ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) whose findings you have subscribed to receive in Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledProductsForImportRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnabledProductsForImportRequest#builder()}
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     *        A {@link Consumer} that will call methods on {@link ListEnabledProductsForImportRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListEnabledProductsForImport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledProductsForImportResponse> listEnabledProductsForImport(
            Consumer<ListEnabledProductsForImportRequest.Builder> listEnabledProductsForImportRequest) {
        return listEnabledProductsForImport(ListEnabledProductsForImportRequest.builder()
                .applyMutation(listEnabledProductsForImportRequest).build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) whose findings you have subscribed to receive in Security Hub.
     * </p>
     *
     * @return A Java Future containing the result of the ListEnabledProductsForImport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledProductsForImportResponse> listEnabledProductsForImport() {
        return listEnabledProductsForImport(ListEnabledProductsForImportRequest.builder().build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) whose findings you have subscribed to receive in Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportPublisher listEnabledProductsForImportPaginator() {
        return listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest.builder().build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) whose findings you have subscribed to receive in Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportPublisher listEnabledProductsForImportPaginator(
            ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) whose findings you have subscribed to receive in Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledProductsForImportRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnabledProductsForImportRequest#builder()}
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     *        A {@link Consumer} that will call methods on {@link ListEnabledProductsForImportRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportPublisher listEnabledProductsForImportPaginator(
            Consumer<ListEnabledProductsForImportRequest.Builder> listEnabledProductsForImportRequest) {
        return listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest.builder()
                .applyMutation(listEnabledProductsForImportRequest).build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     *
     * @param listInvitationsRequest
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(
            Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations() {
        return listInvitations(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub master account.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub master account.
     * </p>
     *
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers() {
        return listMembers(ListMembersRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the name and description of a custom action target in Security Hub.
     * </p>
     *
     * @param updateActionTargetRequest
     * @return A Java Future containing the result of the UpdateActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateActionTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateActionTargetResponse> updateActionTarget(UpdateActionTargetRequest updateActionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and description of a custom action target in Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateActionTargetRequest#builder()}
     * </p>
     *
     * @param updateActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateActionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateActionTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateActionTargetResponse> updateActionTarget(
            Consumer<UpdateActionTargetRequest.Builder> updateActionTargetRequest) {
        return updateActionTarget(UpdateActionTargetRequest.builder().applyMutation(updateActionTargetRequest).build());
    }

    /**
     * <p>
     * Updates the <code>Note</code> and <code>RecordState</code> of the Security Hub-aggregated findings that the
     * filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     * </p>
     *
     * @param updateFindingsRequest
     * @return A Java Future containing the result of the UpdateFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFindingsResponse> updateFindings(UpdateFindingsRequest updateFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the <code>Note</code> and <code>RecordState</code> of the Security Hub-aggregated findings that the
     * filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFindingsRequest#builder()}
     * </p>
     *
     * @param updateFindingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFindingsResponse> updateFindings(Consumer<UpdateFindingsRequest.Builder> updateFindingsRequest) {
        return updateFindings(UpdateFindingsRequest.builder().applyMutation(updateFindingsRequest).build());
    }

    /**
     * <p>
     * Updates the Security Hub insight that the insight ARN specifies.
     * </p>
     *
     * @param updateInsightRequest
     * @return A Java Future containing the result of the UpdateInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateInsight
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInsightResponse> updateInsight(UpdateInsightRequest updateInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Security Hub insight that the insight ARN specifies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInsightRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInsightRequest#builder()}
     * </p>
     *
     * @param updateInsightRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInsightRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateInsight
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInsightResponse> updateInsight(Consumer<UpdateInsightRequest.Builder> updateInsightRequest) {
        return updateInsight(UpdateInsightRequest.builder().applyMutation(updateInsightRequest).build());
    }

    /**
     * <p>
     * Used to control whether an individual compliance standard control is enabled or disabled.
     * </p>
     *
     * @param updateStandardsControlRequest
     * @return A Java Future containing the result of the UpdateStandardsControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateStandardsControl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStandardsControlResponse> updateStandardsControl(
            UpdateStandardsControlRequest updateStandardsControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to control whether an individual compliance standard control is enabled or disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStandardsControlRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStandardsControlRequest#builder()}
     * </p>
     *
     * @param updateStandardsControlRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStandardsControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStandardsControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException AWS Security Hub isn't enabled for the account used to make this request.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateStandardsControl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStandardsControlResponse> updateStandardsControl(
            Consumer<UpdateStandardsControlRequest.Builder> updateStandardsControlRequest) {
        return updateStandardsControl(UpdateStandardsControlRequest.builder().applyMutation(updateStandardsControlRequest)
                .build());
    }
}
