/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecretRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<DescribeSecretRequest.Builder, DescribeSecretRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSecretRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD));

    private final String secretId;

    private DescribeSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
    }

    /**
     * <p>
     * The identifier of the secret whose details you want to retrieve. You can specify either the Amazon Resource Name
     * (ARN) or the friendly name of the secret.
     * </p>
     * <note>
     * <p>
     * If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial ARN
     * too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager adds at the
     * end of the ARN when you created the secret. A partial ARN match can work as long as it uniquely matches only one
     * secret. However, if your secret has a name that ends in a hyphen followed by six characters (before Secrets
     * Manager adds the hyphen and six characters to the ARN) and you try to use that as a partial ARN, then those
     * characters cause Secrets Manager to assume that you’re specifying a complete ARN. This confusion can cause
     * unexpected results. To avoid this situation, we recommend that you don’t create secret names that end with a
     * hyphen followed by six characters.
     * </p>
     * </note>
     * 
     * @return The identifier of the secret whose details you want to retrieve. You can specify either the Amazon
     *         Resource Name (ARN) or the friendly name of the secret.</p> <note>
     *         <p>
     *         If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial
     *         ARN too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager
     *         adds at the end of the ARN when you created the secret. A partial ARN match can work as long as it
     *         uniquely matches only one secret. However, if your secret has a name that ends in a hyphen followed by
     *         six characters (before Secrets Manager adds the hyphen and six characters to the ARN) and you try to use
     *         that as a partial ARN, then those characters cause Secrets Manager to assume that you’re specifying a
     *         complete ARN. This confusion can cause unexpected results. To avoid this situation, we recommend that you
     *         don’t create secret names that end with a hyphen followed by six characters.
     *         </p>
     */
    public String secretId() {
        return secretId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecretRequest)) {
            return false;
        }
        DescribeSecretRequest other = (DescribeSecretRequest) obj;
        return Objects.equals(secretId(), other.secretId());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSecretRequest").add("SecretId", secretId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecretRequest, T> g) {
        return obj -> g.apply((DescribeSecretRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSecretRequest> {
        /**
         * <p>
         * The identifier of the secret whose details you want to retrieve. You can specify either the Amazon Resource
         * Name (ARN) or the friendly name of the secret.
         * </p>
         * <note>
         * <p>
         * If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial ARN
         * too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager adds at
         * the end of the ARN when you created the secret. A partial ARN match can work as long as it uniquely matches
         * only one secret. However, if your secret has a name that ends in a hyphen followed by six characters (before
         * Secrets Manager adds the hyphen and six characters to the ARN) and you try to use that as a partial ARN, then
         * those characters cause Secrets Manager to assume that you’re specifying a complete ARN. This confusion can
         * cause unexpected results. To avoid this situation, we recommend that you don’t create secret names that end
         * with a hyphen followed by six characters.
         * </p>
         * </note>
         * 
         * @param secretId
         *        The identifier of the secret whose details you want to retrieve. You can specify either the Amazon
         *        Resource Name (ARN) or the friendly name of the secret.</p> <note>
         *        <p>
         *        If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a
         *        partial ARN too—for example, if you don’t include the final hyphen and six random characters that
         *        Secrets Manager adds at the end of the ARN when you created the secret. A partial ARN match can work
         *        as long as it uniquely matches only one secret. However, if your secret has a name that ends in a
         *        hyphen followed by six characters (before Secrets Manager adds the hyphen and six characters to the
         *        ARN) and you try to use that as a partial ARN, then those characters cause Secrets Manager to assume
         *        that you’re specifying a complete ARN. This confusion can cause unexpected results. To avoid this
         *        situation, we recommend that you don’t create secret names that end with a hyphen followed by six
         *        characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecretRequest model) {
            super(model);
            secretId(model.secretId);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSecretRequest build() {
            return new DescribeSecretRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
