/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutResourcePolicyRequestModelMarshaller {
    private static final MarshallingInfo<String> SECRETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourcePolicy").isBinary(false).build();
    private static final PutResourcePolicyRequestModelMarshaller INSTANCE = new PutResourcePolicyRequestModelMarshaller();

    private PutResourcePolicyRequestModelMarshaller() {
    }

    public static PutResourcePolicyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutResourcePolicyRequest putResourcePolicyRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putResourcePolicyRequest), (String)"putResourcePolicyRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putResourcePolicyRequest.secretId(), SECRETID_BINDING);
            protocolMarshaller.marshall((Object)putResourcePolicyRequest.resourcePolicy(), RESOURCEPOLICY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

