/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SecretVersionsListEntryMarshaller {
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").isBinary(false).build();
    private static final MarshallingInfo<List> VERSIONSTAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionStages").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTACCESSEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").isBinary(false).build();
    private static final SecretVersionsListEntryMarshaller INSTANCE = new SecretVersionsListEntryMarshaller();

    private SecretVersionsListEntryMarshaller() {
    }

    public static SecretVersionsListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecretVersionsListEntry secretVersionsListEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)secretVersionsListEntry, (String)"secretVersionsListEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)secretVersionsListEntry.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall(secretVersionsListEntry.versionStages(), VERSIONSTAGES_BINDING);
            protocolMarshaller.marshall((Object)secretVersionsListEntry.lastAccessedDate(), LASTACCESSEDDATE_BINDING);
            protocolMarshaller.marshall((Object)secretVersionsListEntry.createdDate(), CREATEDDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

