/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SecretListEntryMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ARN").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ROTATIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> ROTATIONLAMBDAARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationLambdaARN").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ROTATIONRULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationRules").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTROTATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastRotatedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTCHANGEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastChangedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTACCESSEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> DELETEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeletedDate").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final MarshallingInfo<Map> SECRETVERSIONSTOSTAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretVersionsToStages").isBinary(false).build();
    private static final SecretListEntryMarshaller INSTANCE = new SecretListEntryMarshaller();

    private SecretListEntryMarshaller() {
    }

    public static SecretListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecretListEntry secretListEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)secretListEntry, (String)"secretListEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)secretListEntry.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.rotationEnabled(), ROTATIONENABLED_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.rotationLambdaARN(), ROTATIONLAMBDAARN_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.rotationRules(), ROTATIONRULES_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.lastRotatedDate(), LASTROTATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.lastChangedDate(), LASTCHANGEDDATE_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.lastAccessedDate(), LASTACCESSEDDATE_BINDING);
            protocolMarshaller.marshall((Object)secretListEntry.deletedDate(), DELETEDDATE_BINDING);
            protocolMarshaller.marshall(secretListEntry.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(secretListEntry.secretVersionsToStages(), SECRETVERSIONSTOSTAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

